// Require
var fs = require("fs");
var os = require('os');
var consolewarn = console.warn, consoleinfo = console.info, consolelog = console.log, consoleerror = console.error;

var logFile, logFileError, tmp_folder, app, _m = {};
/**
 * THIS is REALLY a BAD way to handle errors BUT.... at least we can have the timestamp!
 */
process.on('uncaughtException', function (err) {
	console.error('UNCAUGHT ERROR: ' + err.message, err);
	//if (app) app.exit(1); else process.exit(1);
});

process.on("SIGTERM", function () {
	console.warn('CLOSING [SIGTERM]');
	if (app) app.exit(1); else process.exit(1);
});
process.on("SIGINT", function () {
	console.warn('CLOSING [SIGINT]');
	if (app) app.exit(1); else process.exit(1);
});
process.on('message', function (msg) {
	console.warn('process.message', msg);

});
String.prototype.replaceAppAndModulesPath = function () {
	let a = this.replace(/chrome\-extension\:\/\/[a-z0-9\-]+\//i, '').replace(/.*\\nw([\d_]+)\\\\/, '');
	if (!App || !App.baseDir)
		return a.split('technopos-nwjs/').pop();
	return a.replace(__dirname, '').replace(App.baseDir, '').replace(/\/modules/g, '').replace('node_modules/pwmCore', 'core').replace(/\/\//g, '/');
};
console.log = function () {
	try {
		var
			time = new Date().toISOString(),
			stk = (new Error()).stack,
			fn = '', fnl = '',
			_level = consolelog, _L = 'VERBOSE',
			file = '',
			line = '',
			_fore = '\x1b[38;5;250m'; //https://en.wikipedia.org/wiki/ANSI_escape_code#Colors
		if (stk.indexOf('Console.console.info') != -1) {
			_level = consoleinfo;
			_L = 'INFO';
			//_fore='\x1b[34m';
			_fore = '\x1b[38;5;33m';
			if (App && App.cfg && App.logLevels.I.level < App.cfg.loglevel)
				return;
		}
		else if (stk.indexOf('Console.console.warn') != -1) {
			_level = consolewarn;
			_L = 'WARN';
			_fore = '\x1b[33m';
			if (App && App.cfg && App.logLevels.W.level < App.cfg.loglevel)
				return;
		}
		else if (stk.indexOf('Console.console.error') != -1) {
			_level = consoleerror;
			_L = 'CRITICAL';
			_fore = '\x1b[31m';
			if (App && App.cfg && App.logLevels.E.level < App.cfg.loglevel)
				return;
		}

		_fore = '';//remove colors since it's chromium

		if (!Array.isArray(stk)) {
			stk = stk.replace(/\.\(anonymous function\)/g, '');
			var _fnl = 1;
			try {
				do {
					fnl = stk.match(/at (\S+)/g)[_fnl];
					fn = fnl.slice(3);
					_fnl++;
				}
				while (fn.indexOf('Console.console') != -1 || fn.indexOf('Object.tryCatch') != -1 || fn.indexOf('ontimeout') != -1 || fn.indexOf('routeEventToSubmodule') != -1);
			}
			catch (er) { consoleerror(er); }
			fn = fn.replace(/\(/g, '').replace(/\./g, '\\.');
			var re = new RegExp("at " + fn + ".*", 'gm');
			var stkln = stk.match(re);
			if (stkln) {
				var _stkln = stkln[0].match(/\((\S+):(\d+):(\d+)\)/);
				if (_stkln) {

					file = _stkln[1].replaceAppAndModulesPath();
					line = _stkln[2];
				}
				else {
					_stkln = stkln[0].match(/(\S+):(\d+):(\d+)/);
					if (_stkln) {
						file = _stkln[1].replaceAppAndModulesPath();
						line = _stkln[2];
					}
				}
			}
			if (fn && fn.indexOf('/') != -1)
				fn = '';
			if (fn.indexOf('Object.') === 0 || fn.indexOf('Object\\.') === 0) {
				var re = new RegExp("at " + fn + ".*", 'gm');
				var fnm = stk.match(re);
				fn = (fnm[0] || '').split('/').pop().split(':')[0].replace('.js', '') + fn.replace('Object', '');
			}
		}
		fn = fn.replace(/\\\./g, '.');
		file = file.replaceAppAndModulesPath();
		if (!file && fn && fn.match(/[a-z0-9\-_]+\.js\:[\d]+\:[\d]+$/)) {
			file = '' + fn.replaceAppAndModulesPath();
			fn = '';
		}

		var fileinf = (fn ? '@' + fn + ' ' : '') + file + ':' + line,
			mainArguments = Array.prototype.slice.call(arguments);
		var
			jsonLogStr = JSON.stringify({
				date: time, level: _L,
				message: mainArguments.length == 1 ? app.JSON.parse(mainArguments[0]) : Object.keys(mainArguments).map(function (k) { return app.JSON.parse(mainArguments[k]); }),
				file: file + ':' + line, metadata: '', namespace: '', functionName: fn || ''
			});
		if (logFile && jsonLogStr.indexOf('LogRotate: file ') == -1) {
			logFile.write(jsonLogStr + os.EOL);
			if (['CRITICAL', 'WARN'].indexOf(_L) != -1) {
				logFileError.write(jsonLogStr + os.EOL);
			}
		}

		if (App && App.cfg && App.cfg.logs && App.cfg.logs.format == 'json') {

			_level(_fore + jsonLogStr + (_fore ? '\x1b[0m' : ''));
			return;
		}
		mainArguments.unshift(_fore + time + ' - [' + _L + '] - ');
		mainArguments.push(fileinf + (_fore ? '\x1b[0m' : ''));
		_level.apply(null, mainArguments);
	}
	catch (er) {
		consoleerror(er.message || er, arguments)
	}
};
console.logRaw = function () {
	var mainArguments = Array.prototype.slice.call(arguments)
	consolelog.apply(null, mainArguments);
};
console.info = function () {
	var mainArguments = Array.prototype.slice.call(arguments)
	console.log.apply(null, mainArguments);
};
console.warn = function () {
	var mainArguments = Array.prototype.slice.call(arguments)
	console.log.apply(null, mainArguments);
};
console.error = function () {
	var mainArguments = Array.prototype.slice.call(arguments)
	console.log.apply(null, mainArguments);
};
_m.xtend = require(__dirname + '/libs/cloneextend.js');
try {
	_m.mkdirp = require('mkdirp');
} catch (er) { throw er; }
try {
	_m.path = require('path');
} catch (er) { throw er; }
try {
	_m.async = require('async');
} catch (er) { throw er; }
try {
	_m.childProcess = require('child_process');
} catch (er) { throw er; }
try {
	_m.exec = _m.childProcess.exec;
} catch (er) { throw er; }
try {
	_m.spawn = _m.childProcess.spawn;
} catch (er) { throw er; }
try {
	_m.osUtils = require('os-utils');
} catch (er) { throw er; }

try {
	_m.logrotate = require('logrotator');
} catch (er) { throw er; }
class App {
	constructor() {
		app = this;
		_m.fs = fs;
		_m.os = os;
		app._m = _m;
		this.isLinuxDev = ['AzimutPOS_Updater', 'AzimutPOS_Updater.exe'].indexOf(process.argv[0].replace(/\\/g, '/').split('/').pop()) == -1 && process.argv[0].indexOf('/AzimutPOS_Updater.app/') == -1;

		tmp_folder = _m.os.tmpdir() + '/AzimutPOS/';
		var platform;
		try {
			let _p = _m.os.platform();
			platform = (_p == 'darwin' ? 'osx64' : _p);
			if (platform.indexOf('win') != -1) {
				if (_m.os.arch() == 'x64')
					platform = 'win64';
				tmp_folder = '' + process.env.TEMP + '\\AzimutPOS\\';
			}
		}
		catch (e) {
		}
		if (platform == 'linux') platform = 'linux64';

		let _tposPath = fs.existsSync('C:\\Program Files (x86)\\AzimutPOS\\') ? 'C:\\Program Files (x86)\\AzimutPOS\\' : 'C:\\Program Files\\AzimutPOS\\';
		app.baseDir = (this.isLinuxDev ? __dirname : (platform.indexOf('win') != -1 ? _tposPath : _m.path.dirname(process.argv[0]))).replace(/\/\//g, '/');
		app.rootDir = '' + app.baseDir;

		if (platform.indexOf('linux') != -1) {
			app.baseDir = process.argv[1] || fs.existsSync('/opt/AzimutPOS') ? '/opt/AzimutPOS/' : '/home/' + os.userInfo().username + '/AzimutPOS/';
			app.rootDir = '' + app.baseDir;
		}
		if (platform.indexOf('osx') != -1) {
			app.rootDir = process.argv[1] || '/Applications/AzimutPOS.app/';
			app.baseDir = app.rootDir + 'Contents/Resources/app.nw/';
		}

		app.platform = platform;

		_m.fs.mkdir(app.baseDir + 'logs', function (err) {
			if (err && err.code != 'EEXIST') {
				console.error("Error creating tmp folder " + app.baseDir + 'logs' + ', ' + (err.message || err.code || err));

				return;
			}


			logFile = fs.createWriteStream(app.baseDir + 'logs/updater.log', { flags: 'a' });
			logFileError = fs.createWriteStream(app.baseDir + 'logs/updater_error.log', { flags: 'a' });

			try {
				fs.access(app.baseDir + 'logs/updater.log', fs.constants.F_OK | fs.constants.R_OK, function (err) {
					if (err) {
						console.error(app.baseDir + 'logs/updater.log', err.code);
					} else {
						try {
							app.logRorate = _m.logrotate.create();
							app.logRorate.register(app.baseDir + 'logs/updater.log', _m.xtend.extend({ schedule: '5m', size: '5m', compress: true, count: 5 }, {}));
							app.logRorate.on('rotate', function (file) {
								console.info('LogRotate: file ' + file + ' was rotated!');
							});
						} catch (er) { console.error('logRotator', _f.name, er.message); }
					}
				});
			} catch (er) { }
			try {
				fs.access(app.baseDir + 'logs/app_error.log', fs.constants.F_OK | fs.constants.R_OK, function (err) {
					if (err) {
						console.error(app.baseDir + 'logs/app_error.log', err.code);
					} else {
						try {
							app.logRorateError = _m.logrotate.create();
							app.logRorateError.register(app.baseDir + 'logs/app_error.log', _m.xtend.extend({ schedule: '5m', size: '5m', compress: true, count: 5 }, {}));
							app.logRorateError.on('rotate', function (file) {
								console.info('LogRotate: file ' + file + ' was rotated!');
							});
						} catch (er) { console.error('logRotator', _f.name, er.message); }
					}
				});
			} catch (er) { }


			logFile.write(os.EOL + os.EOL + os.EOL + "Updater started at " + new Date().toISOString() + os.EOL);
			app.logFile = logFile;


			app.locales = null;
			app.locale = "fr_CA";
			app.logLevels = {
				'L': {
					level: 0, //always log (default)
					name: 'VERBOSE',
					wname: 'silly'
				},
				'I': {
					level: 1,
					name: 'INFO',
					wname: 'verbose'
				},
				'D': {
					level: 2,
					name: 'DEBUG',
					wname: 'info'
				},
				'W': {
					level: 3,
					name: 'WARN',
					wname: 'warn'
				},
				'E': {
					level: 4,
					name: 'ERROR',
					wname: 'error'
				},
				'C': {
					level: 5,
					name: 'CRITICAL',
					wname: 'error'
				},
			};
			app.initialize();
		});

	}
	initialize() {
		_m.mkdirp(tmp_folder, function (err) {
			if (err && err.code != 'EEXIST') {
				console.error("Error creating tmp folder " + tmp_folder + ', ' + (err.message || err.code || err));
				return;
			}
			console.info("Created tmp folder " + tmp_folder);
			app.tmp_folder = tmp_folder;

			app.cfg = {};
			if (fs.existsSync(app.baseDir + 'etc/config.json'))
				app.cfg = JSON.parse(fs.readFileSync(app.baseDir + 'etc/config.json').toString());
			else console.warn('Couldnt load "' + app.baseDir + 'etc/config.json' + '"')
			if (!app.cfg.loglevel) app.cfg.loglevel = 3;


			let _consolelog = console.log;
			fs.readFile(process.cwd() + '/libs/locales.json', function (err, locales) {
				app.locales = JSON.parse(locales);
				app.url = 'assets/updater.html';

				nw.Window.open(app.url, {
					title: "AzimutPOS Updater",
					frame: false,
					width: 637,
					height: 637
				}, function (win) {
					app.win = win;
					app.win.on('loaded', function () {
						_consolelog('POS_UPDATER_READY') //this log is important
						app.win.window.setInitMessage(app.parseLocales('steps.label'));
						app.win.window.setMessage(app.parseLocales('steps.init'));
						//self.splash_timeout = setInterval(timeout, 700);
						process.nextTick(function () {
							if (app.platform.indexOf('win') != -1 && !fs.existsSync('C:\\Program Files (x86)\\AzimutPOS\\') && !fs.existsSync('C:\\Program Files\\AzimutPOS\\')) {
								console.error("'C:\\Program Files (x86)\\AzimutPOS\\' NOT FOUND")
								app.win.window.throwalert("Couldn't find base directory 'C:\\Program Files (x86)\\AzimutPOS\\' OR 'C:\\Program Files\\AzimutPOS\\'.");
								app.exit(1);
								return;
							}
							if (app.platform.indexOf('linux') != -1 && !fs.existsSync(app.baseDir)) {
								console.error("'" + app.baseDir + "' NOT FOUND")
								app.win.window.throwalert("Couldn't find base directory '" + app.baseDir + "'.");
								app.exit(1);
								return;
							}
							if ((app.platform.indexOf('mac') != -1 || app.platform.indexOf('osx') != -1) && !fs.existsSync(app.baseDir)) {
								console.error("'" + app.baseDir + "' NOT FOUND")
								app.win.window.throwalert("Couldn't find base directory '" + app.baseDir + "'.");
								app.exit(1);
								return;
							}
							if (!fs.existsSync(app.baseDir + '/updates/package_remote.json')) {
								console.error("'" + app.baseDir + "/updates/package_remote.json' NOT FOUND")
								app.win.window.throwalert("Couldn't find package file, please run AzimutPOS first.");
								app.exit(1);
								return;
							}
							app.package = JSON.parse(fs.readFileSync(app.baseDir + 'updates/package_remote.json').toString())
							console.log(app.package);
							setTimeout(function () {
								if (!app.package) {
									app.win.window.throwalert('Required update information not found.');
									//app.exit(1);
									return;
								}
								if (app.platform.indexOf('win') != -1) {
									app.updater = require(__dirname + '/libs/windows/windows');
									app.updater.init(app);
									return;
								}
								if (app.platform.indexOf('mac') != -1 || app.platform.indexOf('osx') != -1) {
									app.updater = require(__dirname + '/libs/mac/mac');
									app.updater.init(app);
									return;
								}
								app.updater = require(__dirname + '/libs/linux/linux');
								app.updater.init(app);
							}, 1000 * 3);
						});
					});
					app.win.on("closed", function () {
						//clearInterval(self.splash_timeout);
					});
				});

			});
		});
	}


	parseLocales(path, locale) {
		if (!locale)
			locale = this.locale;
		if (typeof path == "string")
			path = path.split('.');
		if (path[0] == 'locales')
			path.pop();
		var locales = this.locales;
		for (let p = 0; p < path.length; p++)
			locales = locales[path[p]];
		return locales[locale];
	}

	exit(exitCode) {
		if (typeof exitCode != 'number')
			exitCode = 0;
		//do Things
		logFile.write('EXIT CODE ' + exitCode + "\n");
		setTimeout(function () {
			logFile.close();
			if (app.win) app.win.close();
			setTimeout(function () {
				process.exit(exitCode);
			}, 300);
		}, 100);
	}

	pathExists(o, p) { // app.pathExists()
		if (!o || !p) return false;
		p = p + '';
		var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
		if (m.length > 1 && !m[0])
			m.shift();
		var cm = o;
		for (var i = 0; i < m.length; i++) { // Here we need to take special care of possible method calls and arrays, but I am too lazy to write it down.
			if (cm == null)
				return false;
			if (typeof cm[m[i]] !== 'undefined')//if(currentMember.hasOwnProperty(members[i]))
				cm = cm[m[i]];
			else
				return false;
		}
		return cm;
	}
}
app = new App();
app.JSON = {

	parse: function (json) { //core.JSON.parse
		if (!json || typeof json != 'string')
			return json;
		json = json.trim();
		if (json.charAt(0) == '"' && json.charAt(json.length - 1) == '"') {
			do {
				json = json.substring(1);
				json = json.substring(0, json.length - 1);
			}
			while (json.charAt(0) == '"' && json.charAt(json.length - 1) == '"');
		}
		//return (typeof json=='string' && ['{','['].indexOf(json.charAt(0)))?core.JSON.validate(json):json;
		return app.JSON.validate(json) || json;
	},
	validate: function (str) { //core.JSON.validate
		if (!str)
			return false;
		if (typeof str == 'object') {
			return app.JSON.validate(JSON.stringify(str));
		}
		try {
			return JSON.parse(str.trim().replace(/\\n/g, '\\\\n').replace(/([a-z0-9])\\([a-z0-9])/gi, '$1 $2').replace(/\\\\n/g, '\\n'));
		} catch (e) {
			return false;
		}
		return true;
	}
};
