let
	CP = require('child_process'),
	crypto = require('crypto'),
	fs = require("fs-extra"),
	os = require('os');
process.send({ action: 'ready' });
process.on('message', function (msg) {
	if (msg.action) {
		switch (msg.action) {
			case 'File':
				if (typeof msg.cipher == 'undefined' || !msg.cipher)
					msg.cipher = 'sha1';
				let _fallBack = () => {
					var data = fs.readFileSync(msg.path).toString();
					process.send({ action: 'completed', data: crypto.createHash(msg.cipher).update(data).digest('hex') });
					process.exit(0);
				}
				if (os.platform().indexOf('win') === 0) {
					CP.exec('Get-FileHash -Path "' + msg.path + '" -Algorithm ' + msg.cipher.toUpperCase() + ' | Select-Object Hash | Format-List', function (e, o, s) {
						if (o?.trim() && /hash[\s]+\:[\s]+([a-z0-9]+)/.test(o.trim().toLowerCase())) {
							let _d = o.trim().toLowerCase().split('\n').filter((a) => { return a?.indexOf('hash') != -1 });
							for (let d of _d) {
								let _m = d?.match(/hash[\s]+\:[\s]+([a-z0-9]+)/);
								if (_m?.[1]) {
									process.send({ action: 'completed', data: _m?.[1]?.trim() });
									process.exit(0);
									return;
								}
							}
						}

						CP.exec('certutil -hashfile "' + msg.path + '" ' + msg.cipher.toUpperCase(), function (e, o, s) {
							if (o?.trim() && o.indexOf('command completed successfully') != -1) {
								process.send({ action: 'completed', data: o?.trim().split('\n')[1].replace(/\s/g, '') });
								process.exit(0);
								return;
							}
							_fallBack();
						});
					});
					return;
				}
				CP.exec(msg.cipher + 'sum ' + msg.path + " | awk -F ' ' '{print $1}'", function (e, o, s) {
					if (o?.trim()) {
						process.send({ action: 'completed', data: o?.trim() });
						process.exit(0);
						return;
					}
					CP.exec('openssl ' + msg.cipher + ' ' + msg.path + " | awk -F '= ' '{print $2}'", function (e, o, s) {
						if (o?.trim()) {
							process.send({ action: 'completed', data: o?.trim() });
							process.exit(0);
							return;
						}

						_fallBack();
					});
				})
				break;
			case 'String':
				if (typeof msg.cipher == 'undefined' || !msg.cipher)
					msg.cipher = 'sha1';
				process.send({ action: 'completed', data: msg.data ? crypto.createHash(msg.cipher).update(msg.data).digest('hex') : null });
				process.exit(0);
				break;
			default:
				console.log('message', msg);
		}
		return;
	}
	console.log('message', msg);
});