var app, self;
module.exports = class Splashscreen {
	constructor(parent) {
		//Setting splascScreen url
		if (parent) {
			app = parent;
		}
		this.url = app._relativePath + 'libs/splashscreen/splashscreen.html';
		self = this;
		self.timedOut = false;
		self._ready = false;
		self._data = {};
		self._step = 0;
		self._delay = 0;
		self._steps = 4;
	}
	initialize(cback) {
		nw.Window.open(self.url, {
			title: "AzimutPOS is starting",
			position: "center",
			frame: false,
			resizable: false,
			width: 635,
			height: 635
		}, function (win) {
			self.win = win;
			win.setPosition('center');
			self.win.on('loaded', function () {
				win.show();
				win.setPosition('center');
				self.win.window.setMessage(app.parseLocales('splash.startup_steps.init'));
				try {
					cback();
				} catch (er) {
					console.error(er)
				}
				win.show();
				//wait for main thread to call step1

				win.window.message = function (d) {
					switch (d.action) {
						case 'runSystemDiag':
							app.diag.run();
							break;
						case 'close':

							app.exit(0);
							break;
					}
				};
			});

			self.win.on("closed", function () {
				clearInterval(self.splash_timeout);
			});
		});
	}
	step1() {
		var _channel = app.pathExists(app, 'data.session.configs.advanced.updates.channel');
		if (!_channel) _channel = '' + app.cfg.channel.split('/').pop();
		self.win.window.setVersion(app.cfg.version + ' (' + (_channel ? _channel + '/' : '') + app.cfg.platform + ')' + (process.versions["nw-flavor"] == 'sdk' ? ' SDK' : '') + ' ' + app._m.moment(app.cfg.buildDate).format('YYMMDD-HHmmss'));
		self.win.window.setBuildYear(app._m.moment(app.cfg.buildDate).format('YYYY'));
		self.win.window.setMessage(app.parseLocales('splash.startup_steps.gathering_infos'));
		self.win.window.setProgress(5);
		//self.win.window.setMessage(app.parseLocales('splash.startup_steps.checking_updates'));
	}
	step2() {

		self.win.window.setProgress(20);
		if (self._step == self._steps) {
			self._loaded = true;
		}
		self._data.screens = self.getScreens();
		self.win.window.setProgress(30);

		self.win.window.setMessage(app.parseLocales('splash.startup_steps.gathering_printers'));
		self.getPrinters(function (printers) {
			self.win.window.setProgress(50);
			self._data.printers = printers;
			if (self._step == self._steps) {
				self._loaded = true;
			}

			app.web.emit({
				volatile: 1,
				module: 'sessions',
				action: 'startup_sequence',
				data: {
					module: 'splashscreen',
					action: 'checking_updates'
				},
				eventLoop: app.eventLoopLag._current,
				uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
				cpuInfo: app.system.vars.systemInfo.cpu
			});
			self.step3();
		});
	}
	step3() {

		self.win.window.setProgress(70);
		self.win.window.setMessage(app.parseLocales('splash.startup_steps.generating_rsa'));
		self.initialized();
		app.web.emit({
			volatile: 1,
			module: 'sessions',
			action: 'startup_sequence',
			data: {
				module: 'splashscreen',
				action: 'generating_rsa'
			},
			eventLoop: app.eventLoopLag._current,
			uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
			cpuInfo: app.system.vars.systemInfo.cpu
		});
	}

	initialized() {
		self._data.macAddress = app.system._data.macAddress;
		app.utilities = self._data;
		clearInterval(self.splash_timeout);
		if (self.isInitialized) {
			console.error('ALREADY INITIATED')
			return;
		}
		self.isInitialized = true;

		let _configLoaded = false, _loadedFromCache = false, _loadFromCacheTimer = setTimeout(function () {
			if (_configLoaded) return false;
			console.warn('splashscreen config _loadFromCacheTimer');
			app.system.localConfig.get(function (data) {
				if (data) {
					console.log('GOT LOCAL CONFIG', data);
					//if (app.pathExists(app.data.session, 'licence.mode')) return;
					_loadedFromCache = true;
					app.data.session = data;
					_parseConfigAndRun();
					//if (app.data.session.result == 'success') {
					//	_startPOS();
					//}
				}
			});
		}, 1000 * 20),
			_startPOS = function () {
				clearTimeout(_loadFromCacheTimer);
				console.log('splashscreen _startPOS called')
				let _daysLeft = 9999;
				if (app.pathExists(app.data.session, 'licence.mode') == 'trial') {
					setTimeout(function () {
						console.log('splashscreen _startPOS calling app.startPOS with config');//, app.data.session.configs)
						app.startPOS(app.data.session.configs);
					}, 3 * 1000);

					if (app.pathExists(app.data.session, 'licence.daysLeft'))
						_daysLeft = '<br/>' + app.data.session.licence.daysLeft + ' ' + app.parseLocales('splash.licence.trial.days_left');
					app.splashscreen.win.window.setMessage(app.parseLocales('splash.licence.trial.label') + _daysLeft);
					console.log('splashscreen _startPOS is trial', app.data.session.licence.daysLeft, ' days left');
					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'splashscreen',
							action: 'licence_warning',
							message: 'Licence is trial, ' + app.data.session.licence.daysLeft + ' days left'
						},
						eventLoop: app.eventLoopLag._current,
						uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						cpuInfo: app.system.vars.systemInfo.cpu
					});
					return;
				}
				if (app.pathExists(app.data.session, 'licence.overdue')) {
					try {
						let _expdate = app._m.moment(app.data.session.licence.onHoldDate + 'T06:00:00.000Z').tz(app.data.session.configs.location.timezone || 'America/New_York').startOf('day').add(-1, 'days').endOf('day');
						_daysLeft = _expdate.diff(app._m.moment().tz(app.data.session.configs.location.timezone || 'America/New_York').startOf('day'), 'days');
					} catch (er) { console.error(er.message + ' while calculating overdue days') }

				}
				if (app.pathExists(app.data.session, 'licence.onHold') || app.pathExists(app.data.session, 'licence.overdue') && !_daysLeft) {
					app.splashscreen.win.window.setOnHold({ message: app.parseLocales('splash.licence.onHold.message') });
					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'splashscreen',
							action: 'licence_warning',
							message: 'licence is on hold.'
						},
						eventLoop: app.eventLoopLag._current,
						uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						cpuInfo: app.system.vars.systemInfo.cpu
					});
					return;
				}
				if (app.pathExists(app.data.session, 'licence.overdue') && _daysLeft <= 15) {

					let _message = app.parseLocales('splash.licence.overdue.message') + '<br/><br/>' + _daysLeft + ' ' + app.parseLocales('splash.licence.trial.days_left');
					app.splashscreen.win.window.setOverdue({ message: _message, daysLeft: _daysLeft }, function () {

						app.startPOS(app.data.session.configs);
					});

					app.web.emit({
						volatile: 1,
						module: 'sessions',
						action: 'startup_sequence',
						data: {
							module: 'splashscreen',
							action: 'licence_warning',
							message: 'Account is overdue, ' + _daysLeft + ' days left'
						},
						eventLoop: app.eventLoopLag._current,
						uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
						cpuInfo: app.system.vars.systemInfo.cpu
					});
					return;
				}
				//return;
				console.log('splashscreen _startPOS calling app.startPOS with config')
				//app.data.session.configs
				app.startPOS(app.data.session.configs);
			};
		var _parseConfigAndRun = function () {
			_configLoaded = true;
			clearTimeout(_loadFromCacheTimer);
			//init pos.neighbors
			//app.pos.neighbors.initialize();
			if (app.data.session.result == 'wizard') {
				console.log('splashscreen doWhenInit show wizard')
				app.splashscreen.showWizard(app.data.session.code);
			} else if (app.data.session.result == 'success') {
				console.log('splashscreen doWhenInit success, call _startPOS')
				//sessions.socketIndexes[d.socket.id]
				//return;
				_startPOS();
			} else if (app.data.session.result == 'error') {
				_configLoaded = false;
				console.log('splashscreen doWhenInit ERROR', app.data.session)
				if (app.data.session?.licence?.onHold)
					app.splashscreen.win.window.setOnHold({ message: app.parseLocales('splash.licence.onHold.message') });
				else
					app.splashscreen.showError(app.data.session.code);
			}
			app.printManager.checkNetworkPrintersIPAddresses();
		}
		app.sessions.doWhenInit(function () {
			clearTimeout(_loadFromCacheTimer);
			console.log('splashscreen doWhenInit')
			if (_loadedFromCache) return;
			_parseConfigAndRun();

		});
		if (!app.sessions.initSent) {
			app.sessions.init();
		}
		app.sessions.onLicenceChange(function () {
			console.log('licence changed, _parseConfigAndRun')
			_parseConfigAndRun();
		})

	}

	appReady() {
		this.win.close();
	}

	getMACs(cback) {
		const macs = app._m.os.networkInterfaces();
		console.log(macs);
		console.log(Object.keys(macs));
		Object.keys(macs).map(function (key) {
			console.log(key)
		});
		var addr = '';
		// For each interface
		Object.keys(macs).map(function (key) {

			// For each address
			macs[key].forEach(function (element) {
				let mac = element.mac;
				if (mac != "00:00:00:00:00:00") {
					addr = mac;
					return false;
				}
				if (addr != '')
					return false;
			});
		});

		cback(addr.replace(/:/g, '').toUpperCase());
	}

	getPrinters(cback) {
		try {
			let _skips = ['ToFile', 'PDF', 'Fax', 'OneNote', 'Microsoft Print to PDF'],
				_finds = ['ToFile', 'Print to PDF', 'Fax', 'Foxit Phantom', 'OneNote', 'Microsoft XPS'],
				_fileData = { date: new Date().toISOString(), detected: [] };
			self.win.getPrinters(function (printers) {
				let out = [];
				_fileData.detected = printers;
				self._data._detected_printers = printers;
				app._m.async.each(printers, function (p, n) {
					if (_skips.indexOf(p.deviceName) != -1 || app.pathExists(p, 'printerOptions.cups-browsed') == 'true') {
						p.skipped = true;
						n();
						return;
					}
					for (let i = 0; i < _finds.length; i++) {
						if (p.deviceName.indexOf(_finds[i]) != -1) {
							p.skipped = true;
							n();
							return;
						}
					}
					app.hash.String(app.system.id + p.deviceName.replace(/[^0-9a-zA-Z\-_]/, '_').replace(/_+/g, '_'), function (id) {
						p.id = id;
						out.push(p);
						n();
					});
				}, function () {
					cback(out);
					app._m.fs.writeFile(app.cacheDir + 'detected_local_printers.json', JSON.stringify(_fileData, undefined, 4), function () { })
				});
			});
		} catch (er) { console.error('cannot get printers', er) }
	}

	getScreens() {
		var screens = nw?.Screen?.screens || [];
		screens.sort(function (a, b) {
			return a.bounds.x - b.bounds.x;
		});
		return screens;
	}

	showError(code) {
		try { self.win.window.showError(app.parseLocales('splash.session_error_codes.' + code)); } catch (er) { }
	}
	setMessage(message) {
		try { self.win.window.setMessage(app.parseLocales('splash.session_error_codes.' + message) || message); } catch (er) { }
	}

	showWizard(code) {
		try { self.win.window.showWizard(app.parseLocales('splash.activation_code'), code, app.parseLocales('splash.activation_loginto')); } catch (er) { }
	}
};