import { ProxySetting } from "./proxy-settings";
export declare class GetProxyError extends Error {
    proxy: ProxySetting;
    constructor(proxy: ProxySetting, message: string);
}
export declare class ProxyAuthenticationRequiredError extends GetProxyError {
    constructor(proxy: ProxySetting);
}
export declare class ProxyInvalidCredentialsError extends GetProxyError {
    constructor(proxy: ProxySetting);
}
/**
 * Error when the connection to the proxy failed ERRCONNREFUSED
 * Proxy might be down
 */
export declare class ProxyConnectionRefusedError extends GetProxyError {
    constructor(proxy: ProxySetting);
}
