var app, zip_in, win = {
	init: function (_app) {
		app = _app;
		win.file = app.pathExists(app, 'package.packages.' + app.platform + '.hash');
		if (win.file) {
			zip_in = '' + app.baseDir + 'updates\\' + win.file + '.zip';
			if (app._m.fs.existsSync(zip_in)) {
				win.update();
				return;
			}
		}
		app.win.window.throwalert('Update file not found.');
		//app.exit(1);
	},
	update: function () {
		app.win.window.setProgress(10);
		//copy 7zip to a temp dir
		win.unzip.sevenzip(function () {
			app.win.window.setProgress(30);
			//wait for pos to be killed
			win.waitKilled(function () {
				app.win.window.setProgress(40);
				//unzip new version
				win.unzip.unzip(function () {
					app.win.window.setProgress(90);
					//spawn app
					var child = app._m.spawn(app.baseDir + 'AzimutPOS.exe', [], { detached: true });
					let _parse = function (data) {
						data = data.toString();
						console.log('START AzimutPOS.exe', data);
					};
					child.stdout.on('data', _parse);
					child.stderr.on('data', _parse);
					setTimeout(function () {
						app.win.window.setMessage(app.parseLocales('steps.startApp'));
						app.win.window.setProgress(100);
					}, 2000);
					setTimeout(function () {
						child.unref();
						app.exit(0);
					}, 1000 * 30);
				});
			})

		});
		//})
	},
	unzip: {
		sevenzip: function (cback) {
			app._m.fs.unlink('' + app.tmp_folder + 'SevenZip', function (err) {
				app.win.window.setProgress(15);
				console.log('UNLINK "' + app.tmp_folder + 'SevenZip', err);
				_m.mkdirp('' + app.tmp_folder + 'SevenZip', function (err) {
					app.win.window.setProgress(25);
					console.log('MKDIR "' + app.tmp_folder + 'SevenZip', err);
					//let _cp = 'xcopy "' + app.baseDir + 'vendors\\SevenZip\\*" "' + app.tmp_folder + 'SevenZip\\"';
					let _args = [
						app.baseDir + 'vendors\\SevenZip\\*',
						app.tmp_folder + 'SevenZip\\',
						'/q', '/E', '/Y'
					]
					console.log('xcopy', _args)
					let xcp = app._m.spawn('xcopy', _args);
					xcp.stdout.on('data', (data) => {
						console.log('xcopy', data.toString());
					});

					xcp.stderr.on('data', (data) => {
						console.log('xcopy stderr', data.toString());
					});

					xcp.on('exit', (code) => {
						console.log(`xcopy exited with code ${code}`);
						if (code == 0)
							cback();
					});
					//, function (err, stdout, stderr) {
					//	console.log('xcopy "' + app.baseDir + 'vendors\\SevenZip\\*" "' + app.tmp_folder + '\\SevenZip\\" /E /Y', err, stdout, stderr);
					//

				});
			})
		},
		unzip: function (cback) {
			app.win.window.setProgress(50);
			app.win.window.setMessage(app.parseLocales('steps.extract'));
			let
				zip_out = '' + app.baseDir + '',
				_args = ['x', '-y', '' + zip_in + '', '-o' + zip_out],
				szip;
			console.log('7za', _args)
			szip = app._m.spawn('' + app.tmp_folder + 'SevenZip\\7za.exe',
				_args);
			szip.stdout.on('data', (data) => {
				console.log('UNZIP', data.toString());
			});

			szip.stderr.on('data', (data) => {
				console.log('UNZIP stderr', data.toString());
			});

			szip.on('exit', (code) => {
				console.log(`szip exited with code ${code}`);
				cback();
			});
		}
	},
	waitKilled: function (cback) {
		app._m.exec(__dirname + "/scripts/kill.bat", function (err, stdout, stderr) {
			console.log(err, stdout, stderr);
			cback();
		});
	}
};
module.exports = win;