/**
 * EasyQRCodeJS-NodeJS
 *
 * NodeJS QRCode generator. Can save image or svg to file, get standard base64 image data url text or get SVG serialized text. Cross-browser QRCode generator for pure javascript. Support Dot style, Logo, Background image, Colorful, Title etc. settings. support binary mode.(Running without DOM on server side)
 *
 * Version 4.4.5
 *
 * @author [ inthinkcolor@gmail.com ]
 *
 * @see https://github.com/ushelp/EasyQRCodeJS-NodeJS
 * @see http://www.easyproject.cn/easyqrcodejs/tryit.html
 * @see https://github.com/ushelp/EasyQRCodeJS
 *
 * Copyright 2017 Ray, EasyProject
 * Released under the MIT license
 *
 * [Node.js]
 *
 */
var{createCanvas:createCanvas,loadImage:loadImage,Image:Image}=require("canvas"),jsdom=require("jsdom"),C2S=require("./canvas2svg"),fs=require("fs"),{optimize:optimize}=require("svgo");const{JSDOM:JSDOM}=jsdom,win=(new JSDOM).window;function QR8bitByte(data,binary,utf8WithoutBOM){this.mode=QRMode.MODE_8BIT_BYTE,this.data=data,this.parsedData=[];for(var i=0,l=this.data.length;i<l;i++){var byteArray=[],code=this.data.charCodeAt(i);binary?byteArray[0]=code:code>65536?(byteArray[0]=240|(1835008&code)>>>18,byteArray[1]=128|(258048&code)>>>12,byteArray[2]=128|(4032&code)>>>6,byteArray[3]=128|63&code):code>2048?(byteArray[0]=224|(61440&code)>>>12,byteArray[1]=128|(4032&code)>>>6,byteArray[2]=128|63&code):code>128?(byteArray[0]=192|(1984&code)>>>6,byteArray[1]=128|63&code):byteArray[0]=code,this.parsedData.push(byteArray)}this.parsedData=Array.prototype.concat.apply([],this.parsedData),utf8WithoutBOM||this.parsedData.length==this.data.length||(this.parsedData.unshift(191),this.parsedData.unshift(187),this.parsedData.unshift(239))}function QRCodeModel(typeNumber,errorCorrectLevel){this.typeNumber=typeNumber,this.errorCorrectLevel=errorCorrectLevel,this.modules=null,this.moduleCount=0,this.dataCache=null,this.dataList=[]}QR8bitByte.prototype={getLength:function(buffer){return this.parsedData.length},write:function(buffer){for(var i=0,l=this.parsedData.length;i<l;i++)buffer.put(this.parsedData[i],8)}},QRCodeModel.prototype={addData:function(data,binary,utf8WithoutBOM){var newData=new QR8bitByte(data,binary,utf8WithoutBOM);this.dataList.push(newData),this.dataCache=null},isDark:function(row,col){if(row<0||this.moduleCount<=row||col<0||this.moduleCount<=col)throw new Error(row+","+col);return this.modules[row][col][0]},getEye:function(row,col){if(row<0||this.moduleCount<=row||col<0||this.moduleCount<=col)throw new Error(row+","+col);var block=this.modules[row][col];if(block[1]){var type="P"+block[1]+"_"+block[2];return"A"==block[2]&&(type="A"+block[1]),{isDarkBlock:block[0],type:type}}return null},getModuleCount:function(){return this.moduleCount},make:function(){this.makeImpl(!1,this.getBestMaskPattern())},makeImpl:function(test,maskPattern){this.moduleCount=4*this.typeNumber+17,this.modules=new Array(this.moduleCount);for(var row=0;row<this.moduleCount;row++){this.modules[row]=new Array(this.moduleCount);for(var col=0;col<this.moduleCount;col++)this.modules[row][col]=[]}this.setupPositionProbePattern(0,0,"TL"),this.setupPositionProbePattern(this.moduleCount-7,0,"BL"),this.setupPositionProbePattern(0,this.moduleCount-7,"TR"),this.setupPositionAdjustPattern("A"),this.setupTimingPattern(),this.setupTypeInfo(test,maskPattern),this.typeNumber>=7&&this.setupTypeNumber(test),null==this.dataCache&&(this.dataCache=QRCodeModel.createData(this.typeNumber,this.errorCorrectLevel,this.dataList)),this.mapData(this.dataCache,maskPattern)},setupPositionProbePattern:function(row,col,posName){for(var r=-1;r<=7;r++)if(!(row+r<=-1||this.moduleCount<=row+r))for(var c=-1;c<=7;c++)col+c<=-1||this.moduleCount<=col+c||(0<=r&&r<=6&&(0==c||6==c)||0<=c&&c<=6&&(0==r||6==r)||2<=r&&r<=4&&2<=c&&c<=4?(this.modules[row+r][col+c][0]=!0,this.modules[row+r][col+c][2]=posName,this.modules[row+r][col+c][1]=-0==r||-0==c||6==r||6==c?"O":"I"):this.modules[row+r][col+c][0]=!1)},getBestMaskPattern:function(){for(var minLostPoint=0,pattern=0,i=0;i<8;i++){this.makeImpl(!0,i);var lostPoint=QRUtil.getLostPoint(this);(0==i||minLostPoint>lostPoint)&&(minLostPoint=lostPoint,pattern=i)}return pattern},createMovieClip:function(target_mc,instance_name,depth){var qr_mc=target_mc.createEmptyMovieClip(instance_name,depth);this.make();for(var row=0;row<this.modules.length;row++)for(var y=1*row,col=0;col<this.modules[row].length;col++){var x=1*col;this.modules[row][col][0]&&(qr_mc.beginFill(0,100),qr_mc.moveTo(x,y),qr_mc.lineTo(x+1,y),qr_mc.lineTo(x+1,y+1),qr_mc.lineTo(x,y+1),qr_mc.endFill())}return qr_mc},setupTimingPattern:function(){for(var r=8;r<this.moduleCount-8;r++)null==this.modules[r][6][0]&&(this.modules[r][6][0]=r%2==0);for(var c=8;c<this.moduleCount-8;c++)null==this.modules[6][c][0]&&(this.modules[6][c][0]=c%2==0)},setupPositionAdjustPattern:function(posName){for(var pos=QRUtil.getPatternPosition(this.typeNumber),i=0;i<pos.length;i++)for(var j=0;j<pos.length;j++){var row=pos[i],col=pos[j];if(null==this.modules[row][col][0])for(var r=-2;r<=2;r++)for(var c=-2;c<=2;c++)-2==r||2==r||-2==c||2==c||0==r&&0==c?(this.modules[row+r][col+c][0]=!0,this.modules[row+r][col+c][2]=posName,this.modules[row+r][col+c][1]=-2==r||-2==c||2==r||2==c?"O":"I"):this.modules[row+r][col+c][0]=!1}},setupTypeNumber:function(test){for(var bits=QRUtil.getBCHTypeNumber(this.typeNumber),i=0;i<18;i++){var mod=!test&&1==(bits>>i&1);this.modules[Math.floor(i/3)][i%3+this.moduleCount-8-3][0]=mod}for(i=0;i<18;i++){mod=!test&&1==(bits>>i&1);this.modules[i%3+this.moduleCount-8-3][Math.floor(i/3)][0]=mod}},setupTypeInfo:function(test,maskPattern){for(var data=this.errorCorrectLevel<<3|maskPattern,bits=QRUtil.getBCHTypeInfo(data),i=0;i<15;i++){var mod=!test&&1==(bits>>i&1);i<6?this.modules[i][8][0]=mod:i<8?this.modules[i+1][8][0]=mod:this.modules[this.moduleCount-15+i][8][0]=mod}for(i=0;i<15;i++){mod=!test&&1==(bits>>i&1);i<8?this.modules[8][this.moduleCount-i-1][0]=mod:i<9?this.modules[8][15-i-1+1][0]=mod:this.modules[8][15-i-1][0]=mod}this.modules[this.moduleCount-8][8][0]=!test},mapData:function(data,maskPattern){for(var inc=-1,row=this.moduleCount-1,bitIndex=7,byteIndex=0,col=this.moduleCount-1;col>0;col-=2)for(6==col&&col--;;){for(var c=0;c<2;c++)if(null==this.modules[row][col-c][0]){var dark=!1;byteIndex<data.length&&(dark=1==(data[byteIndex]>>>bitIndex&1)),QRUtil.getMask(maskPattern,row,col-c)&&(dark=!dark),this.modules[row][col-c][0]=dark,-1==--bitIndex&&(byteIndex++,bitIndex=7)}if((row+=inc)<0||this.moduleCount<=row){row-=inc,inc=-inc;break}}}},QRCodeModel.PAD0=236,QRCodeModel.PAD1=17,QRCodeModel.createData=function(typeNumber,errorCorrectLevel,dataList){for(var rsBlocks=QRRSBlock.getRSBlocks(typeNumber,errorCorrectLevel),buffer=new QRBitBuffer,i=0;i<dataList.length;i++){var data=dataList[i];buffer.put(data.mode,4),buffer.put(data.getLength(),QRUtil.getLengthInBits(data.mode,typeNumber)),data.write(buffer)}var totalDataCount=0;for(i=0;i<rsBlocks.length;i++)totalDataCount+=rsBlocks[i].dataCount;if(buffer.getLengthInBits()>8*totalDataCount)throw new Error("code length overflow. ("+buffer.getLengthInBits()+">"+8*totalDataCount+")");for(buffer.getLengthInBits()+4<=8*totalDataCount&&buffer.put(0,4);buffer.getLengthInBits()%8!=0;)buffer.putBit(!1);for(;!(buffer.getLengthInBits()>=8*totalDataCount||(buffer.put(QRCodeModel.PAD0,8),buffer.getLengthInBits()>=8*totalDataCount));)buffer.put(QRCodeModel.PAD1,8);return QRCodeModel.createBytes(buffer,rsBlocks)},QRCodeModel.createBytes=function(buffer,rsBlocks){for(var offset=0,maxDcCount=0,maxEcCount=0,dcdata=new Array(rsBlocks.length),ecdata=new Array(rsBlocks.length),r=0;r<rsBlocks.length;r++){var dcCount=rsBlocks[r].dataCount,ecCount=rsBlocks[r].totalCount-dcCount;maxDcCount=Math.max(maxDcCount,dcCount),maxEcCount=Math.max(maxEcCount,ecCount),dcdata[r]=new Array(dcCount);for(var i=0;i<dcdata[r].length;i++)dcdata[r][i]=255&buffer.buffer[i+offset];offset+=dcCount;var rsPoly=QRUtil.getErrorCorrectPolynomial(ecCount),modPoly=new QRPolynomial(dcdata[r],rsPoly.getLength()-1).mod(rsPoly);ecdata[r]=new Array(rsPoly.getLength()-1);for(i=0;i<ecdata[r].length;i++){var modIndex=i+modPoly.getLength()-ecdata[r].length;ecdata[r][i]=modIndex>=0?modPoly.get(modIndex):0}}var totalCodeCount=0;for(i=0;i<rsBlocks.length;i++)totalCodeCount+=rsBlocks[i].totalCount;var data=new Array(totalCodeCount),index=0;for(i=0;i<maxDcCount;i++)for(r=0;r<rsBlocks.length;r++)i<dcdata[r].length&&(data[index++]=dcdata[r][i]);for(i=0;i<maxEcCount;i++)for(r=0;r<rsBlocks.length;r++)i<ecdata[r].length&&(data[index++]=ecdata[r][i]);return data};for(var QRMode={MODE_NUMBER:1,MODE_ALPHA_NUM:2,MODE_8BIT_BYTE:4,MODE_KANJI:8},QRErrorCorrectLevel={L:1,M:0,Q:3,H:2},QRMaskPattern={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7},QRUtil={PATTERN_POSITION_TABLE:[[],[6,18],[6,22],[6,26],[6,30],[6,34],[6,22,38],[6,24,42],[6,26,46],[6,28,50],[6,30,54],[6,32,58],[6,34,62],[6,26,46,66],[6,26,48,70],[6,26,50,74],[6,30,54,78],[6,30,56,82],[6,30,58,86],[6,34,62,90],[6,28,50,72,94],[6,26,50,74,98],[6,30,54,78,102],[6,28,54,80,106],[6,32,58,84,110],[6,30,58,86,114],[6,34,62,90,118],[6,26,50,74,98,122],[6,30,54,78,102,126],[6,26,52,78,104,130],[6,30,56,82,108,134],[6,34,60,86,112,138],[6,30,58,86,114,142],[6,34,62,90,118,146],[6,30,54,78,102,126,150],[6,24,50,76,102,128,154],[6,28,54,80,106,132,158],[6,32,58,84,110,136,162],[6,26,54,82,110,138,166],[6,30,58,86,114,142,170]],G15:1335,G18:7973,G15_MASK:21522,getBCHTypeInfo:function(data){for(var d=data<<10;QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G15)>=0;)d^=QRUtil.G15<<QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G15);return(data<<10|d)^QRUtil.G15_MASK},getBCHTypeNumber:function(data){for(var d=data<<12;QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G18)>=0;)d^=QRUtil.G18<<QRUtil.getBCHDigit(d)-QRUtil.getBCHDigit(QRUtil.G18);return data<<12|d},getBCHDigit:function(data){for(var digit=0;0!=data;)digit++,data>>>=1;return digit},getPatternPosition:function(typeNumber){return QRUtil.PATTERN_POSITION_TABLE[typeNumber-1]},getMask:function(maskPattern,i,j){switch(maskPattern){case QRMaskPattern.PATTERN000:return(i+j)%2==0;case QRMaskPattern.PATTERN001:return i%2==0;case QRMaskPattern.PATTERN010:return j%3==0;case QRMaskPattern.PATTERN011:return(i+j)%3==0;case QRMaskPattern.PATTERN100:return(Math.floor(i/2)+Math.floor(j/3))%2==0;case QRMaskPattern.PATTERN101:return i*j%2+i*j%3==0;case QRMaskPattern.PATTERN110:return(i*j%2+i*j%3)%2==0;case QRMaskPattern.PATTERN111:return(i*j%3+(i+j)%2)%2==0;default:throw new Error("bad maskPattern:"+maskPattern)}},getErrorCorrectPolynomial:function(errorCorrectLength){for(var a=new QRPolynomial([1],0),i=0;i<errorCorrectLength;i++)a=a.multiply(new QRPolynomial([1,QRMath.gexp(i)],0));return a},getLengthInBits:function(mode,type){if(1<=type&&type<10)switch(mode){case QRMode.MODE_NUMBER:return 10;case QRMode.MODE_ALPHA_NUM:return 9;case QRMode.MODE_8BIT_BYTE:case QRMode.MODE_KANJI:return 8;default:throw new Error("mode:"+mode)}else if(type<27)switch(mode){case QRMode.MODE_NUMBER:return 12;case QRMode.MODE_ALPHA_NUM:return 11;case QRMode.MODE_8BIT_BYTE:return 16;case QRMode.MODE_KANJI:return 10;default:throw new Error("mode:"+mode)}else{if(!(type<41))throw new Error("type:"+type);switch(mode){case QRMode.MODE_NUMBER:return 14;case QRMode.MODE_ALPHA_NUM:return 13;case QRMode.MODE_8BIT_BYTE:return 16;case QRMode.MODE_KANJI:return 12;default:throw new Error("mode:"+mode)}}},getLostPoint:function(qrCode){for(var moduleCount=qrCode.getModuleCount(),lostPoint=0,row=0;row<moduleCount;row++)for(var col=0;col<moduleCount;col++){for(var sameCount=0,dark=qrCode.isDark(row,col),r=-1;r<=1;r++)if(!(row+r<0||moduleCount<=row+r))for(var c=-1;c<=1;c++)col+c<0||moduleCount<=col+c||0==r&&0==c||dark==qrCode.isDark(row+r,col+c)&&sameCount++;sameCount>5&&(lostPoint+=3+sameCount-5)}for(row=0;row<moduleCount-1;row++)for(col=0;col<moduleCount-1;col++){var count=0;qrCode.isDark(row,col)&&count++,qrCode.isDark(row+1,col)&&count++,qrCode.isDark(row,col+1)&&count++,qrCode.isDark(row+1,col+1)&&count++,0!=count&&4!=count||(lostPoint+=3)}for(row=0;row<moduleCount;row++)for(col=0;col<moduleCount-6;col++)qrCode.isDark(row,col)&&!qrCode.isDark(row,col+1)&&qrCode.isDark(row,col+2)&&qrCode.isDark(row,col+3)&&qrCode.isDark(row,col+4)&&!qrCode.isDark(row,col+5)&&qrCode.isDark(row,col+6)&&(lostPoint+=40);for(col=0;col<moduleCount;col++)for(row=0;row<moduleCount-6;row++)qrCode.isDark(row,col)&&!qrCode.isDark(row+1,col)&&qrCode.isDark(row+2,col)&&qrCode.isDark(row+3,col)&&qrCode.isDark(row+4,col)&&!qrCode.isDark(row+5,col)&&qrCode.isDark(row+6,col)&&(lostPoint+=40);var darkCount=0;for(col=0;col<moduleCount;col++)for(row=0;row<moduleCount;row++)qrCode.isDark(row,col)&&darkCount++;return lostPoint+=10*(Math.abs(100*darkCount/moduleCount/moduleCount-50)/5)}},QRMath={glog:function(n){if(n<1)throw new Error("glog("+n+")");return QRMath.LOG_TABLE[n]},gexp:function(n){for(;n<0;)n+=255;for(;n>=256;)n-=255;return QRMath.EXP_TABLE[n]},EXP_TABLE:new Array(256),LOG_TABLE:new Array(256)},i=0;i<8;i++)QRMath.EXP_TABLE[i]=1<<i;for(i=8;i<256;i++)QRMath.EXP_TABLE[i]=QRMath.EXP_TABLE[i-4]^QRMath.EXP_TABLE[i-5]^QRMath.EXP_TABLE[i-6]^QRMath.EXP_TABLE[i-8];for(i=0;i<255;i++)QRMath.LOG_TABLE[QRMath.EXP_TABLE[i]]=i;function QRPolynomial(num,shift){if(void 0==num.length)throw new Error(num.length+"/"+shift);for(var offset=0;offset<num.length&&0==num[offset];)offset++;this.num=new Array(num.length-offset+shift);for(var i=0;i<num.length-offset;i++)this.num[i]=num[i+offset]}function QRRSBlock(totalCount,dataCount){this.totalCount=totalCount,this.dataCount=dataCount}function QRBitBuffer(){this.buffer=[],this.length=0}QRPolynomial.prototype={get:function(index){return this.num[index]},getLength:function(){return this.num.length},multiply:function(e){for(var num=new Array(this.getLength()+e.getLength()-1),i=0;i<this.getLength();i++)for(var j=0;j<e.getLength();j++)num[i+j]^=QRMath.gexp(QRMath.glog(this.get(i))+QRMath.glog(e.get(j)));return new QRPolynomial(num,0)},mod:function(e){if(this.getLength()-e.getLength()<0)return this;for(var ratio=QRMath.glog(this.get(0))-QRMath.glog(e.get(0)),num=new Array(this.getLength()),i=0;i<this.getLength();i++)num[i]=this.get(i);for(i=0;i<e.getLength();i++)num[i]^=QRMath.gexp(QRMath.glog(e.get(i))+ratio);return new QRPolynomial(num,0).mod(e)}},QRRSBlock.RS_BLOCK_TABLE=[[1,26,19],[1,26,16],[1,26,13],[1,26,9],[1,44,34],[1,44,28],[1,44,22],[1,44,16],[1,70,55],[1,70,44],[2,35,17],[2,35,13],[1,100,80],[2,50,32],[2,50,24],[4,25,9],[1,134,108],[2,67,43],[2,33,15,2,34,16],[2,33,11,2,34,12],[2,86,68],[4,43,27],[4,43,19],[4,43,15],[2,98,78],[4,49,31],[2,32,14,4,33,15],[4,39,13,1,40,14],[2,121,97],[2,60,38,2,61,39],[4,40,18,2,41,19],[4,40,14,2,41,15],[2,146,116],[3,58,36,2,59,37],[4,36,16,4,37,17],[4,36,12,4,37,13],[2,86,68,2,87,69],[4,69,43,1,70,44],[6,43,19,2,44,20],[6,43,15,2,44,16],[4,101,81],[1,80,50,4,81,51],[4,50,22,4,51,23],[3,36,12,8,37,13],[2,116,92,2,117,93],[6,58,36,2,59,37],[4,46,20,6,47,21],[7,42,14,4,43,15],[4,133,107],[8,59,37,1,60,38],[8,44,20,4,45,21],[12,33,11,4,34,12],[3,145,115,1,146,116],[4,64,40,5,65,41],[11,36,16,5,37,17],[11,36,12,5,37,13],[5,109,87,1,110,88],[5,65,41,5,66,42],[5,54,24,7,55,25],[11,36,12,7,37,13],[5,122,98,1,123,99],[7,73,45,3,74,46],[15,43,19,2,44,20],[3,45,15,13,46,16],[1,135,107,5,136,108],[10,74,46,1,75,47],[1,50,22,15,51,23],[2,42,14,17,43,15],[5,150,120,1,151,121],[9,69,43,4,70,44],[17,50,22,1,51,23],[2,42,14,19,43,15],[3,141,113,4,142,114],[3,70,44,11,71,45],[17,47,21,4,48,22],[9,39,13,16,40,14],[3,135,107,5,136,108],[3,67,41,13,68,42],[15,54,24,5,55,25],[15,43,15,10,44,16],[4,144,116,4,145,117],[17,68,42],[17,50,22,6,51,23],[19,46,16,6,47,17],[2,139,111,7,140,112],[17,74,46],[7,54,24,16,55,25],[34,37,13],[4,151,121,5,152,122],[4,75,47,14,76,48],[11,54,24,14,55,25],[16,45,15,14,46,16],[6,147,117,4,148,118],[6,73,45,14,74,46],[11,54,24,16,55,25],[30,46,16,2,47,17],[8,132,106,4,133,107],[8,75,47,13,76,48],[7,54,24,22,55,25],[22,45,15,13,46,16],[10,142,114,2,143,115],[19,74,46,4,75,47],[28,50,22,6,51,23],[33,46,16,4,47,17],[8,152,122,4,153,123],[22,73,45,3,74,46],[8,53,23,26,54,24],[12,45,15,28,46,16],[3,147,117,10,148,118],[3,73,45,23,74,46],[4,54,24,31,55,25],[11,45,15,31,46,16],[7,146,116,7,147,117],[21,73,45,7,74,46],[1,53,23,37,54,24],[19,45,15,26,46,16],[5,145,115,10,146,116],[19,75,47,10,76,48],[15,54,24,25,55,25],[23,45,15,25,46,16],[13,145,115,3,146,116],[2,74,46,29,75,47],[42,54,24,1,55,25],[23,45,15,28,46,16],[17,145,115],[10,74,46,23,75,47],[10,54,24,35,55,25],[19,45,15,35,46,16],[17,145,115,1,146,116],[14,74,46,21,75,47],[29,54,24,19,55,25],[11,45,15,46,46,16],[13,145,115,6,146,116],[14,74,46,23,75,47],[44,54,24,7,55,25],[59,46,16,1,47,17],[12,151,121,7,152,122],[12,75,47,26,76,48],[39,54,24,14,55,25],[22,45,15,41,46,16],[6,151,121,14,152,122],[6,75,47,34,76,48],[46,54,24,10,55,25],[2,45,15,64,46,16],[17,152,122,4,153,123],[29,74,46,14,75,47],[49,54,24,10,55,25],[24,45,15,46,46,16],[4,152,122,18,153,123],[13,74,46,32,75,47],[48,54,24,14,55,25],[42,45,15,32,46,16],[20,147,117,4,148,118],[40,75,47,7,76,48],[43,54,24,22,55,25],[10,45,15,67,46,16],[19,148,118,6,149,119],[18,75,47,31,76,48],[34,54,24,34,55,25],[20,45,15,61,46,16]],QRRSBlock.getRSBlocks=function(typeNumber,errorCorrectLevel){var rsBlock=QRRSBlock.getRsBlockTable(typeNumber,errorCorrectLevel);if(void 0==rsBlock)throw new Error("bad rs block @ typeNumber:"+typeNumber+"/errorCorrectLevel:"+errorCorrectLevel);for(var length=rsBlock.length/3,list=[],i=0;i<length;i++)for(var count=rsBlock[3*i+0],totalCount=rsBlock[3*i+1],dataCount=rsBlock[3*i+2],j=0;j<count;j++)list.push(new QRRSBlock(totalCount,dataCount));return list},QRRSBlock.getRsBlockTable=function(typeNumber,errorCorrectLevel){switch(errorCorrectLevel){case QRErrorCorrectLevel.L:return QRRSBlock.RS_BLOCK_TABLE[4*(typeNumber-1)+0];case QRErrorCorrectLevel.M:return QRRSBlock.RS_BLOCK_TABLE[4*(typeNumber-1)+1];case QRErrorCorrectLevel.Q:return QRRSBlock.RS_BLOCK_TABLE[4*(typeNumber-1)+2];case QRErrorCorrectLevel.H:return QRRSBlock.RS_BLOCK_TABLE[4*(typeNumber-1)+3];default:return}},QRBitBuffer.prototype={get:function(index){var bufIndex=Math.floor(index/8);return 1==(this.buffer[bufIndex]>>>7-index%8&1)},put:function(num,length){for(var i=0;i<length;i++)this.putBit(1==(num>>>length-i-1&1))},getLengthInBits:function(){return this.length},putBit:function(bit){var bufIndex=Math.floor(this.length/8);this.buffer.length<=bufIndex&&this.buffer.push(0),bit&&(this.buffer[bufIndex]|=128>>>this.length%8),this.length++}};var QRCodeLimitLength=[[17,14,11,7],[32,26,20,14],[53,42,32,24],[78,62,46,34],[106,84,60,44],[134,106,74,58],[154,122,86,64],[192,152,108,84],[230,180,130,98],[271,213,151,119],[321,251,177,137],[367,287,203,155],[425,331,241,177],[458,362,258,194],[520,412,292,220],[586,450,322,250],[644,504,364,280],[718,560,394,310],[792,624,442,338],[858,666,482,382],[929,711,509,403],[1003,779,565,439],[1091,857,611,461],[1171,911,661,511],[1273,997,715,535],[1367,1059,751,593],[1465,1125,805,625],[1528,1190,868,658],[1628,1264,908,698],[1732,1370,982,742],[1840,1452,1030,790],[1952,1538,1112,842],[2068,1628,1168,898],[2188,1722,1228,958],[2303,1809,1283,983],[2431,1911,1351,1051],[2563,1989,1423,1093],[2699,2099,1499,1139],[2809,2213,1579,1219],[2953,2331,1663,1273]];function _getTypeNumber(sText,_htOption){for(var nCorrectLevel=_htOption.correctLevel,nType=1,length=_getUTF8Length(sText),i=0,len=QRCodeLimitLength.length;i<len;i++){var nLimit=0;switch(nCorrectLevel){case QRErrorCorrectLevel.L:nLimit=QRCodeLimitLength[i][0];break;case QRErrorCorrectLevel.M:nLimit=QRCodeLimitLength[i][1];break;case QRErrorCorrectLevel.Q:nLimit=QRCodeLimitLength[i][2];break;case QRErrorCorrectLevel.H:nLimit=QRCodeLimitLength[i][3]}if(length<=nLimit)break;nType++}if(nType>QRCodeLimitLength.length)throw new Error("Too long data. the CorrectLevel."+["M","L","H","Q"][nCorrectLevel]+" limit length is "+nLimit);return 0!=_htOption.version&&(nType<=_htOption.version?(nType=_htOption.version,_htOption.runVersion=nType):(console.warn("QR Code version "+_htOption.version+" too small, run version use "+nType),_htOption.runVersion=nType)),nType}function _getUTF8Length(sText){var replacedText=encodeURI(sText).toString().replace(/\%[0-9a-fA-F]{2}/g,"a");return replacedText.length+(replacedText.length!=sText.length?3:0)}var Drawing=function(htOption){this._bIsPainted=!1,this._htOption=htOption,this._canvas=createCanvas(200,200),"svg"==this._htOption._drawer?this._oContext={}:this._oContext=this._canvas.getContext("2d"),this._bSupportDataURI=null};function QRCode(vOption){if(this._htOption={width:256,height:256,typeNumber:4,colorDark:"#000000",colorLight:"#ffffff",correctLevel:QRErrorCorrectLevel.H,dotScale:1,dotScaleTiming:1,dotScaleTiming_H:void 0,dotScaleTiming_V:void 0,dotScaleA:1,dotScaleAO:void 0,dotScaleAI:void 0,quietZone:0,quietZoneColor:"rgba(0,0,0,0)",title:"",titleFont:"normal normal bold 16px Arial",titleColor:"#000000",titleBackgroundColor:"#ffffff",titleHeight:0,titleTop:30,subTitle:"",subTitleFont:"normal normal normal 14px Arial",subTitleColor:"#4F4F4F",subTitleTop:60,logo:void 0,logoWidth:void 0,logoHeight:void 0,logoMaxWidth:void 0,logoMaxHeight:void 0,logoBackgroundColor:"#ffffff",logoBackgroundTransparent:!1,PO:void 0,PI:void 0,PO_TL:void 0,PI_TL:void 0,PO_TR:void 0,PI_TR:void 0,PO_BL:void 0,PI_BL:void 0,AO:void 0,AI:void 0,timing:void 0,timing_H:void 0,timing_V:void 0,backgroundImage:void 0,backgroundImageAlpha:1,autoColor:!1,autoColorDark:"rgba(0, 0, 0, .6)",autoColorLight:"rgba(255, 255, 255, .7)",onRenderingStart:void 0,format:"PNG",compressionLevel:6,quality:.75,version:0,binary:!1,utf8WithoutBOM:!0},"string"==typeof vOption&&(vOption={text:vOption}),vOption)for(var i in vOption)this._htOption[i]=vOption[i];this._htOption.title||this._htOption.subTitle||(this._htOption.titleHeight=0),(this._htOption.version<0||this._htOption.version>40)&&(console.warn("QR Code version '"+this._htOption.version+"' is invalidate, reset to 0"),this._htOption.version=0),this._htOption.format=this._htOption.format.toUpperCase(),"PNG"!=this._htOption.format&&"JPG"!=this._htOption.format&&(console.warn("Image format '"+this._htOption.format+"' is invalidate, reset to 'PNG'"),this._htOption.format="PNG"),"PNG"==this._htOption.format&&(this._htOption.compressionLevel<0||this._htOption.compressionLevel>9)?(console.warn(this._htOption.compressionLevel+" is invalidate, PNG compressionLevel must between 0 and 9, now reset to 6. "),this._htOption.compressionLevel=1):(this._htOption.quality<0||this._htOption.quality>1)&&(console.warn(this._htOption.quality+" is invalidate, JPG quality must between 0 and 1, now reset to 0.75. "),this._htOption.quality=.75),(this._htOption.dotScale<0||this._htOption.dotScale>1)&&(console.warn(this._htOption.dotScale+" , is invalidate, dotScale must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScale=1),(this._htOption.dotScaleTiming<0||this._htOption.dotScaleTiming>1)&&(console.warn(this._htOption.dotScaleTiming+" , is invalidate, dotScaleTiming must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleTiming=1),this._htOption.dotScaleTiming_H?(this._htOption.dotScaleTiming_H<0||this._htOption.dotScaleTiming_H>1)&&(console.warn(this._htOption.dotScaleTiming_H+" , is invalidate, dotScaleTiming_H must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleTiming_H=1):this._htOption.dotScaleTiming_H=this._htOption.dotScaleTiming,this._htOption.dotScaleTiming_V?(this._htOption.dotScaleTiming_V<0||this._htOption.dotScaleTiming_V>1)&&(console.warn(this._htOption.dotScaleTiming_V+" , is invalidate, dotScaleTiming_V must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleTiming_V=1):this._htOption.dotScaleTiming_V=this._htOption.dotScaleTiming,(this._htOption.dotScaleA<0||this._htOption.dotScaleA>1)&&(console.warn(this._htOption.dotScaleA+" , is invalidate, dotScaleA must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleA=1),this._htOption.dotScaleAO?(this._htOption.dotScaleAO<0||this._htOption.dotScaleAO>1)&&(console.warn(this._htOption.dotScaleAO+" , is invalidate, dotScaleAO must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleAO=1):this._htOption.dotScaleAO=this._htOption.dotScaleA,this._htOption.dotScaleAI?(this._htOption.dotScaleAI<0||this._htOption.dotScaleAI>1)&&(console.warn(this._htOption.dotScaleAI+" , is invalidate, dotScaleAI must greater than 0, less than or equal to 1, now reset to 1. "),this._htOption.dotScaleAI=1):this._htOption.dotScaleAI=this._htOption.dotScaleA,(this._htOption.backgroundImageAlpha<0||this._htOption.backgroundImageAlpha>1)&&(console.warn(this._htOption.backgroundImageAlpha+" , is invalidate, backgroundImageAlpha must between 0 and 1, now reset to 1. "),this._htOption.backgroundImageAlpha=1),(!this._htOption.drawer||"svg"!=this._htOption.drawer&&"canvas"!=this._htOption.drawer)&&(this._htOption.drawer="canvas"),this._htOption.height=this._htOption.height+this._htOption.titleHeight,this._oQRCode=null,this._oQRCode=new QRCodeModel(_getTypeNumber(this._htOption.text,this._htOption),this._htOption.correctLevel),this._oQRCode.addData(this._htOption.text,this._htOption.binary,this._htOption.utf8WithoutBOM),this._oQRCode.make()}Drawing.prototype.draw=function(oQRCode){var _htOption=this._htOption,nCount=oQRCode.getModuleCount(),nWidth=Math.round(_htOption.width/nCount),nHeight=Math.round((_htOption.height-_htOption.titleHeight)/nCount);nWidth<=1&&(nWidth=1),nHeight<=1&&(nHeight=1),_htOption.quietZone=Math.round(_htOption.quietZone),_htOption.width=nWidth*nCount,_htOption.height=nHeight*nCount+_htOption.titleHeight,this._canvas.width=_htOption.width+2*_htOption.quietZone,this._canvas.height=_htOption.height+2*_htOption.quietZone,"svg"==_htOption._drawer&&(this._oContext=new C2S({document:win.document,XMLSerializer:win.XMLSerializer,width:this._canvas.width,height:this._canvas.height})),this._oContext.patternQuality="best",this._oContext.quality="best",this._oContext.textDrawingMode="path",this._oContext.antialias="gray";var _oContext=this._oContext;_htOption.autoColorDark,_htOption.autoColorLight;"JPG"==_htOption.format?(_htOption.logoBackgroundTransparent=!1,_htOption.colorDark,_htOption.colorLight,_htOption.colorLight,_htOption.backgroundImage?(_oContext.fillStyle=_htOption.colorLight,_oContext.fillRect(0,0,this._canvas.width,this._canvas.height)):("rgba(0,0,0,0)"!=_htOption.quietZoneColor&&"transparent"!=_htOption.quietZoneColor||(_htOption.quietZoneColor="#ffffff"),_oContext.fillStyle=_htOption.colorLight,_oContext.fillRect(0,0,this._canvas.width,this._canvas.height))):(_oContext.lineWidth=0,_oContext.fillStyle=_htOption.colorLight,_oContext.fillRect(0,0,this._canvas.width,this._canvas.height));var t=this;function drawQuietZoneColor(){_htOption.quietZone>0&&_htOption.quietZoneColor&&(_oContext.lineWidth=0,_oContext.fillStyle=_htOption.quietZoneColor,_oContext.fillRect(0,0,t._canvas.width,_htOption.quietZone),_oContext.fillRect(0,_htOption.quietZone,_htOption.quietZone,t._canvas.height-2*_htOption.quietZone),_oContext.fillRect(t._canvas.width-_htOption.quietZone,_htOption.quietZone,_htOption.quietZone,t._canvas.height-2*_htOption.quietZone),_oContext.fillRect(0,t._canvas.height-_htOption.quietZone,t._canvas.width,_htOption.quietZone))}if(_htOption.backgroundImage){var bgImg=new Image;bgImg.onload=function(){_oContext.globalAlpha=1,_oContext.globalAlpha=_htOption.backgroundImageAlpha,_oContext.drawImage(bgImg,0,_htOption.titleHeight,_htOption.width+2*_htOption.quietZone,_htOption.height+2*_htOption.quietZone-_htOption.titleHeight),_oContext.globalAlpha=1,drawQrcode.call(t,oQRCode)},bgImg.onerror=function(e){t.reject(e)},bgImg.originalSrc=_htOption.backgroundImage,bgImg.src=_htOption.backgroundImage}else drawQrcode.call(t,oQRCode);function drawQrcode(oQRCode){for(var row=0;row<nCount;row++)for(var col=0;col<nCount;col++){var dColor,lColor,nLeft=col*nWidth+_htOption.quietZone,nTop=row*nHeight+_htOption.quietZone,bIsDark=oQRCode.isDark(row,col),eye=oQRCode.getEye(row,col),nowDotScale=_htOption.dotScale;if(_oContext.lineWidth=0,eye?(dColor=_htOption[eye.type]||_htOption[eye.type.substring(0,2)]||_htOption.colorDark,lColor=_htOption.colorLight):_htOption.backgroundImage?(lColor="rgba(0,0,0,0)",6==row?_htOption.autoColor?(dColor=_htOption.timing_H||_htOption.timing||_htOption.autoColorDark,lColor=_htOption.autoColorLight):dColor=_htOption.timing_H||_htOption.timing||_htOption.colorDark:6==col?_htOption.autoColor?(dColor=_htOption.timing_V||_htOption.timing||_htOption.autoColorDark,lColor=_htOption.autoColorLight):dColor=_htOption.timing_V||_htOption.timing||_htOption.colorDark:_htOption.autoColor?(dColor=_htOption.autoColorDark,lColor=_htOption.autoColorLight):dColor=_htOption.colorDark):(dColor=6==row?_htOption.timing_H||_htOption.timing||_htOption.colorDark:6==col&&(_htOption.timing_V||_htOption.timing)||_htOption.colorDark,lColor=_htOption.colorLight),_oContext.strokeStyle=bIsDark?dColor:lColor,_oContext.fillStyle=bIsDark?dColor:lColor,eye){bIsDark=eye.isDarkBlock;var type=eye.type;nowDotScale="AO"==type?_htOption.dotScaleAO:"AI"==type?_htOption.dotScaleAI:1,_htOption.backgroundImage&&_htOption.autoColor?(dColor=("AO"==eye.type?_htOption.AI:_htOption.AO)||_htOption.autoColorDark,lColor=_htOption.autoColorLight):dColor=("AO"==eye.type?_htOption.AI:_htOption.AO)||dColor,_oContext.fillRect(nLeft+nWidth*(1-nowDotScale)/2,_htOption.titleHeight+nTop+nHeight*(1-nowDotScale)/2,nWidth*nowDotScale,nHeight*nowDotScale)}else 6==row?(nowDotScale=_htOption.dotScaleTiming_H,_oContext.fillRect(nLeft+nWidth*(1-nowDotScale)/2,_htOption.titleHeight+nTop+nHeight*(1-nowDotScale)/2,nWidth*nowDotScale,nHeight*nowDotScale)):6==col?(nowDotScale=_htOption.dotScaleTiming_V,_oContext.fillRect(nLeft+nWidth*(1-nowDotScale)/2,_htOption.titleHeight+nTop+nHeight*(1-nowDotScale)/2,nWidth*nowDotScale,nHeight*nowDotScale)):(_htOption.backgroundImage,_oContext.fillRect(nLeft+nWidth*(1-nowDotScale)/2,_htOption.titleHeight+nTop+nHeight*(1-nowDotScale)/2,nWidth*nowDotScale,nHeight*nowDotScale));1==_htOption.dotScale||eye||(_oContext.strokeStyle=_htOption.colorLight)}if(_htOption.title&&(_oContext.fillStyle=_htOption.titleBackgroundColor,_oContext.fillRect(_htOption.quietZone,_htOption.quietZone,_htOption.width,_htOption.titleHeight),_oContext.font=_htOption.titleFont,_oContext.fillStyle=_htOption.titleColor,_oContext.textAlign="center",_oContext.fillText(_htOption.title,t._canvas.width/2,this._htOption.quietZone+this._htOption.titleTop)),_htOption.subTitle&&(_oContext.font=_htOption.subTitleFont,_oContext.fillStyle=_htOption.subTitleColor,_oContext.fillText(_htOption.subTitle,t._canvas.width/2,this._htOption.quietZone+this._htOption.subTitleTop)),_htOption.logo){var img=new Image,_this=this;img.onload=function(){!function(img){var nw,nh,imgContainerW=Math.round(_htOption.width/3.5),imgContainerH=Math.round(_htOption.height/3.5);imgContainerW!==imgContainerH&&(imgContainerW=imgContainerH),_htOption.logoMaxWidth?imgContainerW=Math.round(_htOption.logoMaxWidth):_htOption.logoWidth&&(imgContainerW=Math.round(_htOption.logoWidth)),_htOption.logoMaxHeight?imgContainerH=Math.round(_htOption.logoMaxHeight):_htOption.logoHeight&&(imgContainerH=Math.round(_htOption.logoHeight)),void 0===img.naturalWidth?(nw=img.width,nh=img.height):(nw=img.naturalWidth,nh=img.naturalHeight),(_htOption.logoMaxWidth||_htOption.logoMaxHeight)&&(_htOption.logoMaxWidth&&nw<=imgContainerW&&(imgContainerW=nw),_htOption.logoMaxHeight&&nh<=imgContainerH&&(imgContainerH=nh),nw<=imgContainerW&&nh<=imgContainerH&&(imgContainerW=nw,imgContainerH=nh));var imgContainerX=(_htOption.width+2*_htOption.quietZone-imgContainerW)/2,imgContainerY=(_htOption.height+_htOption.titleHeight+2*_htOption.quietZone-imgContainerH)/2,imgScale=Math.min(imgContainerW/nw,imgContainerH/nh),imgW=nw*imgScale,imgH=nh*imgScale;(_htOption.logoMaxWidth||_htOption.logoMaxHeight)&&(imgContainerW=imgW,imgContainerH=imgH,imgContainerX=(_htOption.width+2*_htOption.quietZone-imgContainerW)/2,imgContainerY=(_htOption.height+_htOption.titleHeight+2*_htOption.quietZone-imgContainerH)/2),_htOption.logoBackgroundTransparent||(_oContext.fillStyle=_htOption.logoBackgroundColor,_oContext.fillRect(imgContainerX,imgContainerY,imgContainerW,imgContainerH)),_oContext.drawImage(img,imgContainerX+(imgContainerW-imgW)/2,imgContainerY+(imgContainerH-imgH)/2,imgW,imgH),drawQuietZoneColor(),_this._bIsPainted=!0,_this.makeImage()}(img)},img.onerror=function(e){t.reject(e)},img.originalSrc=_htOption.logo,img.src=_htOption.logo}else drawQuietZoneColor(),this._bIsPainted=!0,this.makeImage()}},Drawing.prototype.makeImage=function(){var makeOptions=this.makeOptions,t=this;if("FILE"==makeOptions.makeType)if(this._htOption.onRenderingStart&&this._htOption.onRenderingStart(this._htOption),"svg"==this._htOption._drawer){let data=this._oContext.getSerializedSvg();fs.writeFile(makeOptions.path,optimize(data).data,"utf8",function(err){err&&t.reject(err),t.resolve({})})}else{var out=fs.createWriteStream(makeOptions.path);("PNG"==this._htOption.format?this._canvas.createPNGStream({compressionLevel:this._htOption.compressionLevel}):this._canvas.createJPEGStream({quality:this._htOption.quality})).pipe(out),out.on("finish",()=>{t.resolve({})})}else if("URL"==makeOptions.makeType)if(this._htOption.onRenderingStart&&this._htOption.onRenderingStart(this._htOption),"svg"==this._htOption._drawer){let data=this._oContext.getSerializedSvg();t.resolve(optimize(data).data)}else"PNG"==this._htOption.format?this._canvas.toDataURL((err,data)=>{t.resolve(data)}):this._canvas.toDataURL("image/jpeg",(err,data)=>{t.resolve(data)});else"STREAM"==makeOptions.makeType&&(this._htOption.onRenderingStart&&this._htOption.onRenderingStart(this._htOption),"PNG"==this._htOption.format?t.resolve(this._canvas.createPNGStream()):t.resolve(this._canvas.createJPEGStream()))},Drawing.prototype.isPainted=function(){return this._bIsPainted},Drawing.prototype.round=function(nNumber){return nNumber?Math.floor(1e3*nNumber)/1e3:nNumber},QRCode.prototype._toSave=function(saveOptions){var _oDrawing=new Drawing(Object.assign({},this._htOption));_oDrawing.makeOptions=saveOptions;try{var t=this;return new Promise((resolve,reject)=>{_oDrawing.resolve=resolve,_oDrawing.reject=reject,_oDrawing.draw(t._oQRCode)})}catch(e){console.error(e)}},QRCode.prototype.saveImage=function(saveOptions){return this._htOption._drawer="canvas",saveOptions=Object.assign({makeType:"FILE",path:null},saveOptions),this._toSave(saveOptions)},QRCode.prototype.saveSVG=function(saveOptions){return this._htOption._drawer="svg",saveOptions=Object.assign({makeType:"FILE",path:null},saveOptions),this._toSave(saveOptions)},QRCode.prototype._toData=function(drawer,makeType){var defOptions={makeType:makeType||"URL"};this._htOption._drawer=drawer;var _oDrawing=new Drawing(Object.assign({},this._htOption));_oDrawing.makeOptions=defOptions;try{var t=this;return new Promise((resolve,reject)=>{_oDrawing.resolve=resolve,_oDrawing.reject=reject,_oDrawing.draw(t._oQRCode)})}catch(e){console.error(e)}},QRCode.prototype.toDataURL=function(){return this._toData("canvas")},QRCode.prototype.toSVGText=function(){return this._toData("svg")},QRCode.prototype.toStream=function(){return this._toData("canvas","STREAM")},QRCode.CorrectLevel=QRErrorCorrectLevel,module.exports=QRCode;