let app, LED = {
    _init: function (core, cback) {
        app = core;
        LED._queue = core.queueProc.init('blink', 1);
        core._m.fs.ensureDirSync(core.libsHome + 'blink/');
        let blink_src = 'https://d2vh72iz1x8zfl.cloudfront.net/TechnoPOS/libs/blink/blink1-tool-v2.2.0-' +
            (app.cfg.platform.indexOf('win') != -1 ? 'windows' : 'linux') + '-' + (app.isPi ? 'armv7l' : 'x86_64') + '.zip';
        core._m.fs.exists(core.libsHome + 'blink/blink1-tool', function (e) {
            if (!e) {
                //download
                core.system.request.GET(blink_src, { encoding: null }, function (e, r, b) {
                    //b is buffer, save to zip
                    if (b) {
                        core._m.fs.writeFile(core.libsHome + 'blink/blink.zip', b, function () {
                            app._m.exec('unzip blink.zip', { cwd: core.libsHome + 'blink' }, function () {
                                try {
                                    if (app.isPi) {
                                        app._m.exec('sudo ./blink1-tool --add_udev_rules', { cwd: core.libsHome + 'blink' }, function () { })
                                    }
                                } catch (er) { }
                                LED.solid('blue');
                            })
                        })
                    }

                })
                return;
            }
            try {
                if (app.isPi) {
                    app._m.exec('sudo ./blink1-tool --add_udev_rules', { cwd: core.libsHome + 'blink' }, function () { })
                }
            } catch (er) { }
            LED.solid('blue');
        });
        if (cback) cback();
    },
    routeGUIaction: function (d, cback) {
        switch (d.action) {
            case 'blink':
                LED.blink(d.data.color, d.data.pattern, d.data.ttl, d.data.colorAfter);
                break;
            case 'cycle':
                LED.cycle(d.data.colors, d.data.fade, d.data.ttl, d.data.alternate);
                break;
            case 'off':
                LED.off(d.data.fade);
                break;
            case 'solid':
                LED.solid(d.data.color, d.data.fade, d.data.ttl, d.data.colorAfter);
                break;
            default:
                if (cback) cback({ result: 'error', error: 'invalid_action' })
                return;
        }
        if (cback) cback({ result: 'success' });
    },
    _colors: {
        red: { r: 255, g: 0, b: 0 },
        green: { r: 0, g: 255, b: 0 },
        orange: { r: 255, g: 118, b: 25 },
        blue: { r: 3, g: 22, b: 253 },
        pink: { r: 255, g: 0, b: 255 },
        purple: { r: 132, g: 0, b: 156 },
        teal: { r: 0, g: 255, b: 255 }
    },
    _patterns: {
        fast: [50, 150],
        medium: [300, 500],
        slow: [500, 1000]
    },
    _getBackTimer: null,
    _cycleTimer: null,
    _blinkTimer: null,
    blink: function (color, p, ttl, after) {
        //console.log('blink',color,p,ttl,after)
        clearInterval(LED._blinkTimer);
        clearTimeout(LED._getBackTimer);
        clearInterval(LED._cycleTimer);
        if (!p || typeof LED._patterns[p] == 'undefined')
            p = 'medium';
        var pat = LED._patterns[p];
        var vars = app._m.xtend.extend(app._m.xtend.clone(LED._colors[color]), { m: pat[0] });
        var _current = true;
        LED._send(vars);
        LED._blinkTimer = setInterval(function () {
            _current = !_current;
            if (_current)
                LED._send(vars);
            else
                LED.off(pat[0]);
        }, pat[1]);
        if (ttl && after)
            LED._getBackTimer = setTimeout(function () { LED.set(after, 300); }, 1000 * ttl);
    },
    off: function (fade) {
        LED._send({ br: 0, r: 0, g: 0, b: 0, m: fade || 0 });
    },
    solid: function (color, fade, ttl, colorafter) {
        LED.set(color, fade, ttl, colorafter);
    },
    set: function (color, fade, ttl, colorafter) { //LED.set
        try {
            var c;
            fade = (fade) ? fade : 300;
            if (typeof color == 'object' && color.r && color.g && color.b) {
                c = color;
            }
            else if (typeof LED._colors[color] != 'undefined') {
                c = LED._colors[color];
            }
            else {
                console.log('Wrong color name:' + color);
                return;
            }
            clearInterval(LED._blinkTimer);
            clearTimeout(LED._getBackTimer);
            clearInterval(LED._cycleTimer);
            var vars = app._m.xtend.extend(app._m.xtend.clone(c), { m: fade });
            LED._send(vars);
            if (ttl && colorafter) {
                LED._getBackTimer = setTimeout(function () {
                    LED.set(colorafter, fade);
                }, ttl)
            }
        }
        catch (e) {
            console.log(e);
        }
    },
    cycle: function (colors, fade, ttl, alternate) { //LED.cycle()
        try {

            clearInterval(LED._blinkTimer);
            clearTimeout(LED._getBackTimer);
            clearInterval(LED._cycleTimer);
            var curLed = 0;
            var curIndex = 0;
            var _colors = [];
            for (var i = 0; i < colors.length; i++) {
                if (typeof LED._colors[colors[i]] == 'undefined')
                    continue;
                _colors.push(colors[i]);
            }
            var vars = app._m.xtend.extend(app._m.xtend.clone(LED._colors[_colors[0]]), { n: curled, m: fade });
            LED._send(vars);
            LED._cycleTimer = setInterval(function () {
                if (alternate) {
                    curLed++;
                    if (curLed > 2)
                        curLed = 1;
                }
                ++curIndex;
                if (curIndex >= _colors.length) {
                    curIndex = 0;
                }
                var vars = app._m.xtend.extend(app._m.xtend.clone(LED._colors[_colors[curIndex]]), { n: curLed, m: fade });
                LED._send(vars);   // set new news item into the ticker
            }, ttl);
        }
        catch (e) {
            console.log(e);
        }
    },
    _send: function (vars) {
        vars = app._m.xtend.extend(app._m.xtend.clone({
            br: 255,      // brightness
            r: 0,
            g: 255,
            b: 0,
            n: 'all',    // led #
            m: 300       // fade
        }), vars);
        //console.log('blink1-tool -'+(vars.n=='all'?'d':'l')+' '+vars.n+' --rgb '+vars.r+','+vars.g+','+vars.b+' -b '+vars.br)
        app._m.exec('./blink1-tool -' + (vars.n == 'all' ? 'd' : 'l') + ' ' + vars.n + ' --rgb ' + vars.r + ',' + vars.g + ',' + vars.b + ' -b ' + vars.br, { cwd: app.libsHome + 'blink' }, function () {

        });
    },
    shutdown: function () {
        LED.off();
    }
};
module.exports = LED;