var app, worker, R = {
	_init: function (parent, cback) {
		app = parent;
		R.startWorker();
		if (cback) cback();
	},

	startWorker: function (onReady) {
		if (worker) {
			if (worker.workerIsReady) {
				if (onReady) onReady();
				return;
			}
			setTimeout(function () {
				R.startWorker(onReady);
			}, 1000);
			return
		}
		if (!worker) {
			worker = app._m.childProcess.fork(__dirname + '/rotator-child.js');
			worker.on('message', function (data) {
				data = app.JSON.parse(data);
				//data=data.toString();
				switch (data.action) {
					case 'rotatorDebug':
						console.log('log rotator debug', data.data);
						break;
					case 'rotated':
						console.log(data.file + ' has been rotated.');
						break;
					case 'initError':
						console.error('log rotator init error', data.file, data.error);
						break;
					case 'ready':
						//send config to child
						worker.send({ action: 'config', config: { path: app.baseDir + 'logs/' } })
						worker.workerIsReady = true;
						if (onReady) onReady();
						break;
				}
			}).
				on('error', function (err) { console.error(err); }).
				on('exit', function (code, signal) {
					worker = null;
					if (app.status != 'shutdown') {
						R.startWorker();
					}
				});
		}
	},
	shutdown: function () {
		if (worker) {
			try {
				worker.send({ action: 'exit' });
			} catch (er) { }
			setTimeout(function () {
				try {
					worker.kill();
				} catch (er) { }
			}, 1000);
		}
		//try {
		//	let _modules = Object.keys(self);
		//	for (let i = 0; i < _modules.length; i++) {
		//		if (self[_modules[i]] && self[_modules[i]].shutdown)
		//			try { self[_modules[i]].shutdown(); } catch (er) { }
		//	}
		//} catch (er) { }
	}
};
module.exports = R;