var self, app, socketInitialized = false, _onPKICreated = [], _keysAreGenerating = false;

var pingReset = null;
module.exports = class Web {
	constructor(url, namespace, parent) {
		//console.log('web.parent', parent);
		this.EVENT = 'app.event';
		this.EVENT_REPLY = 'app.event.return';
		this.url = url;
		this.port = 4202;
		this.namespace = namespace;
		app = parent;
		module.paths.unshift(app._relativePath.replace('/source', ''))
		this.status = 'offline';
		this.PKI = null;
		this._sendQueue = [];
		self = this;
		self.emitAcks = {};
		self.emitCbacks = {};
		self.express = require('express');
		self.router = self.express.Router();
		self.router.use(self.httpRouter);
	}

	initialize(cback) {
		let
			_app = self.express(),
			bodyParser = require('body-parser');
		_app.use(bodyParser.json({ limit: '5mb' }));
		_app.use(bodyParser.urlencoded({ limit: '5mb', extended: true }));
		_app.disable('x-powered-by');
		_app.disable('Cache-Control');
		let server = app._m.http.Server(_app);
		if (!app._m.io) app._m.io = require('socket.io');
		self.io = app._m.io(server, {
			allowEIO3: true // false by default
		});
		self.io.origins((_, callback) => {
			callback(null, true);
		});
		_app.use('/', self.router);
		self.createKeys(function () {
			console.log('WEB RSA KEYS CREATED, CONTINUE')
			let doListen = function () {
				try {
					server.listen(self.port);
				} catch (er) {
					console.error('web listen port', self.port, er.code);
					//EADDRINUSE
					setTimeout(doListen, 1000 * 5);
				}
			};
			doListen();

			if (cback) cback();
		});

		setInterval(function () {
			//!app.pathExists(self.socket, 'io.reconnecting')
			if (self.socket && (self.status == 'offline' || !self.socket.connected) && self.disconnectDate) {
				let _sdd = (new Date().getTime() - new Date(self.disconnectDate).getTime()) / 1000;
				if (_sdd > 45) {
					if (_sdd > 60 * 2)
						console.warn('disconnected', _sdd + 's ago, self not connected, reconnecting...');
					self.socket.connect();
				}
			}
		}, 1000 * 10)
		self.initialized = true;
	}
	_routeEvent(d, ack, cback) {
		try {
			d = app.JSON.parse(app.system.crypto.AES_PK.decrypt(d, self.PKI.private));
		}
		catch (er) {
			console.error(er.message, d)
			if (ack) ack('resend');
			return;
		}

		//console.log('RECEIVED PARSED', d, ack, cback)
		if (d.cbackID && !cback) {
			cback = function (data) {
				//console.log('sending cback')
				if (ack) ack('callback', data);
			}
		}
		self.routeEvent(d, cback);
		if (ack) ack('received');
	}
	connect() {
		if (socketInitialized) return false;

		try {
			app.splashscreen.win.window.setProgress(75);
			app.splashscreen.win.window.setMessage(app.parseLocales('splash.startup_steps.validatin_licence'));
		} catch (er) { }
		socketInitialized = true;
		console.log('Connecting to', self.url + '/' + self.namespace)
		app.sessions.sessionIsSet = false;
		self.socket = app.io(self.url + '/' + self.namespace, {
			reconnectionDelay: 1000,
			reconnectionDelayMax: 20000,
			transports: ['websocket', 'polling'],
			allowUpgrades: true
		});
		let _sendConnect = function () {
			self.socket.emit('device.connect', app.system.crypto.AES_PK.encrypt({
				useIV: true,
				macAddress: app.system._data.macAddress,
				uuid: app.system.id,
				hostname: os.hostname(),
				version: app.cfg.version,
				platform: app.cfg.platform,
				appType: 'register',
				diagBasic: app.diag.basicData,
				encryptCallbacks: true
			}, self.PKI.serverPublic, true), function (ack, master, err) {
				self.socket.masterInfo = master;
				console.log('Talking to:', master);
				if (ack == 'received') {
					self.connected();
				}
			});
		};

		self.lastPing = {
			ttl: 999,
			date: new Date().toISOString()
		}
		self.socket.
			on('PUBLIC_KEY', function (d) {
				self.PKI.serverPublic = Buffer.from(d, 'base64').toString();
				if (!self.PKI || !self.PKI.public) {
					console.error('NO PUBLIC KEY CREATED!');
					return;
				}
				self.socket.emit('PUBLIC_KEY', self.PKI.public64, function (ack) {

					//console.log('Connecting fo real')
					self.socket.sendEncrypted = true;
					_sendConnect();
				});
			}).
			on('connect', function () {
				console.log('Connected to the internets');
				self.lastPing = {
					ttl: 0,
					date: new Date().toISOString()
				}
			}).
			on('session_not_set', function () {
				app.sessions.sessionIsSet = false;
				_sendConnect();
			}).

			on('pong', (ms) => {
				//console.log('PONG', ms)
				self.lastPing = {
					ttl: ms / 1000,
					date: new Date().toISOString()
				}
				clearTimeout(pingReset);
				pingReset = setTimeout(function () {
					console.warn('Ping timed out, reconnect');
					self.status = 'offline';
				}, 1000 * 60 * 2);
			}).
			on('ping', () => {
				//console.log('PING')
			}).
			on('encrypted_message', self._routeEvent).
			on('system', self._routeEvent).

			on('eventACK', function (d) {
				if (self.emitAcks[d.ackID])
					self.emitAcks[d.ackID](d.ack);
			}).
			on(self.EVENT_REPLY, self._routeEvent).
			on('disconnect', self.disconnected).
			on('error', function (err) {
				console.error(err)
			});
	}
	connected() {
		this.status = 'online';
		console.log('Connected to the cloud server, waiting for session');
		try {
			app.splashscreen.win.window.setProgress(80);
			app.splashscreen.win.window.setMessage(app.parseLocales('splash.startup_steps.connecting_to_server'));
		} catch (er) { }
		app.sessions.init();
		app.system.sendSystemInfo.init();
	}
	createKeys(cback) {
		if (_keysAreGenerating) {
			self.waitForKeys(cback);
			return;
		}
		_keysAreGenerating = true;
		console.log('Starting key generation now.');
		let
			_stopTries = 0,
			_generated = function (data) {
				if (_stopTries) return;
				_stopTries = 1;
				self.PKI = typeof data == 'string' ? JSON.parse(data) : data;
				self.connect();
				if (_onPKICreated && _onPKICreated.length) {
					try {
						for (let i = 0; i < _onPKICreated.length; i++) {
							try {
								_onPKICreated[i]();
							} catch (er) { console.error(er); }
						}
					} catch (er) { console.error(er.message); }
				}
				self.PKI.public64 = Buffer.from(self.PKI.public).toString('base64');
				cback();
			},
			_keyGenTimeout = setTimeout(function () {
				console.warn('RSA Key generation not completed after 30s!');
				if (app._m.fs.existsSync(app.cacheDir + 'PKI')) {
					app._m.fs.readFile(app.cacheDir + 'PKI', function (data) {
						if (data) {
							console.warn('using previous PKI!');
							data = JSON.parse(data.toString());
							_generated(data);
						}
					});
				}
			}, 1000 * 30);
		try {
			var
				_doRSA = function () {
					if (_stopTries) return;
					try {

						let cp = app._m.childProcess.fork(__dirname + '/rsa-keygen.js', {
							execArgv: ['--max-old-space-size=4096']
						});
						cp.
							on('message', function (data) {
								if (!data || data.error) {
									console.error('CREATE RSA ERROR:', data && data.error ? data.error : 'unknown error')
									return;
								}

								if (data && data.action) {
									switch (data.action) {
										case 'completed':

											console.log('Received RSA keys');
											app._m.fs.writeFile(app.cacheDir + 'PKI', JSON.stringify(data.data), function () { });
											_generated(data.data);
											clearTimeout(_keyGenTimeout);
											return;
											break;
									}
								}
								console.warn('CREATE RSA RECEIVED', data)
							}).
							on('error', function (err) {
								console.error('CREATE RSA ERROR:', err.message);
								setTimeout(_doRSA, 1000);
							}).
							on('exit', function (code, signal) {
								if (code != 0) {
									console.error('CREATE RSA EXIT CODE:', code, signal);
									try {

										let
											_RSA = require('node-rsa'),
											_PKI = { data: new _RSA() };
										_PKI.data.generateKeyPair(2048);
										let _public = _PKI.data.exportKey('public'),
											_private = _PKI.data.exportKey('private');
										app._m.fs.writeFile(app.cacheDir + 'PKI', JSON.stringify({ private: _private, public: _public }), function () { });
										_generated({ private: _private, public: _public });
										clearTimeout(_keyGenTimeout);
									}
									catch (er) {
										console.error('RSA generation fallback failed.', er.message)
									}
								}
								//clearTimeout(_keyGenTimeout);
							});
					} catch (err) {

						console.error('CREATE RSA ERROR:', err.message);
						setTimeout(_doRSA, 1000);
					}
				}
			_doRSA();
		} catch (er) {
			console.error('Error while generating keypair', er.code, er.message)
			setTimeout(function () {
				web.createKeys(cback);
			}, 1000 * 5);
		}
	}
	waitForKeys(fct) {
		if (!app.web.PKI || !app.web.PKI.public)
			_onPKICreated.push(fct);
		else
			fct();
	}

	reconnect() {
		if (self.status == 'online') return false;
		setTimeout(function () {
			if (self.status != 'online' && !app.pathExists(self.socket, 'io.reconnecting')) {
				self.socket.connect();
			}
		}, 1000);
		//clearTimeout(pingReset);
		//pingReset = setTimeout(function () {
		//	//sws.socket.connect();
		//	pingReset = setTimeout(function () {
		//		sws.reconnect();
		//	}, 1000 * 5);
		//}, 500);

	}
	disconnected() {
		clearTimeout(pingReset);
		app.sessions.sessionIsSet = false;
		self.status = 'offline';
		self.disconnectDate = new Date().toISOString();
		self.reconnect();
	}

	processSendQueue() {
		if (self.status != 'online' || self._sendQueueProcessing) {

			return;
		}
		self._sendQueueProcessing = true;
		//console.log('sendQueue', self._sendQueue.length);
		let _q = self._sendQueue[0];
		if (!_q) {
			self._sendQueueProcessing = false;
			return;
		}
		self.emit(_q.datas, _q.cback, function (ack) {
			if (ack == 'received') {
				if (_q.onAck) _q.onAck('received');
				self._sendQueue.shift();
				self.processSendQueue();
			}
		});
	}

	emit(datas, cback, onAck) {
		let volatile = datas.volatile || false;
		delete datas.volatile;
		datas.appType = 'register';

		if (self.status != 'online' || !self.socket || datas.module != 'sessions' && !app.sessions.sessionIsSet) {
			self._sendQueue.push({
				datas: datas,
				cback: cback,
				onAck: onAck
			});
			return;
		}
		if (cback) {
			datas.cbackID = app.system.uuid.get();
			self.emitCbacks[datas.cbackID] = function (d, ack) {
				try {
					d = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(d, self.PKI.private));
				}
				catch (er) {
					console.error(er.message, d)
					if (ack) ack('resend');
					return;
				}
				try {
					self.emitAcks[datas.ackID]('received');
				} catch (er) { }
				//console.log('RECEIVED PARSED', d)
				app.tryCatch(function () {
					if (d?.result == 'blocked') {
						self.status = 'blocked';
						self._sendQueue.push({
							datas: datas,
							cback: cback,
							onAck: onAck
						});
						setTimeout(function () {
							if (self.status == 'blocked') self.status = 'online';
						}, d.retryMS + 500);
						console.warn('Request has been blocked', d)
						return;
					}
					cback(d);
				});
				if (ack) ack('received');
				try { clearTimeout(ackTimeoutWarn); } catch (er) { }
				setTimeout(function () {
					delete self.emitCbacks[datas.cbackID];
				}, 1000 * 5);
			};
		}

		datas.ackID = app.system.uuid.get();

		let ackTimeoutWarn = null, ackFired = false;
		self.emitAcks[datas.ackID] = function (ack) {
			if (ackFired) return false;
			ackFired = true;
			//console.log('ack')
			try { clearTimeout(ackTimeoutWarn); } catch (er) { }
			if (ack != 'received')
				console.warn('Received ack for svr.event', ack)
			if (ack == 'resend') {
				_retried++;
				process.nextTick(_doSend);
			}
			if (ack == 'received')
				setTimeout(function () {
					delete self.emitAcks[datas.ackID];
				}, 1000 * 5);
			if (onAck) {
				app.tryCatch(function () {
					onAck(ack);
				});
			}
		};
		try {
			var _retried = 0, _doSend = function () {
				if (!self.socket) {
					if (volatile) return false;
					console.warn('cant send data, no socket', datas)
					setTimeout(function () {
						_doSend();
					}, 500);
					return;
				}
				ackTimeoutWarn = setTimeout(function () {
					if (volatile) return;
					console.warn('Not received an ack in 20s');
				}, 1000 * 20)
				if (_retried < 5 && self.socket.sendEncrypted && self.PKI.serverPublic) {
					self.socket.emit(self.EVENT, app.system.crypto.AES_PK.encrypt(datas, self.PKI.serverPublic, true), self.emitAcks[datas.ackID], cback ? self.emitCbacks[datas.cbackID] : undefined);
				}
				else {
					self.socket.emit(self.EVENT, datas, self.emitAcks[datas.ackID], cback ? self.emitCbacks[datas.cbackID] : undefined);
				}
			};
			_doSend();
		}
		catch (e) {
			console.error('admin.send: ' + e.message);
		}
	}

	routeEvent(d, cback) {
		//console.log(d)
		if (!d.module) d.module = 'system';
		//if ((d.cback || d.cbackID) && self.emitCbacks[d.cback || d.cbackID]) {
		//	self.emitCbacks[d.cback || d.cbackID](d);
		//	return;
		//}
		if (d.module == 'web') {
			switch (d.action) {
				case 'newRegister':
					//console.log('Received register', d.data)
					if (!app.data.session.configs.registers[d.data.device])
						app.data.session.configs.registers[d.data.device] = {
							hostname: d.data.status.hostname,
							ipAddress: d.data.status.ipAddress,
							name: d.data.name,
							network: d.data.pos_status.network,
							online: d.data.online,
							publicKey: d.data.publicKey
						}
					break;
				case 'registerRemoved':
					if (d.data.device == app.system.id) {
						app.restart(1)
						return;
					}
					delete app.data.session.configs.registers[d.data.device];
					try {
						app.pos.registerRemoved(d.data.device);
					} catch (er) { }
					break;
				case 'registers':
					app.data.session.configs.registers = d.data;
					break;
				case 'registerInfos':
					app.data.session.configs.registers[d.data.id] = d.data;
					break;
				default:
					console.warn('Unrouted WEB event', d.action)
					break;
			}
			return;
		}
		if (d.module == 'POS') d.module = 'pos';
		try {
			app[d.module].routeEvent(d, cback);
		} catch (e) {
			console.warn('ERROR module ' + d.module + '.' + d.action + ' in app: ' + e.message);
		}
	}
	get(regID, vars, cback) {
		let r = app.pathExists(app.data, 'session.configs.registers.' + regID);
		if (!r) return false;
		//try local ip for 3 seconds, if no answer, socketize request
		//get local ip address
		let ip = app.pathExists(r, 'network.ipAddress');
		if (!ip) {
			//look for more
		}
		if (!vars.opts) vars.opts = {};
		if (!vars.opts.headers) vars.opts.headers = {};
		vars.opts.headers['x-register-id'] = app.system.id;
		app.system.request.GET('http://' + ip + ':' + self.port + vars.path, vars.opts, function (e, r, b) {
			if (b) {
				try {
					b = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(b, self.PKI.private));
				}
				catch (er) {
					console.error('WEB.get', er.message, b)
					cback(er, r, b);
					return;
				}
				if (b && b.result && b.result == 'resend') {
					process.nextTick(function () {
						self.post(regID, vars, cback);
					});
					return;
				}
			}
			cback(e, r, b);
		});
	}
	post(regID, vars, cback) {
		let r = app.pathExists(app.data, 'session.configs.registers.' + regID);
		if (!r) {
			console.warn('REGISTER UNKNOWN', regID);
			return false;
		}
		//try local ip for 3 seconds, if no answer, socketize request
		//get local ip address
		let ip = app.pathExists(r, 'network.ipAddress');
		if (!ip) {
			//look for more
			console.warn('REGISTER AS NO IP ADDRESS', regID);
			return false;
		}
		if (!vars.opts) vars.opts = {};
		if (!vars.opts.headers) vars.opts.headers = {};
		vars.opts.headers['x-register-id'] = app.system.id;
		app.system.request.POST('http://' + ip + ':' + self.port + vars.path, vars.fields, vars.opts, function (e, r, b) {
			if (b) {
				try {
					b = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(b, self.PKI.private));
				}
				catch (er) {
					console.error('WEB.post', er.message, b)
					cback(er, r, b);
					return;
				}
				if (b && b.result && b.result == 'resend') {
					process.nextTick(function () {
						self.post(regID, vars, cback);
					});
					return;
				}
			}
			cback(e, r, b);
		});
		return 'http://' + ip + ':' + self.port + vars.path;
	}
	httpRouter(req, res, next) {
		if (req.url == '/AzimutPOS.png') {
			res.end(fs.readFileSync(app._appPath + 'AzimutPOS.png'));
			return true;
		}
		if (app.isSDK && req.url.indexOf('/remotePrint') === 0) {
			console.log('received remote print');
			app.printManager.print(app.system.JSON.parse(req.body), function (pres) {
				res.json({ result: 'printed', data: pres });
			});
			return;
		}
		req.registerID = req.headers['x-register-id'];
		let r = app.pathExists(app, 'data.session.configs.registers.' + req.registerID);
		if (!r) {
			res.json({ result: 'error', statusCode: 403, code: 'unauthorized' });
			return;
		}

		res.return = function (d) {
			//return encrypted answer
			if (r && r.publicKey)
				res.end(app.system.crypto.AES_PK.encrypt(d, r.publicKey, true));
			else if (typeof d == 'string')
				res.end(d);
			else
				res.json(d);
		}

		try {
			req.body = app.system.JSON.parse(app.system.crypto.AES_PK.decrypt(req.body, self.PKI.private));
		}
		catch (er) {
			console.error(er.message, d)
			res.json({ result: 'resend' });
			return;
		}

		next();

	}
	shutdown() {
	}
};