var app,
	_socket = {},
	pos,
	_value = 0,
	_registers = {},
	_keepAlive = null,
	_status = {},
	_lastValue = {},
	_openPort = function (vars, cback) {
		let _debug = function () {
			if (vars.debug) {
				let ma = Array.prototype.slice.call(arguments);
				ma.unshift(vars.device);
				ma.unshift('weightScale debug');
				console.info.apply(null, ma);
			}
		},
			_statusChanged = function (s) {
				statusChange(vars.device, s);
				if (vars.onStatus) {
					app.tryCatch(function () { vars.onStatus(app._m.xtend.clone(_status[vars.device])); });
				}
			};
		_statusChanged('init');
		_debug('Init');
		if (_socket[vars.device]) {
			_debug('Device already init.');
			if (cback) cback({
				write: function (t) {
					_socket[vars.device].write(t)
				}
			});
			return;
		}
		_debug('stty port speed');
		let sttycmd = "stty -F " + vars.device + " " + vars.speed + " raw -echo";
		app._m.exec(sttycmd, function (e, out, er) {
			_debug('stty exit');
			//console.log(e, out, er)
			if (e || er) {
				console.log(sttycmd, e, er)
				_statusChanged('error');
				return;
			}
			_debug('Init serialport');
			_socket[vars.device] = new app._m.serialport(vars.device, {
				baudRate: 1 * vars.speed,
				dataBits: vars.dataBits || 7,
				parity: vars.parity || 'even',
				stopBits: 1,
				flowControl: false
			});
			let _openTimeout = setTimeout(function () {
				console.error('Opening port "' + vars.device + '" timed out.');
				_statusChanged('timeout');
			}, 1000 * 15);
			_socket[vars.device].on('open', function () {
				_debug('device opened');
				clearTimeout(_openTimeout);
				if (_status[vars.device].status != 'connected') {
					_statusChanged('connected');
					weightChange(vars.device, 0);
				}
				let _buffer = '';
				_socket[vars.device].on('data', function (data) {
					const buf2 = Buffer.from(data)
					let wArray = buf2.toString('utf8'),
						_dig = wArray.replace(/[^0-9]/, '').trim();
					if (vars.onData) {
						app.tryCatch(function () { vars.onData(data, wArray, _dig); });
					}
					_buffer += '' + _dig;
					_debug('data: ', data, wArray, _dig, _dig.length, _buffer.length);
					if (_buffer.length == vars.weightLength) {
						_debug('weight: ', _buffer);
						//console.log('weight:', _buffer);
						weightChange(vars.device, parseInt(_buffer));
						if (vars.onWeight) {
							app.tryCatch(function () { vars.onWeight(parseInt(_buffer)); });
						}
						_buffer = '';
					}
				});
				// Open errors will be emitted as an error event
				_socket[vars.device].on('error', function (err) {
					_statusChanged('exited');
					console.log(vars.device + ' Error: ', err.message)
					//if (vars.reconnect) setTimeout(function () { _openPort(vars) });
				})
				if (cback) cback({
					write: function (t) {
						_socket[vars.device].write(t)
					}
				});
			});
		});
	},
	weightChange = function (dev, data) {
		if (_lastValue[dev] && _lastValue[dev].weight == data) return;
		_lastValue[dev] = {
			date: new Date().toISOString(),
			unit: app.pathExists(app.data, 'session.configs.weightScale.unit') || 'kg',
			weight: data
		};
		//set register status data

		try {
			if (app.pathExists(app.pos, 'win.window.APPFCTS.weightScale._updated'))
				app.pos.win.window.APPFCTS.weightScale._updated(app._m.xtend.clone(_lastValue[dev]));
		} catch (er) { console.error(er.message) }
		if (app.pathExists(app.data, 'session.configs.weightScale.broadcast.enabled') == '1') {
			//broadcast to other registers
			if (app.pathExists(app.data, 'session.configs.weightScale.debug') == '1') console.log('weightScale.weightChange sending:', data)
			app.pos.neighbors.broadcast({ module: 'weightScale', action: 'weightChange', data: _lastValue[dev] });
		}
		printWeightLabel(data);
	},
	printWeightLabel = function (weight) {
		return;
		if (!weight || app.pathExists(app.data, 'session.configs.weightScale.printLabelOnChange.enabled') != '1')
			return false;
		let format = 'pdf', _pwl = app.pathExists(app.data, 'session.configs.weightScale.printLabelOnChange');
		//print tare label
		//get printer configs
		let _printer = app.pathExists(app.data, 'session.configs.printers.' + _pwl.printer + '');

		if (app.pathExists(printer, 'configs.genericText') == '1')
			format = 'raw';
		if (app.pathExists(printer, 'configs.is_mev') == '1')
			format = 'mev';
		if (format == 'pdf') {
			let _doc = app.pos.printManager.setPrinterPDFMargins(_printer);



			let _dpi = 72;
			_doc.availableWidth = mmToPt(_doc.width - _doc.margins.left - _doc.margins.right, _dpi);
			var _margins = { // by default, all are 72
				top: mmToPt(_doc.margins.top, _dpi),
				bottom: mmToPt(_doc.margins.bottom, _dpi),
				left: mmToPt(_doc.margins.left, _dpi),
				right: mmToPt(_doc.margins.right, _dpi)
			}, pdfOptions = {
				layout: 'portrait',
				size: [mmToPt(_doc.width, _dpi), mmToPt(_doc.height, _dpi)],
				margins: _margins
			}
			var doc = new PDFDocument(pdfOptions);
			var _defaultFont = 'Helvetica';
			doc.font(_defaultFont);
			let qrWidthOrig = 26, qrWidth = 0, qrSVG = 84;

			qrWidth = mmToPt(qrWidthOrig, _dpi);
			app.system.qrCode.encode({
				data: {
					type: 'coupon',
					id: coupon.id,
					code: coupon.coupon_code
				},
				//toSVG: 1,
				size: qrWidth * 2,

				saveToFile: app.tmp_folder + tmppdf + '_QR.png',

			}, function (qrsvg) {
				//console.log(qrsvg)

				var file = app._m.fs.createWriteStream(app.tmp_folder + tmppdf + '.pdf');
				doc.pipe(file);
				//doc.addPage();
				//doc.image(app._appPath + 'www/assets/logos/tech-cl/logo_invoice.png', 40, 35, { width: 80 });
				doc.fontSize(14);
				doc.text('', _margins.left, _margins.top)
					.text(app.data.session.configs.branch.name, {
						width: _doc.availableWidth,
						align: 'center',
						ellipsis: true
					});
				doc.fontSize(9);
				//_doc.availableWidth / 2 - qrWidth / 2 +
				let _y = 1 * doc.y;
				doc.image(app.tmp_folder + tmppdf + '_QR.png', _margins.left, _y, { fit: [qrWidth, qrWidth] });
				//SVGtoPDF(doc, qrsvg, _margins.left, _y);


				doc.text('', _margins.left + qrWidth + 3, _y)
			});
		}
	},
	statusChange = function (dev, status) {
		if (_status[dev] && _status[dev].status == status) return;
		_status[dev] = {
			date: new Date().toISOString(),
			status: status
		};
		try {
			if (app.pathExists(app.pos, 'win.window.APPFCTS.weightScale'))
				app.pos.win.window.APPFCTS.weightScale._statusChanged(app._m.xtend.clone(_status[dev]));
		} catch (er) { }
		if (app.pathExists(app.data, 'session.configs.weightScale.broadcast.enabled') == '1') {
			//broadcast to other registers

			if (app.pathExists(app.data, 'session.configs.weightScale.debug') == '1') console.log('weightScale.statusChange sending:', status)
			app.pos.neighbors.broadcast({ module: 'weightScale', action: 'statusChange', data: _status[dev] });
		}
	},
	weightScale = {
		init: function (parent) {
			app = parent;
			pos = app.pos;
		},
		_logAll: {},
		testChange: function (dev, weight) {
			weightChange(dev, weight);
		},
		sendDataToNeighbor: function (s) {
			if (weightScale.enabled() && app.pathExists(app.data, 'session.configs.weightScale.broadcast.enabled') == '1') {
				let device = '' + app.pathExists(app.data, 'session.configs.weightScale.device');
				if (app.pathExists(app.data, 'session.configs.weightScale.debug') == '1')
					console.log('Sending weightScale to neighbor ' + s);
				app.pos.neighbors.send(s, { module: 'weightScale', action: 'statusChange', data: _status[device] });
				app.pos.neighbors.send(s, { module: 'weightScale', action: 'weightChange', data: _lastValue[device] });
			}
		},
		routeEvent: function (d) {
			delete d.socket;
			switch (d.action) {
				case 'statusChange':
				case 'weightChange':
					let _type = 'status';
					if (d.action == 'weightChange') _type = 'weight';
					if (!_registers[d.originNode]) _registers[d.originNode] = { status: null, weight: null };
					if (_registers[d.originNode][_type] && new Date(_registers[d.originNode][_type].date).getTime() > new Date(d.data.date).getTime()) return;
					_registers[d.originNode][_type] = d.data;
					if (app.pathExists(app.data, 'session.configs.weightScale.debug') == '1') console.log(_type + ' change from ' + d.originNode + ': ' + d.data[_type]);
					if (app.pathExists(app.pos, 'win.window.APPFCTS.weightScale')) {
						if (!app.pathExists(app.pos, 'win.window.APPFCTS.weightScale.neighbors._data'))
							app.pos.win.window.APPFCTS.weightScale.neighbors._data = app._m.xtend.clone(_registers);
						else
							app.pos.win.window.APPFCTS.weightScale.neighbors._data[d.originNode] = app._m.xtend.clone(_registers[d.originNode]);
						app.pos.win.window.APPFCTS.weightScale.neighbors._changed(d.originNode, _type);
					}
					break;
			}
		},
		enabled: function () {
			return app.pathExists(app.data, 'session.configs.weightScale.enabled') == "1" && app.pathExists(app.data, 'session.configs.weightScale.device');
		},
		getStatus: function (vars, cback) {
			//connected to port?
			//get current reading
			if (!weightScale.enabled()) {
				if (cback) cback(-1);
				return null;
			}
			//let device = '' + app.pathExists(app.data, 'session.configs.weightScale.device'), _s = app._m.xtend.clone(_status[device])
			let _out = {}
			for (i of Object.keys(_status)) {
				_out[i] = {
					status: _status[i],
					data: _lastValue[i]
				}
			}
			let _s = app._m.xtend.clone(vars?.device ? _out[device] : _out);
			if (cback) cback(_s);
			return _s;
		},
		getData: function (win, cback) {
			if (typeof win == 'function' && !cback) {
				cback = win;
				win = null;
			}
			let
				_win = win || app.pos.win,
				device = '' + app.pathExists(app.data, 'session.configs.weightScale.device'),
				data = {
					status: app.pathExists(_status, device) ? app._m.xtend.clone(_status[device]) : null,
					weight: app.pathExists(_lastValue, device) ? app._m.xtend.clone(_lastValue[device]) : null,
					neighbors: null
				};
			try {
				data.neighbors = weightScale.getNeighbors(win);
			} catch (er) { }
			if (cback) cback(data);
			try {
				_win.window.APPFCTS.weightScale._statusChanged(data.status);
			} catch (er) { }

			try {
				_win.window.APPFCTS.weightScale._updated(data.weight);
			} catch (er) { }
			if (!win) {
				try {
					app.pos.production.workstation.win.window.APPFCTS.weightScale._statusChanged(data.status);
				} catch (er) { }
				try {
					app.pos.production.workstation.win.window.APPFCTS.weightScale._updated(data.weight);
				} catch (er) { }
			}
			return data;
		},
		getNeighbors: function (win) {
			let _r = app._m.xtend.clone(_registers);
			try {

				let _win = win || app.pos.win;
				_win.window.APPFCTS.weightScale.neighbors._data = _r;

				if (!win) {
					try {
						app.pos.production.workstation.win.window.APPFCTS.weightScale.neighbors._data = _r;
					} catch (er) { }
				}
			} catch (er) { }
			return _r;
		},
		getReading: function (vars, cback) {
			//connected to port?
			//get current reading
			if (!weightScale.enabled()) {
				if (cback) cback(-1);
				return false;
			}
			let device = '' + app.pathExists(app.data, 'session.configs.weightScale.device')
			weightScale.connect(function () {
				cback(app._m.xtend.clone(_lastValue[device]))
			})
		},
		connect: function (cback) {
			if (!weightScale.enabled()) {
				if (cback) cback(null);
				return false;
			}
			let
				cbacked = false;
			device = '' + app.pathExists(app.data, 'session.configs.weightScale.device');
			if (_socket[device] && _lastValue[device]) {
				if (cback) cback(app._m.xtend.clone(_lastValue[device]));
				return;
			}
			clearInterval(_keepAlive);
			_openPort({
				reconnect: true,
				device: device,
				dataBits: app.pathExists(app.data, 'session.configs.weightScale.dataBits'),
				parity: app.pathExists(app.data, 'session.configs.weightScale.parity'),
				weightLength: app.pathExists(app.data, 'session.configs.weightScale.dataLength') || 5,
				debug: app.pathExists(app.data, 'session.configs.weightScale.debug') == '1',
				speed: (app.pathExists(app.data, 'session.configs.weightScale.device.baudrate') || '9600'),
				onStatus: function (_status) {

				},
				onData: function (data, wArray) {
					if (weightScale._logAll[device])
						console.log('weightScale ' + device, data, wArray)

				},
				onWeight: function (data) {
					//console.log('got weight', data);
					try {
						if (cback && !cbacked) {
							cback(app._m.xtend.clone(_lastValue[device]));
							cbacked = true;
						}
					} catch (er) { console.error(er.message) }
				}
			}, function (p) {
				p.write('W');
				_keepAlive = setInterval(function () {
					if (new Date().getTime() - new Date(_lastValue[device].date) > 1000 * 60 * 3)
						p.write('W');
				}, 1000 * 60);
			})
		}
	};
module.exports = weightScale;