var app, self, _locks = {},
	_setUnlockFct = function (id, force) {
		return function () {
			if (id && _locks[id]) {
				clearTimeout(_locks[id].autoUnlock);

				self.broadcast({
					action: 'unlock',
					data: { id: id, force: force || false }
				})
				delete _locks[id];
			}
		}
	};
module.exports = class locks {
	constructor(parent) {
		app = parent;
		self = this;
	}
	initialize(cback) {
		setInterval(function () {
			//clear expired locks
			let k = Object.keys(_locks);
			for (let i = 0; i < k.length; i++) {
				if (!k[i]) continue;
				let e = self.exists(k[i]);
				if (e && e.expires && new Date(e.expires).getTime() < new Date().getTime() - 1000 * 60 * 3) {
					//chow bye.
					if (!_locks[k[i]].unLock)
						_locks[k[i]].unLock = _setUnlockFct(k[i], true);
					_locks[k[i]].unLock();
				}
			}
		}, 1000 * 60);

	}
	exists(id) { //app.pos.neighbors.locks.exists=function(id){
		return _locks[id] ? { owner: '' + _locks[id].owner, expires: app._m.moment(_locks[id].date).add(_locks[id].ttl / 1000, 'seconds').toISOString() } : false;
	}
	routeEvent(d) {
		//console.info('neighbors.lock.routeEvent', d.action, d.data)
		switch (d.action) {
			case 'currentLocks':
				console.log('Current locks are', d.data)
				_locks = d.data;
				break;
			case 'lockRequest':
				d.data.owner = d.socket.deviceUUID;
				self.lock(d.data, d.cback);
				break;
			case 'releaseLock':
				d.data.device = d.socket.deviceUUID;
				self.releaseLock(d.data);
				break;

			case 'lock':
				_locks[d.data.id] = d.data;
				break;
			case 'unlock':
				//if(id && _locks[id].owner!=d.socket.deviceUUID){
				self.unLock(d.data);
				break;
		}
	}
	broadcast(data) {
		data.module = 'locks';
		app.pos.neighbors.broadcast(data);
	}
	lock(data, cback) {
		if (_locks[data.id]) {
			//console.log(data.id, 'already locked by', _locks[data.id].owner)
			cback({ unlock: null, error: null, owner: '' + _locks[data.id].owner });
			return;
		}
		if (!data.ttl) data.ttl = 1000 * 60;
		let _m = app.pos.neighbors._masterNode();
		if (_m && _m != 'null' && app.system.id != _m) {
			//ask master for the lock
			//console.info('asking master for lock')
			self.send(_m, { action: 'lockRequest', data: { id: data.id, ttl: data.ttl } }, function (d) {
				//console.log('Lock request answer', d);
				if (d.unlock) {
					d.unlock = function () {
						self.send(_m, { action: 'releaseLock', data: { id: data.id } });
					}
				}
				cback(d);
			})
			return;
		}
		let id = '' + data.id;

		_locks[id] = {
			id: data.id,
			ttl: data.ttl,
			owner: data.owner || '' + app.system.id,
			date: new Date().toISOString(),
			autoUnlock: setTimeout(function () {
				if (id && _locks[id]) {
					_locks[id].unLock();
				}
			}, data.ttl),
			unLock: _setUnlockFct(id)
		};
		//console.log(_locks[id].owner, _locks[id].owner == app.system.id);
		//send broadcast info
		self.broadcast({
			action: 'lock',
			data: {
				owner: _locks[id].owner,
				date: _locks[id].date,
				ttl: _locks[id].ttl,
				id: id
			}
		})
		cback({ unlock: _locks[id].owner == app.system.id ? _locks[id].unLock : true, error: null });
	}
	unLock(d) {
		if (d.id && _locks[d.id]) {
			if (typeof _locks[d.id].autoUnlock != 'undefined')
				clearTimeout(_locks[d.id].autoUnlock);
			delete _locks[d.id];
			//let _m=app.pos.neighbors._masterNode();
			//if(_m && _m!='null' && app.system.id!=_m){
			//	self.send(_m,{action:'unlock',data:{id:id}})
			//}
		}
	}
	releaseLock(d) {
		if (self.exists(d.id) && _locks[d.id].owner == d.device) {
			//unlock
			//console.log('releasing lock')
			if (!_locks[d.id].unLock)
				_locks[d.id].unLock = _setUnlockFct(d.id);
			_locks[d.id].unLock();
		}
	}
	send(node, obj, cback, onAck) {
		obj.module = 'locks';
		app.pos.neighbors.send(node, obj, cback, onAck);
	}
	sendCurrentLocks(node) {
		self.send(node, { action: 'currentLocks', data: _locks });
	}
};