import { ProxySetting } from "./proxy-settings";
/**
 * Validate the given proxy setting
 * @param setting Proxy setting to validate.
 *
 * @throws {ProxyConnectionRefusedError} if it cannot connect to the proxy
 * @throws {ProxyAuthenticationRequiredError} if proxy settings doesn't have credentials but is required
 * @throws {ProxyInvalidCredentialsError} if proxy settings has credentials but proxy denies the request(407)
 * @throws {GetProxyError} for other errors
 */
export declare function validateProxySetting(setting: ProxySetting): Promise<boolean>;
