var self, _restartServer, $;
module.exports = class Manager {
	constructor(parent) {
		if (parent) {
			this.lc = parent;
			this.pos = parent.pos;
			this.app = parent.pos.app;
			this.log = '';
			this.testing = false;
		}
	}
	initialize(restartServer) {
		var self = this;
		_restartServer = restartServer;
		nw.Window.open(app._relativePath + 'libs/liquorControl/dialogs/manage/manage.html', {
			width: 624,
			height: 525,
			title: self.app.parseLocales('liquor_control_manager.title'),
			resizable: false
		}, function (win) {
			self.win = win;
			win.on('loaded', function () {
				$ = win.window.jQuery;
				app.pos.setTotop(false);
				win.focus();
				if (self.app.cfg.env == 'prod')
					self.win.setAlwaysOnTop(true);
				// Set the locales
				let elems = win.window.document.getElementsByClassName('localized');
				for (let e = 0; e < elems.length; e++)
					elems[e].innerHTML = self.app.parseLocales(elems[e].dataset.locale);
				// Set event listners
				$('#liquor_control_provider').on('change', function () {
					//var model = win.window.document.getElementById('liquor_control_model');
					//model.innerHTML = '';
					switch ($('#liquor_control_provider').val()) {
						case 'CTRLPLUS':
							$('#liquor_control_mode [value="ip"]').removeAttr('disabled');
							$('#liquor_control_mode [value="serial"]').attr('disabled', 'disabled');
							$('#liquor_control_mode').val("ip").change();
							break;
						case 'AZ200':
							$('#liquor_control_mode [value="ip"]').attr('disabled', 'disabled');
							$('#liquor_control_mode [value="serial"]').removeAttr('disabled');
							$('#liquor_control_mode').val("serial").change();
							break;
					}
				}).change();

				win.window.document.getElementById('liquor_control_mode').onchange = function () {
					var elems = win.window.document.getElementsByClassName('protocol-group');
					for (let e = 0; e < elems.length; e++)
						elems[e].style.display = 'none';
					win.window.document.getElementById(win.window.document.getElementById('liquor_control_mode').value + '-group').style.removeProperty('display');
				};
				win.window.document.getElementById('liquor_control_mode').dispatchEvent(new Event('change'));
				// Set the values
				var keys = Object.keys(self.lc.cfg);
				for (let k in keys)
					try {
						win.window.document.getElementById('liquor_control_' + keys[k]).value = self.lc.cfg[keys[k]];
						win.window.document.getElementById('liquor_control_' + keys[k]).checked = self.lc.cfg[keys[k]];
						win.window.document.getElementById('liquor_control_' + keys[k]).dispatchEvent(new Event('change'));
					} catch (e) { }
				self.win.window.onTest = function () { self.validate(function () { self.test(); }); };
				self.win.window.onPair = function () { self.pair(); };
				self.win.window.onClose = function () { self.win.close(); };
			}).on('closed', function () {
				self.lc.dialogs.manager = null;

				app.pos.setTotop(true);
				if (_restartServer)
					self.lc.server.start();
			});
		});
	}
	pair() {
		var self = this;
		var provider = self.win.window.document.getElementById('liquor_control_provider').value;
		if (provider == 'NONE') {
			self.app.sessions.updateCfg({
				liquor_control_device: {
					provider: 'NONE',
					model: '',
					mode: '',
					port: '',
					comm: '',
					receive_drinks_from_pos: false,
					send_drinks_to_pos: false
				}
			}, function (data) {
				if (data.result == 'success') {
					self.log += self.app.parseLocales('liquor_control_manager.statusses.config_saved') + '.';
					self.pos.initializeLiquorControl();
				} else
					self.log += self.app.parseLocales('liquor_control_manager.statusses.config_not_saved') + '.';
				self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
				self.log = '';
			});
			return;
		}
		self.validate(function () {
			self.test(function () {
				function save() {
					var lc = {
						provider: self.win.window.document.getElementById('liquor_control_provider').value,
						mode: self.win.window.document.getElementById('liquor_control_mode').value,
						receive_drinks_from_pos: self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').checked,
						send_drinks_to_pos: self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').checked
					};
					if (lc.mode == 'ip') {
						lc.port = self.win.window.document.getElementById('liquor_control_port').value;
						lc.com = '';
					} else {
						lc.port = '';
						lc.com = self.win.window.document.getElementById('liquor_control_com').value;
					}
					self.app.sessions.updateCfg({
						liquor_control_device: lc
					}, function (data) {
						if (data.result == 'success') {
							self.log += self.app.parseLocales('liquor_control_manager.statusses.config_saved') + '.';
							self.pos.initializeLiquorControl();
						} else
							self.log += self.app.parseLocales('liquor_control_manager.statusses.config_not_saved') + '.';
						self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
						self.log = '';
						self.testing = false;
						self.lc.comm.disconnect();
					});
				}
				save();
			});
		});
	}

	validate(success, error) {
		var self = this;
		if (self.testing)
			return;
		self.testing = true;
		var port_field = $('#liquor_control_port_field'),
			com_field = $('#liquor_control_com_field'),
			valid = true;
		const PORT = 1 * port_field.find('.form-control').val(),
			COM = com_field.find('.form-control').val(),
			mode = $('#liquor_control_mode').val();
		if (mode == 'ip') {
			if (!PORT || PORT < 0 || PORT > 65536) {
				port_field.addClass('has-error').removeClass('has-success');
				valid = false;
			} else {
				port_field.removeClass('has-error').addClass('has-success');
			}
		} else if (mode == 'serial') {
			if (COM.length && /^(COM|\/dev\/tty(USB|S))[0-9]+$/.test(COM)) {
				com_field.removeClass('has-error').addClass('has-success');
			} else {
				com_field.addClass('has-error').removeClass('has-success');
				valid = false;
			}
		}

		var lc = {
			provider: self.win.window.document.getElementById('liquor_control_provider').value,
			receive_drinks_from_pos: self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').checked,
			send_drinks_to_pos: self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').checked
		};

		if (lc.provider != 'NONE') {
			if (!lc.receive_drinks_from_pos && !lc.send_drinks_to_pos) {
				self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').parentElement.classList.add('has-error');
				self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').parentElement.classList.add('has-error');
				valid = false;
			} else {
				self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').parentElement.classList.remove('has-error');
				self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').parentElement.classList.remove('has-error');
				self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').parentElement.classList.add('has-success');
				self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').parentElement.classList.add('has-success');
			}
		} else {
			self.win.window.document.getElementById('liquor_control_receive_drinks_from_pos').parentElement.classList.remove('has-error');
			self.win.window.document.getElementById('liquor_control_send_drinks_to_pos').parentElement.classList.remove('has-error');
		}

		/*if(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/.test(IP)){
			ip_field.classList.remove('has-error');
			ip_field.classList.add('has-success');
		}else{
			ip_field.classList.add('has-error');
			ip_field.classList.remove('has-success');
			valid = false;
		}*/
		var cback;
		if (valid) {
			self.log += self.app.parseLocales('liquor_control_manager.statusses.valid_config');
			if (typeof success == 'function') {
				self.log += '...\n';
				cback = success;
			} else
				self.log += '.';
		} else {
			self.log += self.app.parseLocales('liquor_control_manager.statusses.invalid_config');
			if (typeof error == 'function') {
				self.log += '...\n';
				cback = error;
			} else
				self.log += '.';
		}
		self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
		if (typeof cback == 'function')
			cback();
		else {
			self.log = '';
			self.testing = false;
		}
	}
	test(success, error) {
		var self = this;
		const net = require('net'),
			PORT = self.win.window.document.getElementById('liquor_control_port').value,
			COM = self.win.window.document.getElementById('liquor_control_com').value,
			mode = self.win.window.document.getElementById('liquor_control_mode').value;
		if (mode == 'ip') {
			var svr = net.createServer();
			svr.on('error', function (err) {
				svr.close();
				if (err.errno == 'EADDRINUSE')
					self.log += self.app.parseLocales('liquor_control_manager.statusses.port_in_use') + '.';
				else if (err.errno == 'EACCES')
					self.log += self.app.parseLocales('liquor_control_manager.statusses.port_refused') + '.';
				else
					self.log += self.app.parseLocales('liquor_control_manager.statusses.unknown_error') + ' (' + err.errno + ')' + '.';

				self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
				self.log = '';
				if (typeof error == 'function')
					error();
				else
					self.testing = false;
			});
			svr.listen(PORT, function () {
				svr.close();
				self.log += self.app.parseLocales('liquor_control_manager.statusses.server_started');
				if (typeof success == 'function') {
					self.log += '...\n';
					self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
					success();
				} else {
					self.log += '.';
					self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
					self.log = '';
					self.testing = false;
				}
			});
		} else {
			if (typeof success == 'function') {
				success();
			} else {
				self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log.substr(0, self.log.length - 3);
				self.log = '';
				self.testing = false;
			}
			return;
			this.app._m.exec('setserial -g ' + COM, function (err, sout, serr) {
				if (err)
					console.error('testing serial port', err);

				if (sout && sout.indexOf('Port: 0x0000') == -1) {
					self.log += self.app.parseLocales('liquor_control_manager.statusses.port_valid');
					if (typeof success == 'function') {
						self.log += '...\n';
						self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
						success();
					} else {
						self.log += '.';
						self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
						self.log = '';
						self.testing = false;
					}
				} else {
					self.log += self.app.parseLocales('liquor_control_manager.statusses.port_invalid');
					if (typeof error == 'function') {
						self.log += '...\n';
						self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
						error();
					} else {
						self.log += '.';
						self.win.window.document.getElementById('liquor_control_logs').innerHTML = self.log;
						self.log = '';
						self.testing = false;
					}
				}
			});
		}
	}
};