var app, _sessInitTimer, _onCfgChange = [], _doWhenInit = [], cbacks = {}, _errorActivity = {}, _onLicenceChange = [], sessions = {
	initialize: function (parent) {
		app = parent;
	},
	onConfigChange: function (fct) {
		_onCfgChange.push(fct);
	},
	onLicenceChange: function (fct) {
		_onLicenceChange.push(fct);
	},
	routeEvent: function (d, cback) {
		switch (d.action) {
			case 'set':
				sessions.set(d.datas);
				sessions.setAutoStart();
				break;
			case 'update':
			case 'reload':
				sessions.sendInit();
				if (app.cfg.env == 'dev') console.log('received session.' + d.action)
				break;
			case 'ping':
				d.datas.uptime = { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime };
				d.datas.cpuInfo = app.system.vars.systemInfo.cpu;
				if (d.cback) d.cback({ ping: 'pong', eventLoop: app.eventLoopLag._current, uptime: d.datas.uptime, diskUsage: app.system.diskUsage._data });
				else if (cback) cback({ ping: 'pong', eventLoop: app.eventLoopLag._current, uptime: d.datas.uptime, diskUsage: app.system.diskUsage._data });
				else {
					d.datas.eventLoop = app.eventLoopLag._current;
					d.datas.diskUsage = app.system.diskUsage._data;
					app.web.emit({
						module: 'sessions',
						action: 'pingBack',
						datas: d.datas
					});
				}
				break;
			case 'updateCfg':
				if (d.datas.result == 'success')
					app.data.session.configs = d.datas.cfg;
				if (d.cback && typeof cbacks[d.cback] == 'function') {
					setTimeout(function () {
						delete cbacks[d.cback];
					}, 5000);
					cbacks[d.cback](d.datas);
				}
				app.printManager.checkPrintersChanges();
				if (_onCfgChange && _onCfgChange.length) {
					for (i = 0; i < _onCfgChange.length; i++) {
						try {
							_onCfgChange[i]();
						} catch (er) { }
					}
				}
				sessions.setAutoStart();
				break;
			case 'registerIsUp':
				//console.log('REG IS UP', d.datas)
				app.data.session.configs.registers[d.datas.id] = d.datas.data;
				//sessions.pingOthers.initReg(d.datas.id);
				app.pos.neighbors.connectToNode(d.datas.id);
				break;
			case 'licenceUpdate':
				console.log('sessions.licenceUpdate', d.data)
				if (app.data.session.licence.enabled != d.data.short.enabled) {
					//if now enabled
					if (d.data.short.enabled == '1') {

					}
					//if now disabled
					else {

					}
				}
				app.data.session.licence = d.data.short;
				app.data.session.configs.branch.licence = d.data.full;

				if (_onLicenceChange.length) {
					for (let i = 0; i < _onLicenceChange.length; i++) {
						try {
							_onLicenceChange[i]();
						} catch (er) { }
					}
				}

				break;
			case 'getCurrentSession':
				if (cback) cback(app.data.session);
				break;
			default:
				if (app.cfg.env == 'dev') console.warn('Unhandled event for sessions:' + d.action)
				if (cback) cback({ result: 'error', code: 'invalid_action' });
		}
	},
	init: function () {
		sessions.initSent = true;
		clearTimeout(_sessInitTimer);
		//!app.splashscreen.isInitialized || 
		if (app.web.status != 'online') {
			_sessInitTimer = setTimeout(sessions.init, 1000);
			return;
		}
		sessions.sendInit();

		sessions.router = app.web.express.Router();
		app.web.router.use('/sessions', sessions.router);
		sessions.router.get('/ping', function (req, res) {
			//console.info('PING FROM', req.headers['x-register-id'])
			res.return({ result: 'pong' });
			//try {
			//	sessions.pingOthers.initReg(req.headers['x-register-id']);
			//} catch (er) { }
		});
	},
	doWhenInit: function (f) {
		if (app && app.data && app.data.session && sessions.sessionIsSet) {
			f(); //do not return!!!!
		}
		_doWhenInit.push(f);
	},
	sendInit: function () {
		if (app.status == 'shutdown') return;
		if (!app.diag.basicData) {
			console.info('waiting for diag data')
			setTimeout(sessions.sendInit, 1000);
			return;
		}
		sessions.sessionIsSet = false;
		let basicData = app._m.xtend.clone(app.diag.basicData);
		let interfaces = {}, _ifaces = app._m.os.networkInterfaces(), _keys = Object.keys(_ifaces);
		for (let i = 0; i < _keys.length; i++) {
			let _l = _keys[i].toLowerCase();
			if (_l.indexOf('lo') === 0 || _l.indexOf('docker') != -1 || _l.indexOf('loopback') != -1)
				continue;
			for (let x = 0; x < _ifaces[_keys[i]].length; x++) {
				if (_ifaces[_keys[i]][x].family == 'IPv4' && !interfaces[_keys[i]])
					interfaces[_keys[i]] = _ifaces[_keys[i]][x];
			}
		}
		basicData.interfaces = interfaces;
		sessions._sessionInit = {
			sentDate: new Date().toISOString()
		};
		app.web.emit({
			module: 'sessions',
			action: 'init',
			datas: {
				uuid: app.system.id,
				macAddress: app.system._data.macAddress,
				hostname: os.hostname(),
				platform: app.cfg.platform,
				version: app.cfg.version,
				pos_status: {
					version: {
						buildDate: '' + app.cfg.buildDate,
						version: app.cfg.version,
						channel: (app.cfg.channel || app.manifest?.channel || '').split('channels/').pop(),
						flavor: process.versions["nw-flavor"] == 'sdk' ? 'SDK' : 'LIVE',
					},
					printers: app.pathExists(app, 'utilities.printers'),
					sysInfo: app.system.vars.systemInfo,
					network: basicData,
					support: app.system.support.credz
				}, eventLoop: app.eventLoopLag._current
			}
		}, null, function (ack) {
			//console.info('session ack', ack) 
		});
	},
	setAutoStart: function () {
		if (app.cfg.platform.indexOf('win') != -1) {
			let _lp = 'C:\\Users\\' + app._m.os.userInfo().username + '\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup';
			if (app.pathExists(app.data.session.configs, 'launchOnBoot.enabled') == '1') {
				//C:\Users\USERNAME\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup
				app.system.winLinkMaker.makeSync({
					'lnkName': 'AzimutPOS',
					'filepath': 'C:\\Program Files\\AzimutPOS\\etc\\scripts\\launcher\\AzimutPOS.bat',
					'lnkCwd': 'C:\\Program Files\\AzimutPOS\\',
					'lnkIco': 'C:\\Program Files\\AzimutPOS\\AzimutPOS.png',
					'linkPath': _lp
				})
				return;
			}
			app._m.fs.unlink(_lp + '\\AzimutPOS.lnk', function () { });

			return;
		}
		if (app.pathExists(app.data.session.configs, 'launchOnBoot.enabled') == '1') {
			app._m.fs.ensureDirSync('/home/' + app._m.os.userInfo().username + '/.config/autostart');
			app._m.fs.writeFile('/home/' + app._m.os.userInfo().username + '/.config/autostart/AzimutPOS.desktop',
				'[Desktop Entry]\n' +
				'Type=Application\n' +
				'Name=AzimutPOS\n' +
				'Exec=/bin/bash /home/' + app._m.os.userInfo().username + '/AzimutPOS/etc/scripts/launcher/AzimutPOS.sh\n' +
				'NoDisplay=true\n', function () {

				});
			return;
		}
		app._m.fs.unlink('/home/' + app._m.os.userInfo().username + '/.config/autostart/AzimutPOS.desktop', function () { });
	},
	set: function (data) {
		var oldSession = app._m.xtend.clone(app.data.session);
		app.data.session = data;
		try {
			app.pos._cfg = app.data.session.configs;
		} catch (er) { }
		//console.log(app.data.session.configs.registers)
		app.system.localConfig.set();
		try {
			if (!app.pathExists(oldSession, 'configs.vnckey') || app.pathExists(data, 'configs.vnckey') != app.pathExists(app.data, 'session.configs.vnckey')) {
				app._m.fs.mkdir(app.cacheDir, function () {
					if (app.pathExists(app.data, 'session.configs.vnckey'))
						app._m.fs.writeFileSync(app.cacheDir + 'support_code', app.data.session.configs.vnckey);
				});
			}
		} catch (er) { console.error(er) }
		sessions.sessionIsSet = true;
		setTimeout(function () {
			app.web.processSendQueue();
			app.printManager.checkPrintersChanges();
		}, 1000);
		sessions._sessionInit.setDate = new Date().toISOString();
		sessions._sessionInit.took = (new Date(sessions._sessionInit.setDate).getTime() - new Date(sessions._sessionInit.sentDate).getTime()) / 1000;
		console.log('SESSION IS SET FROM CLOUD! took ' + sessions._sessionInit.took + 's, ' + _doWhenInit.length + ' listeners')
		if (_doWhenInit.length) {
			for (let i of _doWhenInit) {
				try {
					i();
				} catch (er) {
					console.error(er.message);
				}
			}
			//_doWhenInit = [];
		}
		else {

			//received session.set, no listners
		}
		app.splashscreen.unsetMessage('connecting_to_server');
		app.splashscreen.unsetMessage('validatin_licence');
		if (app.pathExists(app, 'data.session.result') == 'success') {
			try {
				if (system.vars.isOnFrontCloud) {
					app._m.evilDns.add(app.data.session.configs.branch.id + '.technopos.lan', '192.168.94.1');
					app._m.evilDns.add(app.data.session.configs.branch.id + '.azimutpos.lan', '192.168.94.1');
				}
			} catch (er) { }

			try {
				app.pos.win.window.APPFCTS.system.routePOSEvent({ module: 'system', action: 'setRegisterConfig', data: app.data.session.configs });
			} catch (er) { }

			setTimeout(function () {
				app.pos.neighbors.initSockets();
			}, 1000 * 3);
			app.system.diskUsage.get();
			app.system.update._updateTimer = setTimeout(function () {
				app.system.update.check({ doNotApply: 0, silent: 0, executeNoRestart: 1 });
			}, 1000 * 60 * 5);
		}
		setTimeout(function () {

			try {
				if (app.pathExists(app, 'data.session.result') == 'error') {

					try { app.pos.hideWindow(); } catch (er) { }
					try { app.pos.win.hide(); } catch (er) { }
					try { app.splashscreen.win.show(); } catch (er) { }
					if (_errorActivity && !app.isEmptyObject(_errorActivity)) {

						_errorActivity.update_date = new Date().toISOString();
						_errorActivity.time_on_page = app.pos?._lastActivity ? (new Date(app.pos._lastActivity.update_date).getTime() - new Date(app.pos._lastActivity.date).getTime()) / 1000 : 0;

						app.web.emit({
							module: 'pos',
							action: 'updateActivity',
							data: {
								id: _errorActivity.id,
								update_date: _errorActivity.update_date,
								time_on_page: _errorActivity.time_on_page,
								ended: 0
							},
							eventLoop: app.eventLoopLag._current,
							uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
							cpuInfo: app.system.vars.systemInfo.cpu
						});
					}
					else {
						_errorActivity = {
							id: app.system.uuid.get(),
							action: 'session',
							date: new Date().toISOString(),
							url: app.pathExists(app, 'data.session.code') || 'error'
						};
						app.web.emit({
							module: 'pos',
							action: 'recordActivity',
							data: _errorActivity,
							eventLoop: app.eventLoopLag._current,
							uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
							cpuInfo: app.system.vars.systemInfo.cpu
						});
					}
				}
				else {
					if (_errorActivity && !app.isEmptyObject(_errorActivity)) {

						_errorActivity.update_date = new Date().toISOString();
						_errorActivity.time_on_page = app.pos?._lastActivity ? (new Date(app.pos._lastActivity.update_date).getTime() - new Date(app.pos._lastActivity.date).getTime()) / 1000 : 0;

						app.web.emit({
							module: 'pos',
							action: 'updateActivity',
							data: {
								id: _errorActivity.id,
								update_date: _errorActivity.update_date,
								time_on_page: _errorActivity.time_on_page,
								ended: 1
							},
							eventLoop: app.eventLoopLag._current,
							uptime: { service: app.system.vars.systemInfo.appUptime, system: app.system.vars.systemInfo.uptime },
							cpuInfo: app.system.vars.systemInfo.cpu
						});
						setTimeout(function () {
							_errorActivity = null;
						}, 500);
					}
				}
			}
			catch (er) { console.error(er.message) }
		}, 5000);

		if (app.pathExists(app, 'data.session.result') == 'wizard' && (!oldSession || app.pathExists(oldSession, 'result') != 'wizard')) {
			try { if (app.pos?.unsetWindow) app.pos.unsetWindow(); } catch (er) { }
			app.splashscreen.showWizard(app.data.session.code);
			app.splashscreen.win.show();
		}

		if (_onCfgChange && _onCfgChange.length) {
			for (i = 0; i < _onCfgChange.length; i++) {
				try {
					_onCfgChange[i]();
				} catch (er) { }
			}
		}
	},
	//pingOthers: {
	//	_regz: {},
	//	init: function () {
	//		if (!app.pathExists(app.data, 'session.configs.registers')) return false;
	//		let keys = Object.keys(app.data.session.configs.registers);
	//		for (let i = 0; i < keys.length; i++) {
	//			if (keys[i] == app.system.id) continue;
	//			sessions.pingOthers.initReg(keys[i]);
	//		}
	//		let ekeys = Object.keys(sessions.pingOthers._regz);
	//		for (let i = 0; i < ekeys.length; i++) {
	//			if (!app.data.session.configs.registers[ekeys[i]] && ekeys[i] != app.system.id)
	//				sessions.pingOthers.remReg(keys[i]);
	//		}
	//	},
	//	initReg: function (id) {
	//		if (sessions.pingOthers._regz[id]) return false;
	//		sessions.pingOthers._regz[id] = {
	//			lastSuccess: { date: '', ttl: '' },
	//			lastTry: { date: '', ttl: '' },
	//			timer: null
	//		};
	//		sessions.pingOthers.ping(id);
	//	},
	//	ping: function (id) {
	//		if (!sessions.pingOthers._regz[id]) {
	//			sessions.pingOthers.initReg(id);
	//			return;
	//		}
	//		clearTimeout(sessions.pingOthers._regz[id].timer);
	//		var _prevStatus = app.pathExists(sessions.pingOthers, '_regz.' + id + '.lastTry');
	//		sessions.pingOthers._regz[id].lastTry = {
	//			date: new Date().toISOString(),
	//			status: 'pending',
	//			ttl: 0
	//		};
	//		var tmot = setTimeout(function () {
	//			sessions.pingOthers._regz[id].lastTry.timeout = 1;
	//			sessions.pingOthers._regz[id].lastTry.status = 'timeout';
	//			sessions.pingOthers._regz[id].online = 0;
	//			sessions.pingOthers._regz[id].lastTry.ttl = (new Date().getTime() - new Date(sessions.pingOthers._regz[id].lastTry.date).getTime()) / 1000;
	//			//console.warn('PING TO', id, 'TIMED OUT')
	//		}, 1000 * 30);
	//		app.web.get(id, { path: '/sessions/ping', opts: { timeout: 3000, options: { maxTries: 3 } } }, function (e, r, b) {
	//			clearTimeout(tmot);
	//			sessions.pingOthers._regz[id].lastTry.ttl = (new Date().getTime() - new Date(sessions.pingOthers._regz[id].lastTry.date).getTime()) / 1000;
	//			sessions.pingOthers._regz[id].lastTry.status = 'error';
	//			sessions.pingOthers._regz[id].online = 0;
	//			if (b && b.result == 'pong') {
	//				sessions.pingOthers._regz[id].lastTry.status = 'success';
	//				sessions.pingOthers._regz[id].online = 1;
	//				sessions.pingOthers._regz[id].lastTry.timeout = 0;
	//				sessions.pingOthers._regz[id].lastSuccess = {
	//					date: new Date().toISOString(),
	//					ttl: 1 * sessions.pingOthers._regz[id].lastTry.ttl
	//				};
	//			}
	//			else if (e) {
	//				if (!e.isNetError && (!e.code || !_prevStatus || _prevStatus && _prevStatus.code && _prevStatus.code != e.code))
	//					console.warn('PING TO', id, 'GOT', e.message || e, e.code || '', b)
	//
	//				clearTimeout(tmot);
	//				sessions.pingOthers._regz[id].lastTry.ttl = (new Date().getTime() - new Date(sessions.pingOthers._regz[id].lastTry.date).getTime()) / 1000;
	//				sessions.pingOthers._regz[id].lastTry.timeout = 1;
	//				sessions.pingOthers._regz[id].lastTry.code = e.code;
	//				sessions.pingOthers._regz[id].lastTry.status = 'error';
	//				sessions.pingOthers._regz[id].online = 0;
	//			}
	//			else {
	//				sessions.pingOthers._regz[id].timer = setTimeout(function () {
	//					sessions.pingOthers.ping(id);
	//				}, 1000);
	//				return;
	//			}
	//			sessions.pingOthers._regz[id].timer = setTimeout(function () {
	//				sessions.pingOthers.ping(id);
	//			}, 1000 * 60);
	//		})
	//	},
	//	remReg: function (id) {
	//		if (!sessions.pingOthers._regz[id]) return;
	//		clearTimeout(sessions.pingOthers._regz[id].timer);
	//	}
	//},
	updateCfg: function (data, cback) {
		var cbackid = null;
		if (typeof cback == 'function') {
			cbackid = (+ new Date());
			cbacks[cbackid] = cback;
		}
		app.web.emit({
			module: 'sessions',
			action: 'updateCfg',
			datas: {
				uuid: app.system.id,
				pos_cfg: data,
			},
			cback: cbackid
		});
		app.system.localConfig.set();
	},
	updateStatus: function (data, cback) {
		var cbackid = null;
		if (typeof cback == 'function') {
			cbackid = (+ new Date());
			cbacks[cbackid] = cback;
		}
		app.web.emit({
			module: 'status',
			action: 'updatePOSStatus',
			datas: {
				pos_status: data
			},
			cback: cbackid
		});
		app.system.localConfig.set();
	}
};
module.exports = sessions;