export declare enum Protocol {
    Http = "http",
    Https = "https",
}
export interface ProxySettingAttributes {
    host: string;
    port: string;
    protocol?: Protocol;
    credentials?: ProxyCredentials;
}
export interface ProxyCredentials {
    username: string;
    password: string;
}
export declare class ProxySetting {
    host: string;
    port: string;
    protocol: Protocol;
    credentials: ProxyCredentials;
    constructor(params: string | ProxySetting | ProxySettingAttributes);
    toString(): string;
    getAuthorizationHeader(): string;
    private _parseUrl(value);
}
export interface ProxySettings {
    http?: ProxySetting;
    https?: ProxySetting;
}
