var
	dbps = 'Z82,Nc3L_ὀνοματοποιΐα_{6Mzc]^t3w#6#]_obiwan_wanabe_r2{DV=tW9_QxM}th=^CG_=^..^=_miaw_f$_kg}V!Yo-?Pbj!',
	dps, dbname, pos,
	app, sqlite3, db = {
		_dbs: {},
		_version: 0,
		_lastTxn: '',
		init: function (parent, cback) {
			app = parent.app;
			pos = parent;
			db.transactions.DB.saveQueue = app.queueProc.init('pos.database.transactions.saveQueue', 1);
			sqlite3 = require('@journeyapps/sqlcipher').verbose();//app.cfg.platform.indexOf('win') != -1 ? 'cross-sqlcipher' : '@journeyapps/sqlcipher'
			if (cback) cback();
		},

		/**
		 * 
		 * USAGE FUNCTIONS
		 */
		/**
		 * 
		 * @param {string} q the query
		 * @param {function} cback 
		 */
		query: function (q, p, cback) {
			if (typeof p == 'function' && !cback) {
				cback = p;
				p = [];
			}
			if (!p) p = [];
			let _doReq = function () {
				db._dbs.primary.default.db[/^SELECT /i.test(q) ? 'all' : 'run'](q, p, function (err, res) {
					cback(err, res);
					if (!err && !/^SELECT /i.test(q)) {
						//save transaction and broadcast only if not a select
						let
							_t = {
								$ID: '' + app.system.uuid.get(),
								$BRANCH: '' + pos._cfg.branch.id,
								$REGISTER: '' + app.system.id,
								$DATE: new Date().toISOString(),
								$TYPE: (function () { try { return q.match(/^(UPDATE|REPLACE|DELETE|INSERT) /i)[1]; } catch (er) { console.warn('cant find query type for "' + q + '"') } return ''; })(),
								$TABLE_NAME: (function () { try { return q.match(/(INTO|FROM|UPDATE) ([a-z0-9\-_]+)(\(| WHERE| SET)/i)[2]; } catch (er) { console.warn('cant find table name for "' + q + '"') } return ''; })(),
								$DATA: JSON.stringify({
									query: q,
									params: p
								})
							};
						db.transactions.DB.saveQueue.add(_t, function (d, n) {
							db.transactions.queue.insert('MAIN', d, function () {

								n();
								//send to others and cloud
								db.transactions.broadCast(d);
							});
						})
					}
				});
			};
			//if (p && typeof p == 'object' && !Array.isArray(p)) {
			//	db._dbs.primary.default.db.prepare(q, p, _doReq);
			//	return;
			//}
			_doReq();
		},
		get: function (q, p, c) {
			if (p && typeof p == 'object' && !Array.isArray(p)) {
				db._dbs.primary.default.db.prepare(q, p, function () {
					db._dbs.primary.default.db.get(q, p, c);
				})
				return;
			}
			db._dbs.primary.default.db.get(q, p, c);
		},
		all: function (q, p, c) {
			if (p && typeof p == 'object' && !Array.isArray(p)) {
				db._dbs.primary.default.db.prepare(q, p, function () {
					db._dbs.primary.default.db.all(q, p, c);
				})
				return;
			}
			db._dbs.primary.default.db.all(q, p, c);
		},
		each: function (q, p, c) {
			if (p && typeof p == 'object' && !Array.isArray(p)) {
				db._dbs.primary.default.db.prepare(q, p, function () {
					db._dbs.primary.default.db.each(q, p, c);
				})
				return;
			}
			db._dbs.primary.default.db.each(q, p, c);
		},
		/**
		 * 
		 * MANAGEMENT FUNCTIONS
		 * 
		 */

		transactions: {
			DB: {
				openDB: function (id, cback) {
					if (!db._dbs.transactions) db._dbs.transactions = {};
					if (db._dbs.transactions[id]) {
						cback();
						return true;
					}
					db.manage.openDB({
						type: 'transactions',
						id: id,
						file: app._m.crypto.createHash('sha1').update(pos._cfg.branch.id + '_' + id).digest('hex') + '.pdf',
						status: 'init'
					}, cback);
				}
			},
			_infoFields: 'ID,DATE,BRANCH,REGISTER,TYPE,TABLE_NAME,DATE_RECEIVED,DATE_PROCESSED,DATE_CLOUD_RECEIVED', //db.transactions._infoFields
			broadCast: function (t) {
				//loop each branchs
				let _notifies = [], _sendToCloud = function () {
					if (!_notifies.length) _notifies = Object.keys(app.data.session.configs.registers);
					//send to cloud, eventually
				};
				if (app.pathExists(app.data, 'session.configs.registers')) {
					let ids = pos.neighbors.getNeighbors({}).ids;
					let keys = Object.keys(app.data.session.configs.registers).filter(function (a) { return a != app.system.id; });
					app._m.async.each(keys, function (k, n) {
						//open branch's queue db and insert
						db.transactions.queue.insert(k, t, function () {
							let _r = app.data.session.configs.registers[k];
							//insert into DB,
							//send event if connected
							if (pos.neighbors.send(k, {
								module: 'pos',
								action: 'event',
								data: {
									module: 'database',
									action: 'newTransaction',
									data: t
								}
							}, function () {
								//cback
							}, function () {
								//ack
							})) {
								//sent directly or via alternate route
							}
							else if (app.pathExists(_r, 'online')) {
								//will be send via cloud
								_notifies.push(k);
							}
							n();
						})
					}, function () {
						_sendToCloud();
					});
					return;
				}
				_sendToCloud();
				//send to cloud

			},
			getAllAfter: {
				byBranch: function (vars, cback) {
					db.db.get("SELECT DATE FROM TRANSACTIONS WHERE ID=?", [vars.id], function (e, d) {
						db.db.all("SELECT " + db.transactions._infoFields + " FROM TRANSACTIONS WHERE BRANCH=? AND DATE>? " +
							"ORDER BY DATE ASC", [vars.branch || d.BRANCH, d.date], cback);
					});
				},
				byRegister: function (vars, cback) {
					db.db.get("SELECT DATE FROM TRANSACTIONS WHERE ID=?", [vars.id], function (e, d) {
						db.db.all("SELECT " + db.transactions._infoFields + " FROM TRANSACTIONS WHERE BRANCH=? AND REGISTER=? " +
							"AND DATE>? ORDER BY DATE ASC", [vars.branch || d.BRANCH, vars.register || d.REGISTER, d.DATE], cback);
					});
				}
			},
			getData: function (id, cback) {
				db.db.get("SELECT DATA FROM TRANSACTIONS WHERE ID=?", [id], function (e, d) {
					if (d) d = JSON.parse(d);
					cback(e, d);
				});
			},
			getLatest: {
				byBranch: function (vars, cback) {
					db.db.get("SELECT " + db.transactions._infoFields + " FROM TRANSACTIONS WHERE BRANCH=? ORDER BY DATE DESC", [vars.branch], cback);
				},
				byRegister: function (vars, cback) {
					db.db.get("SELECT " + db.transactions._infoFields + " FROM TRANSACTIONS WHERE REGISTER=? ORDER BY DATE DESC", [vars.register], cback);
				}
			},
			queue: {
				_memQueue: {},//used when register is connected to skip read from db
				_processing: {},
				insert: function (id, fields, cback) {
					db.transactions.DB.openDB(id, function () {
						let _q = 'INSERT INTO TRANSACTIONS(ID,BRANCH,REGISTER,DATE,TYPE,TABLE_NAME,DATA) VALUES($ID,$BRANCH,$REGISTER,$DATE,$TYPE,$TABLE_NAME,$DATA)';
						db._dbs.transactions[id].db.run(_q, fields, function () {
							cback();
						})
					});
				},
				incoming: { //db.transactions.queue.incoming
					_pendingLoaded: false, //db.transactions.queue.incoming._pendingLoaded
					_queue: {},
					_processing: {},
					_isProcessing: function (t) {
						return db.transactions.queue.incoming._processing[t] && db.transactions.queue.incoming._processing[t] > new Date().getTime() - 1000 * 60 * 3;
					},
					add: function (vars, cback) {
						if (app.status == 'shutdown') return false;
						//check if exists,save to db and answer, call init
						db._dbs.transactions.MAIN.db.get("SELECT DATE, CASE DATA WHEN IS NULL THEN 0 ELSE 1 END HAS_DATA,DATE_RECEIVED," +
							"DATE_DATA_RECEIVED,DATE_PROCESSED FROM TRANSACTIONS WHERE ID=?", [vars.$ID], function (e, d) {
								if (!d || !d.DATE) {
									vars.$DATE_RECEIVED = new Date().toISOString();
									if (vars.$DATA) vars.$DATE_DATA_RECEIVED = '' + vars.$DATE_RECEIVED;
									//insert
									db.transactions.queue.incoming.save(vars, function (date_received) {
										cback({
											result: 'not_found',
											action: vars.$DATA ? 'saved' : 'send_data',
											data: {
												DATE_RECEIVED: vars.$DATE_RECEIVED
											}
										});
										if (vars.$DATA && db.transactions.queue.incoming._pendingLoaded) {
											//queue
											db.transactions.queue.incoming.init(vars);
										}
									});
									return;
								}
								if (d.HAS_DATA) {
									cback({
										result: 'found',
										action: d.DATE_PROCESSED ? 'processed' : 'processing',
										data: {
											DATE_RECEIVED: d.DATE_RECEIVED,
											DATE_DATA_RECEIVED: d.DATE_DATA_RECEIVED,
											DATE_PROCESSED: d.DATE_PROCESSED
										}
									});
									return;
								}
								//request data?

								//vars.$DATE_DATA_RECEIVED=new Date().toISOString();
								cback({
									result: 'found',
									action: 'send_data',
									data: {
										DATE_RECEIVED: d.DATE_RECEIVED
									}
								});
							});
					},
					saveData: function (vars) {
						db._dbs.transactions.MAIN.db.run('UPDATE TRANSACTIONS SET DATA=?,DATE_DATA_RECEIVED=? WHERE ID=?', _fields, function () {
							//send to process queue
						})
					},

					save: function (d, cback) {
						if (!d.$DATE_RECEIVED) d.$DATE_RECEIVED = new Date().toISOString();
						let _q = 'INSERT INTO TRANSACTIONS(ID,BRANCH,REGISTER,DATE,TYPE,TABLE_NAME' +
							(d.$DATA ? ',DATA,DATE_DATA_RECEIVED' : '') + ',DATE_RECEIVED) VALUES($ID,$BRANCH,$REGISTER,$DATE,$TYPE,$TABLE_NAME' +
							(d.$DATA ? ',$DATA,$DATE_DATA_RECEIVED' : '') + ',$DATE_RECEIVED)';
						db._dbs.transactions.MAIN.db.run(_q, d, function (err) {
							cback(d.$DATE_RECEIVED)
						});
					},
					loadPending: function () { //db.transactions.queue.incoming.loadPending
						db._dbs.transactions.MAIN.db.run("SELECT * FROM TRANSACTIONS WHERE REGISTER!=? AND DATE_PROCESSED IS NULL ORDER BY DATE ASC LIMIT 1000",
							[app.system.id], function (err, rows) {
								if (err) console.error(err.message);
								else if (rows && rows.length) {
									app._m.async.eachSeries(rows, function (r, n) {
										db.transactions.queue.incoming.init(r); n();
									}, function () {
										//done
									});
									return;
								}

							});
					},
					init: function (d) {
						if (app.status == 'shutdown') return false;
						//push to queue
						let t = d.$TABLE_NAME || d.TABLE_NAME;
						if (!db.transactions.queue.incoming._queue[t]) db.transactions.queue.incoming._queue[t] = [];
						db.transactions.queue.incoming._queue[t].push(d);
						if (db.transactions.queue.incoming._isProcessing(t)) return false;
						db.transactions.queue.incoming._loop(t);
					},
					_getData: function (t, cback) {
						if (t.$DATA || t.DATA) {
							cback();
							return;
						}
						db._dbs.transactions.MAIN.db.get("SELECT DATE, DATE_RECEIVED,DATE_DATA_RECEIVED,DATA FROM TRANSACTIONS WHERE ID=?", [t.$ID || t.ID], function (e, d) {
							if (!d || !d.DATA) {

								return;
							}
							t.$DATA = d.DATA;
							cback();
						});
					},
					_loop: function (t, done) {
						if (!db.transactions.queue.incoming._queue[t] || !db.transactions.queue.incoming._queue[t].length) {
							db.transactions.queue.incoming._processing[t] = false;
							if (done) done();
							return false;
						}
						db.transactions.queue.incoming._processing[t] = new Date().getTime();
						//save to transactions db, execute, update status, answer to sender


					}

				},
				cloudSync: {
					_isProcessing: function () {
						return db.transactions.queue.cloudSync._processing && db.transactions.queue.cloudSync._processing > new Date().getTime() - 1000 * 60 * 3;
					},
					init: function (done) {
						try {
							if (app.status == 'shutdown') return false;
							if (db.transactions.queue.cloudSync._isProcessing()) return false;
							db.transactions.queue.cloudSync = new Date().getTime();
							db._dbs.transactions.MAIN.db.all("SELECT ID FROM TRANSACTIONS WHERE DATE_CLOUD_RECEIVED IS NULL ORDER BY DATE ASC LIMIT 20", [], function (er, rows) {
								if (er) console.error(er.message)
								if (rows && rows.length) {

								}

							});
						} catch (e) { console.warn('[WIP] Error while starting transactions.queue.cloudSync') }
					},
					_loop: function (done) {

					}
				},
				outgoing: {
					_isProcessing: function (id) {
						return db.transactions.processMissingFromReg._processing[id] && db.transactions.processMissingFromReg._processing[id] > new Date().getTime() - 1000 * 60 * 3;
					},
					init: function (id, done) {
						try {
							if (app.status == 'shutdown') return false;
							if (db.transactions.processMissingFromReg._isProcessing(id)) return false;
							db.transactions.processMissingFromReg._processing[id] = new Date().getTime();
						} catch (e) { console.warn('[WIP] Error while starting transactions.processOutgoing') }
					},
					_loop: function (id, done) {

					}

				}
			}
		},
		manage: {
			backup: function () {
				//function assertRowsMatchDb(db1, table1, db2, table2, done) {
				//	db1.get("SELECT COUNT(*) as count FROM " + table1, function(err, row) {
				//		if (err) throw err;
				//		db2.get("SELECT COUNT(*) as count FROM " + table2, function(err, row2) {
				//			if (err) throw err;
				//			assert.equal(row.count, row2.count);
				//			done();
				//		});
				//	});
				//}
				//
				//// Check that the number of rows in the table "foo" is preserved in a backup.
				//function assertRowsMatchFile(db, backupName, done) {
				//	var db2 = new sqlite3.Database(backupName, sqlite3.OPEN_READONLY, function(err) {
				//		if (err) throw err;
				//		assertRowsMatchDb(db, 'foo', db2, 'foo', function() {
				//			db2.close(done);
				//		});
				//	});
				//}
				//it ('output db created once step is called', function(done) {
				//	var backup = db.backup('test/tmp/backup.db', function(err) {
				//		if (err) throw err;
				//		backup.step(1, function(err) {
				//			if (err) throw err;
				//			assert.fileExists('test/tmp/backup.db');
				//			backup.finish(done);
				//		});
				//	});
				//});
				//it ('copies source fully with step(-1)', function(done) {
				//	var backup = db.backup('test/tmp/backup.db');
				//	backup.step(-1, function(err) {
				//		if (err) throw err;
				//		assert.fileExists('test/tmp/backup.db');
				//		backup.finish(function(err) {
				//			if (err) throw err;
				//			assertRowsMatchFile(db, 'test/tmp/backup.db', done);
				//		});
				//	});
				//});
			},
			close: function () {
				//save and close
				db._dbs.primary.default.status = 'closing';
				if (db._dbs.primary.default.db) db._dbs.primary.default.db.close(function () {
					db._dbs.primary.default.status = 'closed';
				});
				let _k = Object.keys(db._dbs.transactions)
				if (_k && _k.length) {
					for (let i = 0; i < _k.length; i++) {
						if (db._dbs.transactions[_k[i]].db) {
							db._dbs.transactions[_k[i]].status = 'closing';
							try {
								db._dbs.transactions[_k[i]].db.close(function () {
									db._dbs.transactions[_k[i]].status = 'closed';
								});
							} catch (er) {
								console.error('Cant close db ' + _k[i], er.message);
							}
						}
					}

				}
			},
			checkForUpdates: function (_db, cback) {
				_db.db.get("SELECT ID FROM VERSION", function (err, res) {
					if (err) {
						console.error(_db.type, err);
						let errtxt = err.toString();
						if (errtxt.indexOf('no such table: VERSION') != -1) {
							db.manage.initDatabaseFile(_db, cback);
							return;
						}
						if (errtxt.indexOf('SQLITE_NOTADB') != -1) {
							if (app._m.fs.existsSync(app.cacheDir + _db.file)) {
								_db.db.close(function () {
									app._m.fs.unlinkSync(app.cacheDir + _db.file);
									db.manage.openDB(_db, cback);
								})
								return;
							}
							db.manage.initDatabaseFile(_db, cback);
							return;
						}
					}
					else {
						_db.status = 'ready';
						//we have version res[0].ID?

						console.log('db "' + _db.type + '" is ready', res)
						_db._version = 1 * res.ID;
						//get updates

						app._m.fs.readdir(__dirname + '/db_updates/' + _db.type + '/', (err, files) => {
							if (files && files.length) {
								files = files.filter(function (a) {
									if (a.indexOf('.sql') == -1) return false;
									a = parseInt(a.split('.')[0]);
									return a > res.ID;
								}).sort(function (a, b) {
									return a < b ? -1 : 1;
								});
								if (files && files.length) {
									try {
										if (_db.type == 'primary') {
											app.splashscreen.win.window.setProgress(87);
											app.splashscreen.setMessage('database_updates', app.parseLocales('splash.startup_steps.database_updates'));
										}
									} catch (er) {

									}
									//console.log('doing updates....')
									app._m.async.eachSeries(files, function (f, n) {
										if (('' + f).indexOf('.sql') != -1) f = f.split('.')[0];
										app._m.fs.readFile(__dirname + '/db_updates/' + _db.type + '/' + f + '.sql', function (err, file) {
											if (err) console.error('db_updates/' + _db.type + '/' + f + '.sql', err.message)
											if (file) {
												_db.db.exec(file.toString() + '\nUPDATE VERSION SET ID=' + f + ';', function (er) {
													if (er) console.error('db_updates/' + _db.type + '/' + f + '.sql', er.message)
													else _db._version = 1 * f;
													n();
												});
												return;
											}
											n();
										})
									}, function () {
										//console.log('updates done')
										if (cback) cback();
										app.splashscreen.unsetMessage('database_updates');
									});
									return;
								}
							}
							if (cback) cback();

						});
					}
				})

			},
			initDatabaseFile: function (_db, cback) {
				console.info('DB "' + _db.type + '" IS BRAND NEW, IMPORT DEFAULT')
				_db.db.exec(app._m.fs.readFileSync(__dirname + '/' + _db.type + '.default').toString(), function (er) {
					if (er) console.error('CANNOT CREATE LOCAL "' + _db.type + '" DATABASE', er.message);
					else {
						db.manage.checkForUpdates(_db, cback)
					}
				});
			},
			openDB: function (_db, cback) {
				if (!dps) dps = pos._cfg.branch.id + '_' + app.system.id + '_' + dbps;
				let exists = false;
				//splashscreen init database
				if (_db.type == 'primary') {
					_db.file = app.system.id + '.pdf';
				}
				try {
					if (_db.type == 'primary') {
						app.splashscreen.win.window.setProgress(85);
						app.splashscreen.setMessage('initialize_database', app.parseLocales('splash.startup_steps.initialize_database'), 1000 * 5);
					}
				} catch (er) {

				}
				if (app._m.fs.existsSync(app.cacheDir + _db.file)) exists = true;
				_db.db = new sqlite3.Database(app.cacheDir + _db.file);
				if (!db._dbs[_db.type]) db._dbs[_db.type] = {};
				db._dbs[_db.type][_db.id || 'default'] = _db;
				_db.db.on('open', function () {
					_db.db.serialize(function () {
						_db.db.run("PRAGMA cipher_compatibility = 4");
						_db.db.run("PRAGMA key = '" + dps + "'");
						//if local file exists, open. otherwise request from another register
						console.log('connected to local db ' + _db.type + (_db.id ? '.' + _db.id : ''))
						let _done = function () {
							console.log('local db ' + _db.type + (_db.id ? '.' + _db.id : '') + ' is now loaded')
							if (cback) cback();
						};
						if (!exists) {
							db.manage.initDatabaseFile(_db, _done);
							return;
						}
						try {
							db.manage.checkForUpdates(_db, _done)
						} catch (er) {
							console.error('creating ' + _db.type + (_db.id ? '.' + _db.id : ''), er.message)
						}
						//copy existing DB to tmpdir and decrypt it
						//open, save at interval
						//app._m.fs.copy(app.cacheDir + 'readme.pdf',__dirname + '/db.run', function (er) {
						//	if (er) {
						//		console.error('CANNOT CREATE LOCAL DATABASE', er.message);
						//		return;
						//	}
						//	sqlite.connect(__dirname + '/db.run',app.system.id+'_'+dbpas,'aes-256-ctr');
						//});
					});
				});
				if (_db.type == 'primary' && !app.pathExists(db._dbs, 'transactions.MAIN')) {
					db.transactions.DB.openDB('MAIN', function () {
						console.log('TRANSACTIONS DB IS LIVE!');
						db.transactions.queue.incoming.loadPending();
					});
				}
			}
		}
	};
module.exports = {
	status: function () {
		let out = {};
		for (let k of Object.keys(db._dbs)) {
			for (let y of Object.keys(db._dbs[k])) {
				if (!out[k]) out[k] = {};
				out[k][y] = { version: db._dbs[k][y]._version, status: db._dbs[k][y].status };
			}
		}
		return out;
	},
	init: db.init,
	routeEvent: function (d) {
		switch (d.action) {
			case 'newTransaction':
				db.transactions.queue.incoming.add(d.data, function (addRes) {
					d.cback(addRes);
				})
				break;
			case 'transactionData':
				db.transactions.queue.incoming.saveData(d.data, function (saveRes) {
					d.cback(saveRes);
				})
				break;
			case 'debugGetAll':
				db._dbs.transactions[d.data.db].db.all('SELECT * FROM TRANSACTIONS ORDER BY DATE ASC', [], d.cback);
				break;
		}
	},
	open: db.manage.openDB,
	query: db.query,
	all: db.all,
	get: db.get,
	each: db.each,
	close: db.manage.close,
	transactions: {
		processOutgoing: db.transactions.queue.outgoing.init
	}
};