//var _QRCode = require('easyqrcodejs-nodejs');
_qr = {
    encode: function (d, cback) {
        //console.log('Encoding', d)
        if (!d.format) d.format = 'PNG';
        d.format = d.format.toUpperCase();
        if (d.data) {
            d.text = 'TPOS:' + Buffer.from(JSON.stringify(d.data)).toString('base64')
        }
        let _saveToFile = d.saveToFile, _toBuffer = 0;
        delete d.saveToFile;
        if (_saveToFile && /\.svg$/.test(_saveToFile.toLowerCase()))
            d.toSVG = true;
        if (d.toSVG || d.toBuffer) {
            delete d.toBuffer;
            _toBuffer = 1;
        }
        if (d.toSVG) d.drawer = 'svg';
        let _gotData = function (data) {
            //console.log('GOT DATA', data)
            let _buffer = data.indexOf('<svg ') === 0 ? data : Buffer.from(data.split('base64,').pop(), 'base64');
            if (_toBuffer)
                data = _buffer;

            if (_saveToFile) app._m.fs.writeFileSync(_saveToFile, _buffer);
            cback(data);

        };
        if (app.pathExists(app.pos, 'win.window.APPFCTS.qrCode.encode')) {
            try {
                //console.log('Get from pos')
                app.pos.win.window.APPFCTS.qrCode.encode(d, _gotData)
                return;
            } catch (er) { }
        }
        if (app.pathExists(app.pos, 'production.workstation.win.window.APPFCTS.qrCode.encode')) {
            try {
                //console.log('Get from workstation')
                app.pos.production.workstation.win.window.APPFCTS.qrCode.encode(d, _gotData)
                return;
            } catch (er) { }
        }
        //console.log('GET FROM WEUBBE')
        app.web.emit({
            module: 'core',
            action: 'qr.encode',
            datas: d
        }, _gotData);

        return;
        d.correctLevel = _QRCode.CorrectLevel[d.level || 'H'];
        d.drawer = 'svg';
        let _q = new _QRCode(d);
        if (d.toSVG) {
            _q.toSVGText().then(data => {
                cback(data);
            })
            return _q;
        }
        if (d.saveToFile) {
            _q[/\.svg$/.test(d.saveToFile.toLowerCase()) ? 'saveSVG' : 'saveImage']({
                path: d.saveToFile
            }).then(data => {
                if (cback) cback(data);
            })
            return _q;
        }
        if (cback)
            _q.toDataURL().then(data => {
                if (d.toBuffer)
                    data = Buffer.from(data.split(';').pop(), 'base64');
                cback(data);
            })
        return _q;
    },
    decode: function (data) {
        if (data && data.indexOf('TPOS:') === 0) {
            json = JSON.parse(Buffer.from(data.replace(/^TPOS\:/, ''), 'base64').toString());
            return json;
        }
        return data;
    }
};
module.exports = _qr;