var self,serial = {
	cfg		: {},
	reader	: null,
	reading	: false,
	_data	: '',
	_init: function (vars, parent) {
		self = this;
		self.parent = parent;
		self.cfg = vars;
		serial.reader = app._m.spawn('cat',[self.cfg.com]);
		serial.reader.stdout.on('data',serial.read);
		serial.reader.stderr.on('data',console.error);
		serial.reader.on('error',console.error);
		serial.reader.on('exit',function(){console.log('ended');});
	},
	read:function(data){
		data = data.toString();
		if((stx = data.indexOf('\x02')) != -1){
			if((etx = data.indexOf('\x03')) != -1){
				serial._data = data.substring(stx+1,etx);
			}else{
				serial._data = data.substring(stx+1);
				serial.reading = true;
			}
		}else if(serial.reading){
			if((etx = data.indexOf('\x03')) != -1){
				serial._data += data.substring(0,etx);
				serial.reading = false;
			}else{
				serial._data += data;
			}
		}

		if(serial._data.length && !serial.reading){
			var _data = serial._data;
			serial._data = '';
			serial.parent.read(_data);
		}
	},
	write:function(data){
		console.log('LC out',data)
		app._m.exec('printf "'+data+'" > '+self.cfg.com,console.log,console.log);
	}
};

module.exports = serial;
return;
///const SerialPort = require('serialport');
var serial = {
	cfg		: {},
	port	: null,
	_init: function (vars, parent) {
		var self = this;
		self.eft = parent;
		console.log('LC',SerialPort)
		return
		serial.port = new SerialPort('/dev/ttyUSB0', {
			baudRate: 2400
		});
		console.log('LC initialized');
		serial.cfg = vars;
		serial.port.on('data', serial.receive);
		serial.port.on('end', () => {});
		serial.port.on('error', (err) => {
			var oCode = err.errno;
			switch (oCode) {
				case 'EALREADY':
				case 'EHOSTUNREACH':
					code = 'UNREACH';
					break;
				case 'ECONNREFUSED':
					code = 'REFUSED';
					break;
				case 'ECONNRESET':
				case 'ERR_STREAM_WRITE_AFTER_END':
					////ip.disconnect();
					code = 'UNKNOWN';
					break;
				case 'EPIPE':
				case 'ENOTCONN':
					//ip.connected = false;
					code = 'UNKNOWN';
					break;
				default:
					code = 'UNKNOWN';
					console.warn('Unhandled error', oCode, err.code);
					break;
			}
			if (typeof self.eft.cback == 'function') {
				self.eft.cback({
					status: 'error',
					code: code
				});
			}
			setTimeout(function () { self.eft._busy = false; }, 1000);
			////ip.socket.end();
		});
	},
	receive: function (data) {
		if (serial.eft.cfg.prependLength)
			data = data.substr(2);
		////serial.eft.receive(data);
		console.log('LC',data)
		serial.send('\x06');
	},
	send: function (message) {
		if (serial.eft.cfg.prependLength)
			message = (String.fromCharCode(message.length >> 8)) + (message.length > 255 ? '\xff' : String.fromCharCode(message.length % 256)) + message;
		serial.port.write(message);
	}

};
module.exports = serial;