// Generated by CoffeeScript 1.9.3
(function () {
	var ResumableRequest, cloneResponse, extend, stream, throttle,
		bind = function (fn, me) { return function () { return fn.apply(me, arguments); }; },
		extend1 = function (child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
		hasProp = {}.hasOwnProperty;

	stream = require('readable-stream');

	throttle = require('throttleit');

	extend = require(__dirname + '/cloneextend.js');

	module.exports = function (requestModule, requestOpts, opts) {
		return new ResumableRequest(requestModule, requestOpts, opts);
	};

	module.exports.defaults = function (defaults) {
		if (defaults == null) {
			defaults = {};
		}
		return function (requestModule, requestOpts, opts) {
			opts = extend.extend(extend.extend({}, defaults), opts);
			return new ResumableRequest(requestModule, requestOpts, opts);
		};
	};

	cloneResponse = function (response) {
		var s;
		s = new stream.PassThrough();
		['headers', 'httpVersion', 'method', 'rawHeaders', 'statusCode', 'statusMessage'].forEach(function (prop) {
			return s[prop] = response[prop];
		});
		return s;
	};

	ResumableRequest = (function (superClass) {
		extend1(ResumableRequest, superClass);

		function ResumableRequest(requestModule1, requestOpts1, opts) {
			var ref, ref1, ref2, retryNow;
			this.requestModule = requestModule1;
			this.requestOpts = requestOpts1;
			if (opts == null) {
				opts = {};
			}
			this._reportProgress = bind(this._reportProgress, this);
			this.push = bind(this.push, this);
			ResumableRequest.__super__.constructor.call(this);
			this.error = null;
			this.request = null;
			this.response = null;
			this.timeRemaining = null;
			this.destinations = [];
			this.bytesRead = 0;
			this.startedAt = new Date().getTime();
			this.xferSpeed = null;
			this.bytesTotal = null;
			this.retries = 0;
			this.maxRetries = (ref = opts.maxRetries) != null ? ref : 10;
			this.progressOptions = extend.extend({
				throttle: 1000,                    // Throttle the progress event to 2000ms, defaults to 1000ms
				delay: 0,                       // Only start to emit after 1000ms delay, defaults to 0ms
				// lengthHeader: 'x-transfer-length'  // Length header to use, defaults to content-length
			}, opts.progressOptions || {});

			retryNow = this._retry.bind(this);
			this._retry = throttle(retryNow, this.progressOptions.throttle, {
				leading: false
			});
			this._reportProgress = throttle(this._reportProgress.bind(this), this.progressOptions.throttle, {
				leading: false
			});
			this.on('pipe', (function (_this) {
				return function () {
					_this.error = new Error('ResumableRequest is not writable');
					return process.nextTick(retryNow);
				};
			})(this));
			//this.delayTimer && clearTimeout(this.delayTimer);
			this.delayTimer = null;
			this._request();
		}

		ResumableRequest.prototype.abort = function () {
			this.emit('abort');
			return this.destroy(this.error);
		};

		ResumableRequest.prototype.push = function (data, encoding) {
			this.retries = 0;
			if (data != null) {
				this.bytesRead += data.length;
			}
			this._reportProgress();
			this.emit('data', data);
			return this.response.write(data, encoding);
		};

		ResumableRequest.prototype.pipe = function (dest, opts) {
			if (this.response != null) {
				return this.response.pipe(dest, opts);
			}
			this.destinations.push([dest, opts]);
			return dest;
		};

		ResumableRequest.prototype._destroy = function (err, cb) {
			var ref;
			if (this.ended) {
				return cb ? cb(err) : err;
			}
			this.ended = true;
			if (err) {
				this.request.abort();
			} else {
				this.request.destroy();
			}
			if ((ref = this.response) != null) {
				ref.end();
			}
			//this._retry.cancel();
			try {
				this._reportProgress();
				this._reportProgress.flush();
				this._reportProgress.cancel();
			} catch (er) { }
			if (cb) cb(err);
			return process.nextTick((function (_this) {
				return function () {
					if (!err) {
						_this.hasCompleted = true;
						_this.emit('complete');
						return;
					}
					return _this.emit('error', err);
				};
			})(this));
		};

		ResumableRequest.prototype._read = function () { };

		ResumableRequest.prototype.progress = function () {
			let state = {
				retries: this.retries,
				maxRetries: this.maxRetries,
				percentage: Math.round(100 * this.bytesRead / this.bytesTotal) || 0,
				size: {
					transferred: this.bytesRead,
					total: this.bytesTotal
				},
				time: {
					elapsed: (new Date().getTime() - this.startedAt) / 1000,
					remaining: this.bytesRead > 0 ? this.timeRemaining : null
				},
				speed: 0
			};
			// Calculate speed only if 1s has passed
			if (state.time.elapsed > 0 && this.bytesRead > 0) {
				state.speed = state.size.transferred / state.time.elapsed;
			}

			// Calculate percent & remaining only if we know the total size
			if (state.size.total) {
				//state.percent = Math.min(state.size.transferred, state.size.total) / state.size.total;

				if (state.speed != null) {
					state.time.remaining = state.percentage !== 1 ? (state.size.total / state.speed) - state.time.elapsed : 0;
					state.time.remaining = Math.round(state.time.remaining * 1000) / 1000;  // Round to 4 decimals
				}
			}
			return state;
		};

		ResumableRequest.prototype._reportProgress = function (progress) {
			if (this.delayTimer && this.hasCompleted) return;
			if (progress == null) {
				progress = {};
			}
			return this.emit('progress', Object.assign(this.progress(), progress));
		};

		ResumableRequest.prototype._request = function () {
			var base, failed, initial;
			if (this.response != null) {
				if ((base = this.requestOpts).headers == null) {
					base.headers = {};
				}
				this.requestOpts.headers.range = "bytes=" + this.bytesRead + "-";
			}
			initial = this.request === null;
			failed = false;
			return this.request = this.requestModule(this.requestOpts).once('request', (function (_this) {
				return function (reqObj) {
					if (initial) {
						return _this.emit('request', reqObj);
					}
				};
			})(this)).once('response', (function (_this) {
				return function (response) {
					_this._follow(response);
					if (response.statusCode >= 400) {
						_this.error = new Error("Request failed with status code " + response.statusCode);
						return _this._retry();
					}

					if (this.progressOptions && this.progressOptions.delay)
						this.delayTimer = setTimeout(function () {
							this.delayTimer = null;
						}, this.progressOptions.delay);
				};
			})(this)).on('error', (function (_this) {
				return function (err) {
					failed = true;
					_this.emit('socketError', err);
					return _this._retry();
				};
			})(this)).once('complete', (function (_this) {
				return function () {
					if (failed) {
						return;
					}
					if ((_this.bytesTotal != null) && _this.bytesRead < _this.bytesTotal) {
						return _this._retry();
					} else {
						return _this._destroy();
					}
				};
			})(this));
		};

		ResumableRequest.prototype._follow = function (response) {
			var onData, onEnd;
			if (this.response == null) {
				if (this.bytesTotal == null) {
					this.bytesTotal = parseInt(response.headers['content-length']);
				}
				this._reportProgress();
				//this._reportProgress.flush();
				this.response = cloneResponse(response);
				this.destinations.forEach((function (_this) {
					return function (arg) {
						var dest, opts;
						dest = arg[0], opts = arg[1];
						return _this.response.pipe(dest, opts);
					};
				})(this));
				this.destinations = [];
				this.emit('response', this.response);
			}
			onData = this.push;
			onEnd = function () {
				response.removeListener('data', onData);
				response.removeListener('error', onEnd);
				return response.removeListener('end', onEnd);
			};
			return response.on('data', onData).once('error', onEnd).once('end', onEnd);
		};

		ResumableRequest.prototype._retry = function () {
			var ref;
			if (this.ended) {
				return;
			}
			if (this.error != null) {

			} else if ((this.response != null) && !this.bytesTotal) {
				this.error = new Error('Cannot resume without Content-Length response header');
			} else if ((this.response != null) && ((ref = this.response.headers['accept-ranges']) != null ? ref.toLowerCase() : void 0) !== 'bytes') {
				this.error = new Error('Server does not support Byte Serving');
			} else if (this.bytesTotal && this.bytesRead > this.bytesTotal) {
				this.error = new Error('Received more bytes than expected!');
			} else if (this.retries >= this.maxRetries) {
				this.error = new Error('Maximum retries exceeded');
			} else {
				this.retries += 1;
				this.emit('retry', this.progress());
				this._request();
				return;
			}
			return this.abort();
		};

		return ResumableRequest;

	})(stream.Readable);

}).call(this);
