// sloppy traceroute clone
// inpired by https://blogs.oracle.com/ksplice/entry/learning_by_doing_writing_your
// and made possible by https://www.npmjs.org/package/raw-socket

var
	raw = require('raw-socket'),
	dns = require('dns'),
	_resolveFirst = async (dest) => {
		return new Promise(async (resolve) => {
			dns.resolve(dest, function (err, addresses) {
				if (err) throw err;
				dns.reverse(addresses[0], function (err, domains) {
					if (err) {
						resolve({ address: addresses[0] });
					} else {
						resolve({ address: addresses[0], domains });
					}
				});
			});
		});
	},
	T = class Traceroute {
		constructor({ target, maxHops, ttl }) {
			this.TIME_LIMIT = ttl || 5000;
			this.MAX_HOPS = maxHops || 30;
			this.hops = [];
			return new Promise(async (resolve) => {
				_resolveFirst(target, async (address, domains) => {
					console.log('Traceroute to', address, domains);
					await this.trace(address, 1);
					resolve({ destination: address, hops: this.hops });
				});
			});
		}
		async ping(dest, ttl) {
			return new Promise(async (resolve) => {
				var sentTime;
				var buffer = new Buffer([
					0x08, 0x00, 0x43, 0x52, 0x00, 0x01, 0x0a, 0x09,
					0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
					0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
					0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x61,
					0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69]);

				var socketLevel = raw.SocketLevel.IPPROTO_IP
				var socketOption = raw.SocketOption.IP_TTL;

				var socket = raw.createSocket();
				socket.setOption(socketLevel, socketOption, ttl);
				socket.send(buffer, 0, buffer.length, dest, function (err, bytes) {
					if (err) throw err;
					sentTime = new Date().getTime();
				});

				var timeout = false, _timer = null;

				socket.on("message", function (buffer, source) {
					socket.close();
					if (timeout) return false;
					clearTimeout(_timer);
					resolve({ buffer, source, time: (new Date().getTime() - sentTime) });
				});

				_timer = setTimeout(function () {
					timeout = true; resolve({ buffer: null, source: null, time: this.TIME_LIMIT });
				}, this.TIME_LIMIT);
			});
		}
		async trace(dest, ttl) {
			return new Promise(async (resolve) => {
				let { buffer, source, time } = await this.ping(dest, ttl);
				if (time <= this.TIME_LIMIT && source) {
					let { address, domains } = await _resolveFirst(source);
					this.hops.push({ hop: ttl, address: address, time: time });
					console.log(ttl + '\t' + address + '\t' + domains + '\t' + time + 'ms');
					if (source == dest || ttl == this.MAX_HOPS) return resolve();//process.exit(0);
					this.trace(dest, ttl + 1);
				} else {
					console.log(ttl + '\t' + source);
					this.hops.push({ hop: ttl, address: source, time: time });
					if (source == dest || ttl == this.MAX_HOPS) return resolve();//process.exit(0);
					this.trace(dest, ttl + 1);
				}
			});
		}
	};
module.exports = T;

