var app, pos, _win, _isOpen = false, CD = {
	init: function (parent, cback) {
		pos = parent;
		app = pos.app;
		if (cback) cback();
	},
	routeEvent: function (d) {
		console.log('customerdisplay', d)

	},
	routeGUIaction: (d, cback) => {
		switch (d.action) {
			case 'open':
				CD.open();
				break;
			case 'update':
				CD.update();
				break;
		}
		if (cback) cback()
	},
	close: () => {
		_win.close();
	},
	open: () => {
		//_windows.customer_display

		// Get screens
		let screens = app.utilities.screens;
		if (screens.length < 2) {
			app.pos.win.window.alert("You don't have enough screens to open the customer facing display.");
			return false;
		}
		if (_win) {
			_win.show();
			_isOpen = true;
			return true;
		}
		if (_isOpen) {
			return true;
		}

		// Open window in screen #2
		nw.Window.open(pos.url + 'index.php/sales/customer_display', {}, function (win) {
			win.moveTo(screens[1].bounds.x, screens[1].bounds.y);
			win.enterKioskMode();
			try { app.pos.win.focus(); } catch (er) { }
			_win = win;
			_isOpen = true;
			win.on('close', function () {
				if (!_isOpen) return;
				_isOpen = false;
				console.log("Customer Facing Display : Closed");
				_win.close();
			});
			console.log("Customer Facing Display : Opened");
		});
		return true;
	},
	update: () => {
		_win.window.customer_display_update();
	}
};
module.exports = CD;