var app, zip_in, lin = {
	init: function (_app) {
		app = _app;
		lin.file = app.pathExists(app, 'package.packages.linux64.hash');
		if (lin.file) {
			zip_in = '' + app.baseDir + '/updates/' + lin.file + '.zip';
			if (app._m.fs.existsSync(zip_in)) {
				lin.update();
				return;
			}
		}
		app.win.window.throwalert('Update file not found.');
		console.error('FILE NOT FOUND', lin.file, zip_in)
		//app.exit(1);
	},
	kill: function (force, cback) {
		let PID = null;
		if (app._m.fs.existsSync(app.baseDir + 'AzimutPOS.pid'))
			PID = app._m.fs.readFileSync(app.baseDir + 'AzimutPOS.pid').toString().trim();

		if (!PID) {
			let _l = 'ps aux | grep /AzimutPOS | grep -v grep | grep -v updater | head -n 1 | awk -F " " \'{print $2}\'';
			app._m.exec(_l, function (err, stdout) {
				if (stdout) {
					let PID = stdout.trim();

					if (PID) {
						console.log("kill (from grep) " + (force ? '-9 ' : '') + PID)
						app._m.exec("kill " + (force ? '-9 ' : '') + PID, function () {
							cback();
						});
						return;
					}
				}
				console.warn(_l, 'NO RESULT')
				cback();
			})
			return;
		}
		console.log("kill " + (force ? '-9 ' : '') + PID)
		app._m.exec("kill " + (force ? '-9 ' : '') + PID, function () {
			cback();
		});
	},
	update: function () {
		app.win.window.setProgress(10);
		lin.kill(0, function () {
			app.win.window.setProgress(40);
			app.win.window.setMessage(app.parseLocales('steps.extract'));
			let
				_args = [__dirname + '/scripts/unzip.sh', app.baseDir, '' + lin.file + '.zip'],
				szip;
			szip = app._m.spawn('bash',
				_args);
			szip.stdout.on('data', (data) => {
				console.log('UNZIP', data.toString());
			});

			szip.stderr.on('data', (data) => {
				console.log('UNZIP stderr', data.toString());
			});

			szip.on('exit', (code) => {
				console.log(`szip exited with code ${code}`);
				if (code == 0) {
					app.win.window.setProgress(90);
					//spawn app
					lin.kill(1, function () {
						console.log('Starting "' + app.baseDir + 'AzimutPOS"')
						var child = app._m.spawn(app.baseDir + 'AzimutPOS', [], { detached: true });
						child.unref();
						child.stdout.on('data', (data) => {
							console.log('child', data.toString());
						});

						child.stderr.on('data', (data) => {
							console.log('child stderr', data.toString());
						});

						setTimeout(function () {
							app.win.window.setMessage(app.parseLocales('steps.startApp'));
							app.win.window.setProgress(100);
						}, 2000);
						setTimeout(function () {
							console.log('UPDATER DONE.')
							app.exit(0);
						}, 1000 * 10);
					});
				}
			});
		});
	}
};
module.exports = lin;