var
	_core, _queuesFcts = {},
	queueProc = {
		_queues: {},
		_init: function (core, cback) {
			_core = core;
			if (cback) cback();
		},
		test: function () {
			var todo = 20, done = 0;
			queueProc.init('queueProcTEST', 3);
			var _fct = function (d, n) {
				done++;
				console.log(d);
				setTimeout(n, 500);
				if (done >= todo) {
					console.log('all done!')
				}
			};
			for (var i = 0; i < todo; i++) {
				queueProc.add('queueProcTEST', 'I am number ' + i, _fct);
			}
			setTimeout(function () {
				for (var i = 0; i < todo; i++) {
					queueProc.add('queueProcTEST', 'I am number ' + (todo + i), _fct);
				}
			}, 1000);
		},
		init: function (id, maxChan, dispose) {
			if (!queueProc._queues[id]) {
				queueProc._queues[id] = {
					processing: false,
					queue: [],
					channels: [],
					maxChan: maxChan || 1,
					onEmpty: [],
					disposeAfter: dispose || 0
				};
				_queuesFcts[id] = {
					add: function (data, fct) {
						queueProc.add(id, data, fct);
						//console.log('Queue',id,'has',queueProc._queues[id].queue.length,'items')
						return _queuesFcts[id];
					},
					clear: function () {
						queueProc._queues[id].queue = [];
						queueProc._queues[id].channels = [];
						queueProc._queues[id].processing = false;
						return _queuesFcts[id];
					},
					setMaxChan: function (maxChan) {
						queueProc.setMaxChan(id, maxChan);
						return _queuesFcts[id];
					},
					onQueueEmpty: function (fct) {
						queueProc.onQueueEmpty(id, fct);
						return _queuesFcts[id];
					},
					dispose: function (fct) {
						delete queueProc._queues[id];
						return _queuesFcts[id];
					}
				};
			}
			return _queuesFcts[id];
		},
		setMaxChan: function (id, maxChan) {
			if (!queueProc._queues[id]) return false;
			queueProc._queues[id].maxChan = maxChan || 1;
		},
		add: function (qid, data, fct) {
			var parent = _core.getParentStack();
			if (Array.isArray(data)) {
				for (var i = 0; i < data.length; i++)
					queueProc._queues[qid].queue.push({ fct: fct, data: data[i], parent: parent });
			}
			else
				queueProc._queues[qid].queue.push({ fct: fct, data: data, parent: parent });
			queueProc._process(qid);
		},
		onQueueEmpty: function (id, cback) {
			if (!queueProc._queues[id].onEmpty) queueProc._queues[id].onEmpty = [];
			queueProc._queues[id].onEmpty.push(cback);
		},
		_runQueueEmpty: function (id) {
			if (queueProc._queues[id]?.onEmpty && queueProc._queues[id].onEmpty.length) {
				if (_core.tryCatch(function () {
					queueProc._queues[id].onEmpty[0]();
				})) {
					console.warn('Queue ID ' + qid);
				}
				queueProc._queues[id].onEmpty.shift();
				process.nextTick(function () {
					queueProc._runQueueEmpty(id);
				});
				return;
			}

			if (queueProc._queues[id].disposeAfter) {
				clearTimeout(queueProc._queues[id].disposeTimer);
				queueProc._queues[id].disposeTimer = setTimeout(function () { delete queueProc._queues[id]; }, 1000 * queueProc._queues[id].disposeAfter);
			}
		},
		_process: function (qid) {
			if (queueProc._queues[qid].processing)
				return;
			queueProc._queues[qid].processing = true;
			if (typeof process != 'undefined') process.nextTick(function () { queueProc._doProcess(qid); });
			else setTimeout(function () { queueProc._doProcess(qid); }, 1);
		},
		_doChannel: function (qid, x, f) {
			if (_core.tryCatch(function () {
				let _cbacked = false;
				f.fct(f.data, function () {
					if (_cbacked) {
						console.warn('Queue', qid, 'callback already called', f.data, f.parent)
						return false;
					}
					_cbacked = true;
					//console.log(''+qid+', ended channel #',x)
					queueProc._queues[qid].channels[x] = null;
					//console.log('Queue',qid,'has',queueProc._queues[qid].queue.length,'items')
					if (typeof process != 'undefined') process.nextTick(function () { queueProc._doProcess(qid); });
					else setTimeout(function () { queueProc._doProcess(qid); }, 1);
				})
			})) {
				console.warn(_f.parent);
				//console.log('ERROR ON '+qid+', CHANNEL #'+x);
				queueProc._queues[qid].channels[x] = null;
				if (typeof process != 'undefined') process.nextTick(function () { queueProc._doProcess(qid); });
				else setTimeout(function () { queueProc._doProcess(qid); }, 1);
			}
		},
		_doProcess: function (qid) {
			if (!queueProc._queues[qid]) return;
			clearTimeout(queueProc._queues[qid].disposeTimer);
			if (!queueProc._queues[qid].queue.length) {
				if (!Object.keys(queueProc._queues[qid].channels).filter(function (a) { return queueProc._queues[qid].channels[a]; }).length) {
					process.nextTick(function () {
						if (!queueProc._queues[qid].queue.length && !Object.keys(queueProc._queues[qid].channels).filter(function (a) { return queueProc._queues[qid].channels[a]; }).length) {
							queueProc._queues[qid].processing = false;
							queueProc._runQueueEmpty(qid);
						}
					});
				}
				return;
			}
			var _f = queueProc._queues[qid].queue[0];
			for (var i = 0; i < queueProc._queues[qid].maxChan; i++) {
				if (!queueProc._queues[qid].channels[i]) {
					//console.log(''+qid+', started channel #',i)
					//queueProc._queues[qid].totalChans++;
					queueProc._queues[qid].channels[i] = true;
					queueProc._doChannel(qid, i, _f);
					queueProc._queues[qid].queue.shift();
					if (typeof process != 'undefined') process.nextTick(function () { queueProc._doProcess(qid); });
					else setTimeout(function () { queueProc._doProcess(qid); }, 1);
					return;
				}
			}
		}
	};
module.exports = queueProc;