@echo off
setlocal
SET mypath=%~dp0
SET mypath=%mypath:~0,-1%

set arg2=%1
CALL SET "scripts=%%mypath:\update=%%"
CALL SET "azimutpos=%%mypath:\etc\scripts\update=%%"

cd "%azimutpos%"
set SESSIONNAME=AzimutUpdate
rem Instance Set
set instance=%SESSIONNAME% %DATE% %TIME% %RANDOM%
%SAY% "Instance: %instance%"
title %instance%
for /f "usebackq tokens=2" %%a in (`tasklist /FO list /FI "SESSIONNAME eq %SESSIONNAME%" /FI "WINDOWTITLE eq %instance%" ^| find /i "PID:"`) do set PID=%%a
set LOGFILE="logs\update.log"
set "SAY=echo %date% %time%"
call :LOG > %LOGFILE%
:LOG

%SAY% "Updating AzimutPOS..."

%SAY% "Wait for processes to terminate"
%SAY% "Killing remaining processes"
@taskkill /f /im TechnoPOS.exe >NUL 2>&1
for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%PID%" (
        TASKKILL /PID %%a /f >NUL 2>&1
    )
)
CALL "etc\scripts\timeout.bat" 3
:WAITPOS
%SAY% "Killing remaining processes"
@taskkill /f /im TechnoPOS.exe >NUL 2>&1

for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%PID%" (
        TASKKILL /PID %%a /f >NUL 2>&1
    )
)
CALL "etc\scripts\timeout.bat" 3
set STILLRUNNING=0
for /f "skip=3 tokens=2 delims= " %%a in ('tasklist /fi "imagename eq AzimutPOS.exe"') do (
    if "%%a" neq "%PID%" (
        set STILLRUNNING=1
    )
)
IF "%STILLRUNNING%" == "0" (
  GOTO CONTINUE
) ELSE (
  ECHO AzimutPOS is still running
  GOTO WAITPOS
)

:CONTINUE


%SAY% "All processes terminated, processing the update."
%SAY% "updates\%arg2%"

if not exist "updates\%arg2%" (
	for /f "delims=" %%a in ('dir /b /a-d "updates\*.zip" ') do set arg2=%%a
)

%SAY% "Apply update: %arg2%"
CALL "etc\scripts\timeout.bat" 5
if exist "%temp%\SevenZip\" del /f /q "%temp%\SevenZip"
if not exist "%temp%\SevenZip\" mkdir "%temp%\SevenZip\"
xcopy "vendors\SevenZip\*" "%temp%\SevenZip\" /E /Y /q

CALL "etc\scripts\timeout.bat" 3
rmdir package.nw /s /q >NUL 2>&1
%SAY% "Unzipping %arg2%"
CALL "%temp%\SevenZip\7za.exe" x -y "updates\%arg2%" -bse1 > "updates\update_7z.log"
ICACLS "%azimutpos%" /grant "everyone":(OI)(CI)F >NUL 2>&1
%SAY% "Updated successfully!"
%SAY% "Starting AzimutPOS"
call "etc\scripts\launcher\AzimutPOS.bat"
exit 0