var
	app,
	_updateAvailableNotification = null,
	_updateNotification = null,
	system,
	update = {
		hasUpdated: false,
		isUpdating: false,
		_init: function (parent, cback) {
			app = parent;
			system = app.system;
			update.useEnv = '' + app.cfg.env;
			if (cback) cback();
		},
		waitDownloaded: function (cback) {
			if (update.isDownloading || app.status == 'updating') {
				setTimeout(function () {
					update.waitDownloaded(cback);
				}, 1000);
				return;
			}
			cback();
		},
		check: function (vars, cback) {
			if (update.isProcessing) {
				console.warn('Update already processing')
				return false;
			}
			update.isProcessing = true;
			system.localConfig.get(function (defaultConfig) {
				let cbacked = 0, _doCback = function () {
					update.isProcessing = false;
					if (cbacked) return;
					cbacked = 1;

					try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
					try { if (_updateNotification) _updateNotification.remove(); } catch (er) { }
					if (cback) cback();
					app.splashscreen.unsetMessage('update_in_progress')
				}
				if (!vars) vars = {};
				if (vars.env) update.useEnv = '' + vars.env;
				if (update.useEnv != app.cfg.env) vars.force = 1;

				var _channel = app.pathExists(app, 'data.session.configs.advanced.updates.channel') || app.pathExists(defaultConfig, 'configs.advanced.updates.channel') || false;
				if (_channel == 'stable') _channel = '';
				if (vars.useEdge || app.pathExists(app, 'data.session.configs.updatesUseEdge')) {
					_channel = 'edge';
				}
				if (vars.channel) _channel = '' + vars.channel;
				if (!_channel) _channel = '' + app.cfg.channel.split('/').pop();

				if (!vars.force && !vars.forceDownload && _m.fs.existsSync(app.baseDir + 'DO_NOT_UPDATE')) {
					system.emit({
						module: 'system',
						action: 'updateProgress',
						data: {
							status: 'DO_NOT_UPDATE'
						}
					});
					_doCback();
					return;
				}
				if (vars && !app.isEmptyObject(vars)) console.log('UPDATE VARS', vars)
				try {
					app.pos.win.window.POS_setUpdateProgress('checking', 'in_progress');
				} catch (er) { }

				system.emit({
					module: 'system',
					action: 'updateProgress',
					data: {
						status: 'check_in_progress'
					}
				});
				let _pkgAddr = app.cfg.updatesUrl[update.useEnv] + (_channel ? 'channels/' + _channel + '/' : '') + (update.useEnv == 'dev' ? 'latest/' : '') + 'package.json';
				console.log('Checking for updates at', _pkgAddr)
				system.request.GET(_pkgAddr, { noCache: 1, timeout: 1000 * 10, options: { maxTries: 2 } }, function (e, r, b) {
					try {
						_m.fs.mkdirSync(app.baseDir + 'updates');
					} catch (er) { }
					let statusCode = app.pathExists(e, 'code') || app.pathExists(e, 'errorCode') || app.pathExists(r, 'statusCode') || 500;
					if (typeof statusCode == 'string' || statusCode > 400) {
						console.log('An error occured while requesting package.json', statusCode);

						try {
							app.pos.win.window.POS_setUpdateProgress('checking', 'error', statusCode);
						} catch (er) { }

						system.emit({
							module: 'system',
							action: 'updateProgress',
							data: {
								status: 'error',
								code: statusCode
							}
						});
						_doCback();
						return;
					}
					let d = system.JSON.parse(b);
					d.channel = _channel || 'release';
					//console.log(d)
					_m.fs.writeFileSync(app.baseDir + 'updates/package_remote.json', JSON.stringify(d, undefined, 4));
					let ext = 'zip',//app.cfg.platform.indexOf('win') != -1 ? 'zip' : 'tar.gz',
						archive = app.baseDir + 'updates/' + d.packages[app.cfg.platform].hash + '.' + ext;
					update.removeOld(function () {
						//console.log('app.cfg.build_id', app.cfg.build_id)
						//console.log('d.build_id', d.build_id)
						var _upStatus = {
							channel: d.channel,
							me: system.id,
							current: {
								build_id: app.cfg.build_id,
								buildDate: app.cfg.buildDate
							},
							package: {
								build_id: d.packages[app.cfg.platform].build_id,
								buildDate: d.packages[app.cfg.platform].buildDate
							},
							matches: {

								build_id: app.cfg.build_id == d.packages[app.cfg.platform].build_id,
								buildDate: app.cfg.buildDate == d.packages[app.cfg.platform].buildDate,
								newerAvailable: new Date(app.cfg.buildDate).getTime() < new Date(d.packages[app.cfg.platform].buildDate).getTime()
							}
						};
						try { _m.fs.writeFileSync(app.cacheDir + 'update_debug.json', JSON.stringify(_upStatus, undefined, 4)); } catch (er) {
							console.error(er.message || er)
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'error_writing_cache',
									debug: er.message || er
								}
							});
							_doCback();
							return;
						}
						console.log('UPDATE STATUS', _upStatus)
						if (!d.packages[app.cfg.platform].hash) {
							console.warn('update failed, package_error')
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'package_error',
									debug: 'hash is null'
								}
							});
							_doCback();
							return;
						}
						if (!d.packages[app.cfg.platform].build_id) {
							console.warn('update failed, package_error')
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'package_error',
									debug: 'build id is null'
								}
							});
							_doCback();
							return;
						}
						if (vars.getPkgOnly) {
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'get_pkg_only'
								}
							});
							_doCback();
							return;
						}
						if (!vars.force && !vars.forceDownload && (!_upStatus.matches.newerAvailable || _upStatus.matches.build_id || _upStatus.matches.buildDate)) {
							console.log('no update needed.')
							setTimeout(function () {
								system.emit({
									module: 'system',
									action: 'updateProgress',
									data: {
										status: 'no_update_needed',
										debug: _upStatus
									}
								});
							}, 1000);
							_doCback();
							return;
						}
						if (vars.forceDownload || app.cfg.build_id != d.packages[app.cfg.platform].build_id) {
							try {
								app.splashscreen.setMessage('update_in_progress', app.parseLocales('splash.update_in_progress'));
							} catch (er) { }
							try {
								app.pos.win.window.POS_setUpdateProgress('downloading', 'in_progress');
							} catch (er) { }
							try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
							_updateNotification = vars.silent ? null : app.pos.notifications.show({
								title: app.parseLocales('system.updates.update_in_progress'),
								message: app.parseLocales('system.updates.downloading_files') + ' <span class="progressPCT"></span>',
								timeout: -1,
								closeBtn: 1
							})
							let
								_doDownload = async () => {
									let _pURL = '' + d.packages[app.cfg.platform].url;
									if (_channel) _pURL = _pURL.replace('updates/', 'channels/' + _channel + (update.useEnv == 'dev' ? '/latest' : '') + '/updates/');
									console.log('Downloading update', app.cfg.updatesUrl[update.useEnv] + '' + _pURL)

									if (!vars.silent && _updateNotification) _updateNotification.setMessage(app.parseLocales('system.updates.downloading_files') + ' <span class="progressPCT"></span>');
									app.status = 'updating';
									let e,
										onDiffer = function () {
											//force differing
											vars.doNotApply = 1;
											//update.isDownloading = false;
											app.status = 'ready';
											app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.update_delayed'));
											//in case update is being delayed, this is called to allow POS to run, deferring update at a later time
											setTimeout(function () {
												_doCback();
											}, 1000);
										},
										onState = function (state) {
											//console.log('download state', state)
											//download progress
											if (!vars.silent && _updateNotification) {
												try { _updateNotification.setProgressBar(state); } catch (er) { console.error('Error setting notification progress bar', er.message, state) }
												try {
													if (state.percent == 1)
														_updateNotification.remove()
												} catch (er) { }
											}
										};
									if (app.system.vars.isOnFrontCloud && update.useEnv != 'dev') {
										//check hash first

										//if(hash matches, download local)
										e = await update.download('https://192.168.94.1/AzimutPOS/appUpdates/channels/' + _channel + '/' + d.packages[app.cfg.platform].url + '?_=' + new Date().getTime(), archive, onDiffer, onState);
									}
									if (!e || e?.result != 'success')
										e = await update.download(app.cfg.updatesUrl[update.useEnv] + '' + _pURL.replace('tar.gz', 'zip') + '?_=' + new Date().getTime(), archive, onDiffer, onState);
									update.isDownloading = false;
									if (e) console.log(e)
									//if (vars.doUpdate)
									if (e.result == 'success'/* && !vars.getOnly*/) {
										try {
											app.splashscreen.setMessage('update_in_progress', app.parseLocales('splash.update_in_progress'));
										} catch (er) { }
										try {
											app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.update_check_hash'));
										} catch (er) { }
										try {
											app.pos.win.window.POS_setUpdateProgress('check_hash', 'in_progress');
										} catch (er) { }
										//console.log('checking hashes');
										//app.hash.File(archive, 'sha256', function (hash) {
										//	try {
										//		app.splashscreen.win.window.setUpdateProgressMessage('');
										//	} catch (er) { }
										//	try {
										//		app.pos.win.window.POS_setUpdateProgress('ready');
										//	} catch (er) { }
										//	if (d.packages[app.cfg.platform].hash == hash) {
										//		console.log('HASHES MATCH!');
										//		if (!vars.getOnly)
										//			update.do(vars,d.packages[app.cfg.platform].hash + '.' + ext, _doCback);
										//		return;
										//	}
										//	console.log('HASHES MISMATCH!', d.packages[app.cfg.platform].hash, 'VS', hash);
										//	try {
										//		app.splashscreen.win.window.setMessage(app.parseLocales('splash.update_error'));
										//	} catch (er) { }
										try {
											app.pos.win.window.POS_setUpdateProgress('ready');
										} catch (er) { }
										//	_m.fs.unlink(archive, function () { });
										//	setTimeout(function () {
										//		_doCback();
										//	}, 1000 * 3);
										//});
										//return;

										//if windows and employee logged in, do not apply and notify
										if (!vars.doNotApply && app.cfg.platform.indexOf('win') === 0 && app.pathExists(app, 'pos.lastActivity.employee_id')) {
											vars.doNotApply = 1;
										}
										if (!vars.executeNoRestart && app.pathExists(app, 'pos.lastActivity.employee_id')) {
											vars.executeNoRestart = 1;
										}

										if (!vars.doNotApply)
											update.do(vars, d.packages[app.cfg.platform].hash + '.' + ext, _doCback);
										else if (!vars.silent && app.pos && app.pos.win && app.pos.win.window) {
											try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
											_updateAvailableNotification = app.pos.notifications.show({
												preventClose: 1,
												focusOnBlur: 1,
												title: app.parseLocales('system.updates.update_available.title'),
												message: app.parseLocales('system.updates.update_available.message'),
												closeBtn: 1,
												buttons: [
													{
														label: app.parseLocales('system.updates.update_available.do_now'),
														action: 'do_now',
														cls: 'primary'
													},
													{
														label: app.parseLocales('system.updates.update_available.do_later'),
														action: 'do_later',
														cls: 'secondary'
													}
												],
												onClick: function (idx) {
													if (idx == 'do_now') {
														update.do(vars, d.packages[app.cfg.platform].hash + '.' + ext);
													}
													if (idx == 'do_later') {
														try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
													}
												}
											});
											system.emit({
												module: 'system',
												action: 'updateProgress',
												data: {
													status: 'update_available_notified'
												}
											});
											_doCback();
										}
										return;
									}

									app.status = 'ready';
									if (vars.doNotApply) _doCback();
								};
							if (_m.fs.existsSync(archive)) {
								if (!vars.forceDownload) {
									console.warn('update check hash')
									system.emit({
										module: 'system',
										action: 'updateProgress',
										data: {
											status: 'update_check_hash'
										}
									});
									app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.update_check_hash'));
									setTimeout(function () {
										if (!vars.silent && _updateNotification) _updateNotification.setMessage(app.parseLocales('splash.update_check_hash'));
									}, 500);
									app.hash.File(archive, 'sha256', function (hash) {
										if (d.packages[app.cfg.platform].hash == hash) {
											console.log('update_check_hash_match')
											system.emit({
												module: 'system',
												action: 'updateProgress',
												data: {
													status: 'update_check_hash_match'
												}
											});
											//hash is ok, just do the update

											if (!vars.doNotApply)
												update.do(vars, d.packages[app.cfg.platform].hash + '.' + ext, _doCback);
											else {
												_doCback();
											}
											return;
										}

										system.emit({
											module: 'system',
											action: 'updateProgress',
											data: {
												status: 'update_check_hash_mismatch'
											}
										});
										_m.fs.unlink(archive, function () {
											_doDownload();
										});
									});
									return;
								}
								_m.fs.unlink(archive, function () {
									_doDownload();
								});
								return;
							}
							_doDownload();
							return;
						}
						//app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.update_check_hash'));
						//app.hash.File(archive, 'sha256', function (hash) {
						//	if (d.packages[app.cfg.platform].hash == hash) {
						//		//update.do(vars,d.packages[app.cfg.platform].hash + '.' + ext);
						//		return;
						//	}
						//	console.log('HASHES MISMATCH!', d.packages[app.cfg.platform].hash, 'VS', hash);
						//	_m.fs.unlink(archive, function () { });
						//});
						if (vars.force) {
							console.warn('update forced.')
							update.do(vars, d.packages[app.cfg.platform].hash + '.' + ext, _doCback);
							return;
						}
						//console.log('update not required.')
						update.isDownloading = false;
						try {
							app.pos.win.window.POS_setUpdateProgress('checking', 'done', 'not_required');
						} catch (er) { }

						try {
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'not_required'
								}
							});
						} catch (er) { }
						_doCback();
					});
				});

			});
		},
		download: async (url, dest, differ, progress) => {
			return new Promise(async (resolve) => {
				try {
					var resumable = require(system.libsDir + 'resumable-request.js');
					let
						isDiffered = false,
						file = _m.fs.createWriteStream(dest + '.part');
					url = url.replace(/\/\//g, '/').replace('http:/', 'http://').replace('https:/', 'https://').replace('http://', 'https://'),
						cbacked = false;
					update.isDownloading = true;
					console.log('URL', url)
					let
						_ended = 0,
						req = resumable(app._m.request, {
							method: 'GET',
							url: url

						}, {
							progressOptions: {
								// throttle: 2000,                    // Throttle the progress event to 2000ms, defaults to 1000ms
								delay: 1000,                       // Only start to emit after 1000ms delay, defaults to 0ms
								// lengthHeader: 'x-transfer-length'  // Length header to use, defaults to content-length
							}
						});
					req
						.on('progress', function (state) {
							if (_ended) return;
							update.isDownloading = true;

							// The state is an object that looks like this: 
							// { 
							//     percentage: 5,               // Overall percent (between 0 to 100) 
							//     speed: 554732,              // The download speed in bytes/sec 
							//     size: { 
							//         total: 90044871,        // The total payload size in bytes 
							//         transferred: 27610959   // The transferred payload size in bytes 
							//     }, 
							//     time: { 
							//         elapsed: 36.235,        // The total elapsed seconds since the start (3 decimals) 
							//         remaining: 81.403       // The remaining seconds to finish (3 decimals) 
							//     } 
							// } 
							//console.log(state)
							if (progress) progress(state);
							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'Downloading',
									progress: state
								}
							});
							try {
								app.pos.win.window.POS_setUpdateProgress('downloading', 'in_progress', state);
							} catch (er) { }
							if (!isDiffered) {
								app.splashscreen.win.window.setUpdateDownloadProgress(state);
								if (state.time.elapsed > 30 && state.time.remaining > 60) {
									isDiffered = true;
									if (differ) differ();
								}
							}
						})
						.on('socketError', function (err) {
							console.error('socketError', err);
						})
						.on('error', function (err) {
							update.isDownloading = false;
							_ended = 1;
							// Do something with err 
							_m.fs.unlink(dest, function () { }); // Delete the file async. (But we don't check the result)
							if (cb && !cbacked) {
								cbacked = 1;
								resolve({ result: 'error', error: err, code: err.code, message: err.message });
							}
						})
						.on('end', function () {
							update.isDownloading = false;
							_ended = 1;
							console.log('END')
						})
						.on('complete', function (d) {
							update.isDownloading = false;
							_ended = 1;
							// Do something after request finishes
							console.log('Xfer ended', d)

							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'Download_complete'
								}
							});
							if (progress) progress({ percent: 1 });
							try {
								app.pos.win.window.POS_setUpdateProgress('downloading', 'completed', { percent: 1 });
							} catch (er) { }
							if (!isDiffered) app.splashscreen.win.window.setUpdateDownloadProgress({ percent: 1 });
							//file.close();
						})
						.pipe(file);
					file.on('finish', function () {
						file.close(function () {
							//console.log('file written')
							app._m.fs.rename(dest + '.part', dest, function (err) {
								if (err) {
									console.error('couldnt rename', err.message || err)
									resolve({ result: 'error' });
									return;
								}
								setTimeout(function () {
									resolve({ result: 'success' });
								}, 1000);
							});
						});
					});
				}
				catch (er) {
					console.log(er)
					resolve({ result: 'error' });
				}
			});
		},
		do: function (vars, file, cback) {
			if (!cback) cback = function () { };
			console.log('Apply update', file)
			if (app.isLinuxDev) {
				console.info('Just kidding, updates? No thanks.');
				cback();
				return;
			}
			try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
			var notif = null;
			if (!vars.silent && app.pos && app.pos.win && app.pos.win.window)
				notif = app.pos.notifications.show({
					title: app.parseLocales('splash.update_in_progress'),
					message: app.parseLocales('splash.running_updater'),
					timeout: -1,
					closeBtn: 1
				});
			system.emit({
				module: 'system',
				action: 'updateProgress',
				data: {
					status: 'updating'
				}
			});
			app.status = 'updating';
			try {
				app.splashscreen.setMessage('update_in_progress', app.parseLocales('splash.update_in_progress'));
			} catch (er) { }
			try {
				app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.running_updater'));
			} catch (er) { }
			//Start new app
			let _s = app.baseDir + '/updater/AzimutPOS_Updater', _a = [app.baseDir], _o = { detached: true, shell: true };
			if (app.cfg.platform.indexOf('win') === 0) {
				//app._m.spawn('etc\\scripts\\update\\update.bat',['ecfa636604379ed6bad62ed29d6e0f5147dca13ff58e3b6b90bbbc49e1c7e952.zip'],{cwd:app.baseDir,detached:true,shell:false});
				_s = 'cmd';
				_o.cwd = app.baseDir;
				//if (!app._m.fs.existsSync(app.baseDir + '\\etc\\scripts\\update\\update.bat'))
				app._m.fs.writeFileSync(app.baseDir + '\\etc\\scripts\\update\\update.bat', app._m.fs.readFileSync(app._appPath + '\\etc\\scripts\\update\\update.bat').toString());
				_a = ['/c', 'etc\\scripts\\update\\update.bat', [file]];
			}
			if (app.cfg.platform.indexOf('linux') != -1 || app.cfg.platform.indexOf('osx') != -1 || app.cfg.platform.indexOf('mac') != -1) {
				_s = 'bash';
				//if (!app._m.fs.existsSync(app.baseDir + 'etc/scripts/update/update.sh'))
				app._m.fs.writeFileSync(app.baseDir + 'etc/scripts/update/update.sh', app._m.fs.readFileSync(app._appPath + 'etc/scripts/update/update.sh').toString());
				_a = [app.baseDir + 'etc/scripts/update/update.sh', file];
				_o = { shell: true };
			}
			//console.log('spawn: "' + _s + '"', 'args:', _a)
			let child = _m.spawn(_s, _a, _o);
			child.stdout.on('data', (data) => {
				data = data.toString().trim();
				console.log('updater child stdout', data)
				if (data.indexOf('POS_UPDATER_READY') != -1) {
					system.emit({
						module: 'system',
						action: 'updateProgress',
						data: {
							status: 'launching_updater'
						}
					});
					child.unref();
					console.log('Updater is ready, quit.');
					app.exit(0);
				}
				else if (data.indexOf('STEP:UNZIP') != -1) {
					system.emit({
						module: 'system',
						action: 'updateProgress',
						data: {
							status: 'unzipping'
						}
					});
					try {
						app.splashscreen.setMessage('update_in_progress', app.parseLocales('splash.update_in_progress'));
					} catch (er) { }
					try {
						app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.unzipping'));
					} catch (er) { }

				}
				else if (data.indexOf('STEP:UNZIP_DONE') != -1) {
					system.emit({
						module: 'system',
						action: 'updateProgress',
						data: {
							status: 'unzipped'
						}
					});

				}
				else if (data.indexOf('POS_UPDATE_DONE_NOW_RESTART') != -1) {
					update.hasUpdated = true;
					app.status = 'ready';
					system.emit({
						module: 'system',
						action: 'updateProgress',
						data: {
							status: 'update_done'
						}
					});
					try { if (notif) notif.remove(); } catch (er) { }
					try { if (_updateAvailableNotification) _updateAvailableNotification.remove(); } catch (er) { }
					if (vars.executeNoRestart || app.pathExists(app, 'pos.lastActivity.employee_id')) {
						if (!vars.silent && app.pos && app.pos.win && app.pos.win.window) {
							_updateAvailableNotification = app.pos.notifications.show({
								preventClose: 1,
								focusOnBlur: 1,
								title: app.parseLocales('system.updates.update_done.title'),
								message: app.parseLocales('system.updates.update_done.message'),
								closeBtn: 1,
								buttons: [
									{
										label: app.parseLocales('system.updates.update_done.restart_now'),
										action: 'restart_now',
										cls: 'primary'
									},
									{
										label: app.parseLocales('system.updates.update_done.restart_later'),
										action: 'restart_later',
										cls: 'secondary'
									}
								],
								onClick: function (idx) {
									if (idx == 'restart_now') {
										app.restart(1);
									}
								}
							});

							system.emit({
								module: 'system',
								action: 'updateProgress',
								data: {
									status: 'update_done_notified'
								}
							});
						}
					}
					else {

						try {
							app.splashscreen.setMessage('update_in_progress', app.parseLocales('splash.update_in_progress'));
						} catch (er) { }
						try {
							app.splashscreen.win.window.setUpdateProgressMessage(app.parseLocales('splash.restarting'));
						} catch (er) { }
						system.emit({
							module: 'system',
							action: 'updateProgress',
							data: {
								status: 'update_done_restart'
							}
						});
						app.status = 'restarting';
						app.restart(1);
					}
				}
			});

			child.stderr.on('data', (data) => {
				data = data.toString().trim();
				console.log('updater stderr', data);
			});
			//Don't wait for it
			if (_o.detached)
				setTimeout(function () {
					child.unref();
					//Quit current
					console.log('Updater is supposed to run but havent send message, quit.');
					app.exit(0);  // quit node-webkit app
				}, 5 * 1000);
		},
		removeOld: function (cb) {
			let d = JSON.parse(app._m.fs.readFileSync(app.baseDir + 'updates/package_remote.json'));
			app._m.fs.readdir(app.baseDir + 'updates/', 'utf8', function (err, files) {
				if (files && files.length) {
					let _hashes = [], pkgs = Object.keys(d.packages);
					for (let i = 0; i < pkgs.length; i++) {
						_hashes.push(d.packages[pkgs[i]].hash);
					}
					app._m.async.eachSeries(files, function (f, n) {
						if (f.indexOf('.json') == -1 && f.indexOf('.log') == -1 && _hashes.indexOf(f.split('.')[0]) == -1) {
							console.log('delete file', f)
							app._m.fs.unlink(app.baseDir + 'updates/' + f, function () { n(); });

							return;
						}
						n();
					}, cb || function () { });
					return;
				}
				if (cb) cb();
			});
		}
	};
module.exports = update;