// Require
var
	_APPNAME = 'AzimutPOS',
	fs = require("fs-extra"),
	os = require('os'),
	_username = os.userInfo().username,
	url = 'https://pos.legacy.azimutpos.com',
	urls = {
		live: '' + url,
		dev: 'https://pos.legacy.azimutpos.dev.46degresn.ca'
	},
	_updatesURL = {
		"prod": "https://d2vh72iz1x8zfl.cloudfront.net/" + _APPNAME + "/",
		"dev": "https://sources.legacy.azimutpos.dev.46degresn.ca/"
	},
	_baseDIR = '' + __dirname,
	runPath = '',
	preLogs = [],
	logFile,
	logFileError,
	app,
	_m = {},
	platform = '';

try {
	_m.path = require('path');
} catch (er) { console.error('loading path', er); }
try {
	_m.async = require('async');
} catch (er) { throw er; }
try {
	_m.childProcess = require('child_process');
} catch (er) { throw er; }
try {
	_m.exec = _m.childProcess.exec;
} catch (er) { throw er; }
try {
	_m.execSync = _m.childProcess.execSync;
} catch (er) { throw er; }
try {
	_m.spawn = _m.childProcess.spawn;
} catch (er) { throw er; }
try {
	_m.fork = _m.childProcess.fork;
} catch (er) { throw er; }

var consolewarn = console.warn, consoleinfo = console.info, consolelog = console.log, consoleerror = console.error;
/**
 * THIS is REALLY a BAD way to handle errors BUT.... at least we can have the timestamp!
 */
process.on('uncaughtException', function (err) {
	try {
		if (app && app.isSDK) consoleerror('UNCAUGHT ERROR: ' + err.message, err);
	} catch (er) { }
	try {
		console.error('UNCAUGHT ERROR: ' + err.message, err.stack && !app.isEmptyObject(err.stack) ? err.stack : err);
		return;
	} catch (er) {

	}
	console.error('UNCAUGHT ERROR:', err);
	//if (app) app.exit(1); else process.exit(1);
});

process.on("SIGTERM", function () {
	console.warn('CLOSING [SIGTERM]');
	if (app) app.exit(1); else process.exit(1);
});
process.on("SIGINT", function () {
	console.warn('CLOSING [SIGINT]');
	if (app) app.exit(1); else process.exit(1);
});
process.on('message', function (msg) {
	console.warn('process.message', msg);
	if (msg == 'exit') {
		console.log('GOT EXIT MESSAGE');
		if (app) app.exit(0); else process.exit(0);
	}
});

String.prototype.escapeJSONSpecialChars = function () { /*  /\n /\' /\" /\& /\r /\t /\b /\f */
	return this.replace(/\n/g, '\\n').replace(/\\\n/g, '\\n').replace(/\t/g, '');
};
String.prototype.ltrim = function (c) {
	var str = this;
	if (str.substring(0, 1) == c)
		str = str.substring(1);
	return str;
};
String.prototype.rtrim = function (c) {
	var str = this;
	if (this.substr(str.length - 1) == c)
		str = str.substring(0, str.length - 1);
	return str;
};
String.prototype.ucfirst = function () {
	return this.charAt(0).toUpperCase() + this.slice(1);
};
String.prototype.insertAt = function (index, string) {
	var _start = (index < 0) ? this.substr(0, this.length - Math.abs(index)) : this.substr(0, index);
	return _start + string + this.substr(index);
};

String.prototype.replaceAppAndModulesPath = function () {
	let a = this.replace(/chrome\-extension\:\/\/[a-z0-9\-]+\//i, '').replace(/.*\\nw([\d_]+)\\/, '').replace(/.*\\nwjs\.([a-zA-Z0-9_]+)\\/, '').replace(/.*(\/|\.)nwjs\.([a-zA-Z0-9_]+)\//, '');
	if (!App || !App.baseDir)
		return a.split(_APPNAME.toLowerCase() + '-nwjs/').pop().split('app.nw/').pop().split('/nwjs-source/').pop().split('package.nw/').pop().split('package.nw\\').pop();
	return a.replace(_baseDIR, '').replace(App.baseDir, '').split('/app.nw/').pop().split('/nwjs-source/').pop().split('package.nw/').pop().split('package.nw\\').pop().replace(/\/modules/g, '').replace('node_modules/pwmapp', 'app').replace(/\/\//g, '/');
};
console.log = function () {
	try {
		var
			time = new Date().toISOString(),
			stk = (new Error()).stack,
			fn = '', fnl = '',
			_level = consolelog, _L = 'VERBOSE',
			file = '',
			line = '',
			_fore = '\x1b[38;5;250m'; //https://en.wikipedia.org/wiki/ANSI_escape_code#Colors
		if (stk.indexOf('console.info') != -1) {
			_level = consoleinfo;
			_L = 'INFO';
			//_fore='\x1b[34m';
			_fore = '\x1b[38;5;33m';
			if (App && App.cfg && App.logLevels.I.level < App.cfg.loglevel)
				return;
		}
		else if (stk.indexOf('console.warn') != -1) {
			_level = consolewarn;
			_L = 'WARN';
			_fore = '\x1b[33m';
			if (App && App.cfg && App.logLevels.W.level < App.cfg.loglevel)
				return;
		}
		else if (stk.indexOf('console.error') != -1) {
			_level = consoleerror;
			_L = 'CRITICAL';
			_fore = '\x1b[31m';
			if (App && App.cfg && App.logLevels.E.level < App.cfg.loglevel)
				return;
		}

		_fore = '';//remove colors since it's chromium

		if (!Array.isArray(stk)) {
			stk = stk.replace(/\.\(anonymous function\)/g, '');
			var _fnl = 1;
			try {
				do {
					fnl = stk.match(/at (\S+)/g)[_fnl];
					fn = fnl.slice(3);
					_fnl++;
				}
				while (_fnl < 100 && (
					fn.indexOf('console.') != -1 || fn.indexOf('Object.tryCatch') != -1 || fn.indexOf('ontimeout') != -1 ||
					fn.indexOf('routeEventToSubmodule') != -1 || fn.indexOf('uncaughtException') != -1 || fn.indexOf('process.<anonymous>') != -1));
			}
			catch (er) { consoleerror(er); }
			fn = fn.replace(/\(/g, '').replace(/\./g, '\\.');
			var re = new RegExp("at " + fn + ".*", 'gm');
			var stkln = stk.match(re);
			if (stkln) {
				var _stkln = stkln[0].match(/\((\S+):(\d+):(\d+)\)/);
				if (_stkln) {

					file = _stkln[1].replaceAppAndModulesPath();
					line = _stkln[2];
				}
				else {
					_stkln = stkln[0].match(/(\S+):(\d+):(\d+)/);
					if (_stkln) {
						file = _stkln[1].replaceAppAndModulesPath();
						line = _stkln[2];
					}
				}
			}
			if (fn && fn.indexOf('/') != -1)
				fn = '';
			if (fn.indexOf('Object.') === 0 || fn.indexOf('Object\\.') === 0) {
				var re = new RegExp("at " + fn + ".*", 'gm');
				var fnm = stk.match(re);
				fn = (fnm[0] || '').split('/').pop().split(':')[0].replace('.js', '') + fn.replace('Object', '');
			}
		}
		fn = fn.replace(/\\\./g, '.');
		file = file.replaceAppAndModulesPath();
		if (!file && fn && fn.match(/[a-z0-9\-_]+\.js\:[\d]+\:[\d]+$/)) {
			file = '' + fn.replaceAppAndModulesPath();
			fn = '';
		}

		var fileinf = (fn ? '@' + fn + ' ' : '') + file + ':' + line,
			mainArguments = Array.prototype.slice.call(arguments);
		var
			jsonLogStr = JSON.stringify({
				date: time, level: _L,
				message: mainArguments.length == 1 ?
					(typeof mainArguments[0] == 'string' && (mainArguments[0].indexOf('[') === 0 || mainArguments[0].indexOf('{') === 0) ? (app.JSON ? app.JSON : JSON).parse(mainArguments[0]) : mainArguments[0]) :
					Object.keys(mainArguments).map(function (k) { return typeof mainArguments[k] == 'string' && (mainArguments[k].indexOf('[') === 0 || mainArguments[k].indexOf('{') === 0) ? (app.JSON ? app.JSON : JSON).parse(mainArguments[k]) : mainArguments[k]; }),
				file: file + ':' + line, metadata: '', namespace: '', functionName: fn || ''
			});
		if (!logFile) {
			preLogs.push(jsonLogStr)
		}
		if (logFile && jsonLogStr.indexOf('LogRotate: file ') == -1) {
			logFile.write(jsonLogStr + os.EOL);
			if (['CRITICAL', 'WARN'].indexOf(_L) != -1) {
				logFileError.write(jsonLogStr + os.EOL);
			}
		}

		if (App && App.cfg && App.cfg.logs && App.cfg.logs.format == 'json') {

			_level(_fore + jsonLogStr + (_fore ? '\x1b[0m' : ''));
			return;
		}
		mainArguments.unshift(_fore + time + ' - [' + _L + '] -');
		mainArguments.push(fileinf + (_fore ? '\x1b[0m' : ''));
		_level.apply(null, mainArguments);
	}
	catch (er) {
		consoleerror(er, arguments)
	}
};
console.logRaw = function () {
	var mainArguments = Array.prototype.slice.call(arguments);
	consolelog.apply(null, mainArguments);
};
console.info = function () {
	var mainArguments = Array.prototype.slice.call(arguments);
	console.log.apply(null, mainArguments);
};
console.warn = function () {
	var mainArguments = Array.prototype.slice.call(arguments);
	console.log.apply(null, mainArguments);
};
console.error = function () {
	var mainArguments = Array.prototype.slice.call(arguments);
	console.log.apply(null, mainArguments);
};
_m.fs = fs;
_m.os = os;
class App {
	constructor() {
		app = this;
		app.data = {};
		try {
			app.timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
		} catch (er) { }
		app._m = _m;
		this.splashscreen = null;
		this.utilities = null;
		this.pos = null;
		this.isLinuxDev = [_APPNAME, _APPNAME + '.exe'].indexOf(process.argv[0].replace(/\\/g, '/').split('/').pop()) == -1 && process.argv[0].indexOf('/' + _APPNAME + '.app/') == -1;
		//console.log(process.argv);
		//this.baseDir = ((this.isLinuxDev ? _baseDIR : _m.path.dirname(process.argv[0])) + '/').replace('//', '/');


		app.tmp_folder = _m.os.tmpdir() + '/' + _APPNAME + '/';
		try {
			let _p = _m.os.platform();
			platform = (_p == 'darwin' ? 'osx64' : _p);
			if (platform.indexOf('win') != -1) {
				if (_m.os.arch() == 'x64')
					platform = 'win64';
				app.tmp_folder = '' + process.env.TEMP + '\\' + _APPNAME + '\\';
			}
		}
		catch (e) {
		}
		app.isSDK = process.versions["nw-flavor"] == 'sdk';
		app.locales = null;
		app.locale = "fr_CA";
		app.logLevels = {
			'L': {
				level: 0, //always log (default)
				name: 'VERBOSE',
				wname: 'silly'
			},
			'I': {
				level: 1,
				name: 'INFO',
				wname: 'verbose'
			},
			'D': {
				level: 2,
				name: 'DEBUG',
				wname: 'info'
			},
			'W': {
				level: 3,
				name: 'WARN',
				wname: 'warn'
			},
			'E': {
				level: 4,
				name: 'ERROR',
				wname: 'error'
			},
			'C': {
				level: 5,
				name: 'CRITICAL',
				wname: 'error'
			},
		};


		let _aposPath = fs.existsSync('C:\\Program Files (x86)\\' + _APPNAME + '\\') ? 'C:\\Program Files (x86)\\' + _APPNAME + '\\' : 'C:\\Program Files\\' + _APPNAME + '\\';
		app.baseDir = (app.isLinuxDev ? _baseDIR + '/' : (platform.indexOf('win') === 0 ? _aposPath : _m.path.dirname(process.argv[0]))).replace(/\/\//g, '/');
		if (app.isLinuxDev) {
			if (_baseDIR.indexOf('/source/') == -1) {
				_baseDIR += '/source';
				app.baseDir += 'source/';
			}
		}
		app.rootDir = '' + app.baseDir;
		app.homeDir = '/home/' + _username + '/';
		if (platform.indexOf('linux') != -1) {
			if (!app.isLinuxDev) {
				app.baseDir = fs.existsSync('/opt/' + _APPNAME + '') ? '/opt/' + _APPNAME + '/' : (
					fs.existsSync(app.homeDir + '' + _APPNAME + '/') ? app.homeDir + '' + _APPNAME + '/' : _m.path.dirname(process.argv[0].replace('/' + _APPNAME + '', '')).replace(/\/\//g, '/') + '/'
				);
				app.rootDir = '' + app.baseDir;
			}
			_m.exec('find ' + app.homeDir + '.cache/ -name *.pma -exec rm -f {} \\;', (a, b, c) => { if (app.isSDK) console.log('DELETE PMA RESULT', a, b, c) });
		}
		if (platform.indexOf('osx') != -1) {
			app.rootDir = '/Applications/' + _APPNAME + '.app/';
			app.baseDir = app.rootDir + 'Contents/Resources/app.nw/';
		}
		app.isElevated = null;
		app.libsHome = (app.baseDir + '/libs/').replace(/\/\//g, '/');
		if (platform.indexOf('win') === 0) {
			app.homeDir = 'C:\\Users\\' + _username + '\\';
			try {
				_m.childProcess.execFileSync("net", ["session"], { "stdio": "ignore" });

				app.isElevated = true;
			}
			catch (e) {
				app.isElevated = false;
			}
			app.libsHome = (app.baseDir + '\\libs\\').replace(/\\\\/g, '\\');
		}
		//fs.readdir(_baseDIR, function (er, files) {
		//	console.log(_baseDIR, files)
		//})
		app._appPath = _baseDIR + (platform.indexOf('win') === 0 ? '\\' : '/');
		_m.fs.ensureDirSync(app.libsHome);
		app.cacheDir = platform.indexOf('win') === 0 ? app.homeDir + 'AppData\\Local\\' + _APPNAME + '\\.cache' : app.baseDir.replace('/source', '') + ".cache/";
		//console.info('CACHE DIR IS', app.cacheDir)
		if (!app.isLinuxDev) {
			let
				_tposPath = fs.existsSync('C:\\Program Files (x86)\\TechnoPOS\\') ? 'C:\\Program Files (x86)\\TechnoPOS\\' : 'C:\\Program Files\\TechnoPOS\\',
				_tposbaseDir = (platform.indexOf('win') === 0 ? _tposPath : _m.path.dirname(process.argv[0])).replace(/\/\//g, '/'),
				_tposrootDir = '' + _tposbaseDir,
				_tposhomeDir = '/home/' + _username + '/';
			if (platform.indexOf('linux') != -1) {
				_tposbaseDir = fs.existsSync('/opt/TechnoPOS') ? '/opt/TechnoPOS/' : (
					fs.existsSync(_tposhomeDir + 'TechnoPOS/') ? _tposhomeDir + 'TechnoPOS/' : _m.path.dirname(process.argv[0].replace('/TechnoPOS', '')).replace(/\/\//g, '/') + '/'
				);
				_tposrootDir = '' + _tposbaseDir;
			}
			if (platform.indexOf('osx') != -1) {
				_tposrootDir = '/Applications/TechnoPOS.app/';
				_tposbaseDir = _tposrootDir + 'Contents/Resources/app.nw/';
			}
			//console.log({ _tposPath, _tposbaseDir, _tposrootDir, _tposhomeDir })
			let wantedRootDir = _tposrootDir.replace('TechnoPOS', 'AzimutPOS');
			app._relativePath = app._appPath.replace(__dirname, '');
			if (fs.existsSync(_tposrootDir) && !fs.existsSync(wantedRootDir)) {
				//console.log(wantedRootDir, 'not found')
				_m.fs.ensureDir(app.cacheDir, function (err) {
					if (err) console.error('Cannot create cache dir', err.code || err)
					if (platform.indexOf('win') === 0) {
						//hide windows folder in plain sight
						try {
							_m.exec('attrib +s +h "' + app.cacheDir + '"', function (err, stdout, stderr) {
								if (err || stderr) console.warn(err, stdout, stderr)
							})
						} catch (er) { console.error(er) }
						app.cacheDir = app.cacheDir + '\\';
					}
					app.tmp_folder = app.cacheDir + 'tmp' + (platform.indexOf('win') === 0 ? '\\' : '/')
					_m.fs.rmdir(app.tmp_folder + '*', { recursive: true }, function () {
						_m.fs.ensureDir(app.tmp_folder, function (err) {
							if (err && err.code != 'EEXIST') {
								console.error("Error creating tmp folder " + app.tmp_folder + ', ' + (err.message || err.code || err));
								return;
							}
						});
					})
					app.openLogFiles(function () {
						app.loadConfig();
						fs.readFile(_baseDIR + '/libs/locales.json', function (err, locales) {
							app.locales = JSON.parse(locales);
							app.splashscreen = new (require(_baseDIR + "/libs/splashscreen/splashscreen.js"))(app);
							try {
								try {
									app._m.csv = require('csv');
								} catch (er) { console.error('loading csv parser', er); }
								app._m.moment = require('moment-timezone');
								app.splashscreen.initialize(function () {
									app.splashscreen.step1();
									app.splashscreen.setMessage('azimutMigration', app.parseLocales('splash.startup_steps.azimutMigration'));
									let _progress = 10, _setProgress = (p) => {
										if (p < _progress) return;
										_progress = 1 * p;
										app.splashscreen.win.window.setProgress(_progress);
									};
									_setProgress(10);
									//unzip latest to AzimutPOS
									_m.fs.ensureDir(wantedRootDir, function (err) {
										//list most recent zip file
										_m.fs.readdir(_tposrootDir + '/updates/', function (er, files) {
											_setProgress(20);
											if (files?.length) {
												files = files.filter((a) => { return /\.zip$/ig.test(a); }).map(function (fileName) {
													return {
														name: fileName,
														time: _m.fs.statSync(_tposrootDir + '/updates/' + fileName).mtime.getTime()
													};
												})
													.sort(function (a, b) {
														return a.time - b.time ? -1 : 1;
													})
													.map(function (v) {
														return v.name;
													});
											}
											console.log(er, files)
											let _iprogress = 30, _iProg = setInterval(() => {
												if (_iprogress > 80) {
													clearInterval(_iProg)
													return;
												}
												_setProgress(_iprogress);
												_iprogress += 5;
											}, 500);
											let _cmd = "unzip -o -q " + _tposrootDir + "/updates/" + files[0];
											if (platform.indexOf('win') === 0)
												_cmd = '"' + _tposrootDir + 'vendors\\SevenZip\\7za.exe" x -y "' + _tposrootDir + 'updates\\' + files[0] + '" -bse1 > "' + _tposrootDir + 'updates\\migration.log"';
											_m.exec(_cmd, { cwd: wantedRootDir }, function (e, s, o) {
												let _winLinkMaker = require(_baseDIR + "/libs/system/libs/win-shortcut/winshortcut.js");
												_setProgress(80);
												clearInterval(_iProg)
												console.log(e, s, o)
												if (platform.indexOf('win') === 0) {
													try {
														_m.execSync('robocopy "' + app.homeDir + 'AppData\\Local\\TechnoPOS\\.cache" "' + app.homeDir + 'AppData\\Local\\' + _APPNAME + '\\.cache" /e')
													} catch (er) { console.error('cannot move .cache', er.mesage) }
													let
														_lp = 'C:\\Users\\' + _username + '\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup';
													_m.fs.unlink(_lp + '\\TechnoPOS.lnk', function () { });
													_lp = 'C:\\Users\\Public\\Desktop';
													_m.fs.unlink(_lp + '\\TechnoPOS.lnk', function () { });

													_winLinkMaker.makeSync({
														'lnkName': 'AzimutPOS',
														'filepath': 'C:\\Program Files\\AzimutPOS\\etc\\scripts\\launcher\\AzimutPOS.bat',
														'lnkCwd': 'C:\\Program Files\\AzimutPOS\\',
														'lnkIco': 'C:\\Program Files\\AzimutPOS\\AzimutPOS.png',
														'linkPath': _lp
													});
													_winLinkMaker.makeSync({
														'lnkName': 'AzimutPOS',
														'filepath': 'C:\\Program Files\\AzimutPOS\\etc\\scripts\\launcher\\AzimutPOS.bat',
														'lnkCwd': 'C:\\Program Files\\AzimutPOS\\',
														'lnkIco': 'C:\\Program Files\\AzimutPOS\\AzimutPOS.png',
														'linkPath': 'C:\\Users\\' + _username + '\\Desktop'
													});
													_m.fs.unlink(_tposrootDir + '\\TechnoPOS.exe', function () { });
													_m.fs.unlink(_tposrootDir + '\\technopos.ico', function () { });
												}
												else {
													console.log("cp -R " + _tposrootDir + "/.cache " + wantedRootDir, _m.execSync("cp -R " + _tposrootDir + "/.cache " + wantedRootDir))
													_m.exec("rm /home/" + _username + "/.config/autostart/technopos.desktop", function () { })
													_m.exec("rm /home/" + _username + "/.config/autostart/TechnoPOS.desktop", function () { })
													_m.exec("rm /home/" + _username + "/Desktop/technopos.desktop", function () { })
													_m.exec("rm /home/" + _username + "/Desktop/TechnoPOS.desktop", function () { })

													app._m.fs.writeFile('/home/' + _username + '/Desktop/AzimutPOS.desktop',
														'[Desktop Entry]\n' +
														'Encoding=UTF-8\n' +
														'Comment=Lancer AzimutPOS\n' +
														'Type=Application\n' +
														'Name=AzimutPOS\n' +
														'Exec=/bin/bash /home/' + _username + '/AzimutPOS/etc/scripts/launcher/AzimutPOS.sh\n' +
														'Icon=/home/' + _username + '/AzimutPOS/AzimutPOS.png\n' +
														'Type=Application\n' +
														'Terminal=false\n' +
														'Path=\n' +
														'StartupNotify=false\n', function () {
														});
												}
												_setProgress(90);
												console.log('Cache moved.');
												app.status = 'shutdown';
												let _doRestart = function () {
													const { execPath, platform } = nw.process;
													let
														_shell = true,
														_cwd = '/',
														exePath = '',
														restartFile = 'etc/scripts/launcher/AzimutPOS',
														command = '', args = [];
													if (platform === 'darwin') {
														restartFile += '.sh';
														args.push('mac');
														command = 'bash';
														//app._m.fs.writeFileSync(wantedRootDir + 'etc/scripts/restart/restart.sh', app._m.fs.readFileSync(app._appPath + 'etc/scripts/restart/restart.sh').toString());
													}
													else if (platform.indexOf('win') != -1) {
														//exePath = execPath.replace(/\s/g, '\\ ');
														restartFile = '';
														//_shell = false;
														command = 'AzimutPOS.bat';
														args.push('/min');
														_cwd = 'etc\\scripts\\launcher';
														//args.push('restart.bat');
														//app._m.fs.writeFileSync(app.baseDir + 'etc\\scripts\\restart\\restart.bat', app._m.fs.readFileSync(app._appPath + 'etc\\scripts\\restart\\restart.bat').toString());
													}
													else if (platform.indexOf('linux') != -1) {
														exePath = execPath;
														restartFile += '.sh';
														args.push('linux');
														command = 'bash';
														//app._m.fs.writeFileSync(app.baseDir + 'etc/scripts/restart/restart.sh', app._m.fs.readFileSync(app._appPath + 'etc/scripts/restart/restart.sh').toString());
													}
													if (restartFile)
														args.unshift(restartFile);
													if (exePath) args.push(exePath);
													try {
														console.log({ command, args, cwd: wantedRootDir + _cwd })
														let s = _m.spawn(command, args, { detached: true, shell: _shell, cwd: wantedRootDir + _cwd });
														s.stdout.on('data', function (l) { console.log(l.toString().trim()) });
														s.stderr.on('data', function (l) { console.log(l.toString().trim()) });
														setTimeout(function () { s.unref(); }, 300);
													} catch (er) { console.error('FAILED TO SPAWN RESTART SCRIPT', er.message) }
													app.exit(0)
												};
												_doRestart();
											})
										})
										//unzip -o -q _tposrootDir/updates/*.zip
									});

								});
							} catch (er) {

							}
						});
					});
				});
				return;
			}
			if (fs.existsSync(wantedRootDir.replace('AzimutPOS', 'TechnoPOS')) && fs.existsSync(wantedRootDir)) {
				//remove old directory
				_m.fs.rmdir(wantedRootDir.replace('AzimutPOS', 'TechnoPOS'), { recursive: true }, function () {

				});
			}
		}
		//
		//return;


		//return;
		//app.tray = new nw.Tray({ title: 'AzimutPOS', icon: './AzimutPOS.png' });
		_m.fs.ensureDir(app.cacheDir, function (err) {
			if (err) console.error('Cannot create cache dir', err.code || err)
			if (platform.indexOf('win') === 0) {
				//_m.exec('powershell -inputformat none -outputformat text -NonInteractive -Command Get-MpPreference | find /i "ExclusionPath"', function (e, r, s) {
				//	//console.log(e, r, s);
				//	if (r && r.indexOf('ExclusionPath') != -1) {
				//		r = r.split(':').pop().trim();
				//		if (r.indexOf(app.baseDir) == -1) {
				//			_m.exec('powershell -inputformat none -outputformat none -NonInteractive -Command Add-MpPreference -ExclusionPath "' + app.baseDir + '"', function () { })
				//		}
				//	}
				//	//_m.exec('powershell -inputformat none -outputformat none -NonInteractive -Command Add-MpPreference -ExclusionPath "'+app.baseDir+'"',function(){})
				//})
				//hide windows folder in plain sight
				try {
					_m.exec('attrib +s +h "' + app.cacheDir + '"', function (err, stdout, stderr) {
						if (err || stderr) console.warn(err, stdout, stderr)
					})
				} catch (er) { console.error(er) }
				app.cacheDir = app.cacheDir + '\\';
			}
			app.tmp_folder = app.cacheDir + 'tmp' + (platform.indexOf('win') === 0 ? '\\' : '/')
			_m.fs.rmdir(app.tmp_folder + '*', { recursive: true }, function () {
				_m.fs.ensureDir(app.tmp_folder, function (err) {
					if (err && err.code != 'EEXIST') {
						console.error("Error creating tmp folder " + app.tmp_folder + ', ' + (err.message || err.code || err));
						return;
					}
				});
			})
			app.openLogFiles(function () {
				app.loadConfig();
				let _keepItRunning = setInterval(function () {
					//keep it running
					if (app.status == 'shutdown') clearInterval(_keepItRunning);
				}, 1000)

				console.log('########   app base dir "' + app._appPath + '" ############')
				app.initialize();

				app.status = 'on';
			});
		});

	}
	loadConfig() {

		if (fs.existsSync(_baseDIR + '/manifest.json')) {
			try {
				if (app.isSDK) console.log('loading manifest from', _baseDIR + '/manifest.json')
				app.manifest = require(_baseDIR + '/manifest.json');
				console.log('########   App version ' + app.manifest.version + ' ' + (app.manifest.channel || '') + ' ############')
			}
			catch (er) { }
		}
		app.cfg = {};
		if (app.isSDK) console.log('loading config from', _baseDIR + '/etc/config.json')
		if (fs.existsSync(_baseDIR + '/etc/config.json')) {
			try {
				app.cfg = JSON.parse(fs.readFileSync(_baseDIR + '/etc/config.json').toString());
			} catch (er) {
				console.warn('Couldnt load "' + _baseDIR + '/etc/config.json' + '" ' + er.message)
			}
		}
		else console.warn('Couldnt load "' + _baseDIR + '/etc/config.json' + '"')

		if (app.isSDK) url = '' + urls.dev;
		try {
			url = fs.readFileSync(_baseDIR + '/etc/urlOverride.txt', { encoding: "utf8" }).trim().split('\n')[0].trim();
		} catch (e) { }
		try {
			if (app.isSDK)
				url = fs.readFileSync(app.baseDir + 'etc/urlOverride.txt', { encoding: "utf8" }).trim().split('\n')[0].trim();
		} catch (e) { }
		if (url == 'LIVE') url = '' + urls.live;
		app.cfg.url = '' + url;
		if (!app.cfg.loglevel) app.cfg.loglevel = 3;
		app.cfg.updatesUrl = _updatesURL;
		app.cfg.platform = platform;
	}
	openLogFiles(cback) {

		_m.fs.ensureDir(app.baseDir + 'logs', function (err) {
			if (err && err.code != 'EEXIST') {
				console.error("Error creating logs folder " + app.baseDir + 'logs' + ', ' + (err.message || err.code || err));

				return;
			}


			logFile = fs.createWriteStream(app.baseDir + 'logs/app.log', { flags: 'a' });

			try { logFile.write(os.EOL + "Starting at " + new Date().toISOString() + (app.isSDK ? ' SDK ' : '') + os.EOL); } catch (er) { console.error('Error init log file', er) }
			if (preLogs?.length) {
				for (let i of preLogs) {
					logFile.write(i + os.EOL);
				}
				preLogs = [];
			}
			logFileError = fs.createWriteStream(app.baseDir + 'logs/app_error.log', { flags: 'a' });
			if (cback) cback();
		});
	}
	initialize() {


		//console.info("app.initialize()");
		app._startUniqueProcServer(function () {
			//if (app.pos.win) app.pos.win.Window.get().show();
			try {
				fs.readFile(_baseDIR + '/libs/locales.json', function (err, locales) {
					if (err) console.error(err);
					app.locales = JSON.parse(locales);
					app.splashscreen = new (require(_baseDIR + "/libs/splashscreen/splashscreen.js"))(app);
					try {
						app.splashscreen.initialize(function () {
							//console.log('splash inited')
							//setTimeout(function () {

							app.loadRequirements(function () {
								//console.log('app.loadRequirements completed')
								try {
									app.splashscreen.step1();
									let
										_doSystem = function () {
											//console.log('_doSystem')
											try {
												app.system = require(_baseDIR + "/libs/system/system.js");
												_doDiag();
											} catch (er) { console.error('could not load system.js', er.message); setTimeout(_doSystem, 1000); }
										},
										_doDiag = function () {
											//console.log('_doDiag')
											try {
												app.diag = require(_baseDIR + "/libs/diag/diag.js");
												_doSessions();
											} catch (er) { console.error('could not load diag.js', er.message); setTimeout(_doDiag, 1000); }
										},
										_doSessions = function () {
											//console.log('_doSessions')
											try {
												app.sessions = require(_baseDIR + "/libs/sessions/sessions.js");
												_doWeb();
											} catch (er) { console.error('could not load sessions.js', er.message); setTimeout(_doSessions, 1000); }
										},
										_doWeb = function () {
											//console.log('_doWeb')
											try {
												app.web = new (require(_baseDIR + "/libs/web/web.js"))(url, 'technoPOS_device', app);
												_doPos();
											} catch (er) { console.error('could not load web.js', er.message); setTimeout(_doWeb, 1000); }
										},
										_doPos = function () {
											//console.log('_doPos')
											try {
												app.pos = new (require(_baseDIR + "/libs/pos/pos.js"))(app);
												_doOther();
											} catch (er) { console.error('could not load pos.js', er.message); setTimeout(_doPos, 1000); }
										},
										_doOther = function () {
											//console.log('_doOther')
											try {
												app.printManager = new (require(_baseDIR + "/libs/printManager/printManager.js"))(app);
											} catch (er) { console.error('could not load printManager.js', er.message); return; }
											try {
												//console.log('app.system.initialize')
												app.system.initialize(app, function () {
													//console.log('app.system.initialize done')
													app.splashscreen.win.window.setProgress(10);
													app.splashscreen.setMessage('checking_updates', app.parseLocales('splash.startup_steps.checking_updates'));
													app.system.update.check(null, function () {
														app.splashscreen.unsetMessage('checking_updates');
														app.splashscreen.step2();
														app.sessions.initialize(app);
														app.web.initialize(function () {

															app.diag.initialize(app, function () {
																app.system.networkInitialized();
																setTimeout(app.cleanPreviousFolders, 5000);
															});
														});
													});
												});
											} catch (er) { console.error('could not system.initialize', er.message); return; }
										};
									_doSystem();
									//app.diag = require(_baseDIR + "/libs/diag/diag.js");
									//app.sessions = require(_baseDIR + "/libs/sessions/sessions.js");
									//app.web = new (require(_baseDIR + "/libs/web/web.js"))(url, 'technoPOS_device', app);
									//app.pos = new (require(_baseDIR + "/libs/pos/pos.js"))(app);
								} catch (er) { console.error('cant load modules', er) }
							})
							//}, 1000 * 30);
						});
					} catch (er) {
						console.error('Err on splash.init', er)
					}
				});
			} catch (er) { console.error(er.message) }
		});
	}
	_startUniqueProcServer(cback) {
		cback();
		return;

		//var ipcServer = _m.http.createServer(function (request, response) {
		//	console.log('GOT A REQUEST ON PORT 37561', request.url)
		//	if (request && request.url == '/show' && app.pos.win) {
		//		try {
		//			app.pos.showWindow();
		//		}
		//		catch (er) { console.error(er.message) }
		//	}
		//	response.end('OK');
		//});
		//
		//ipcServer.on('error', function (error) {
		//	console.error('ipcServer error', error.errno)
		//	if (error.errno === 'EADDRINUSE') {
		//		_m.http.get('http://127.0.0.1:37561/show', function (response) {
		//			process.exit(0);
		//		});
		//	}
		//	else process.exit(1);
		//});
		//
		//ipcServer.listen(37561, '127.0.0.1', function () {
		//	console.log('ipcServer listening on 127.0.0.1:37561 ...')
		//});
	}
	cleanPreviousFolders() {
		runPath = process.mainModule.paths[0].replace('\\node_modules', '').replace('/node_modules', '');
		if (app.cfg.platform.indexOf('mac') === 0 || app.cfg.platform.indexOf('osx') === 0) return;
		try {
			let

				me = runPath.split(app.cfg.platform.indexOf('win') != -1 ? '\\' : '/').pop(),
				fldr = runPath.replace(me, '');
			//console.log('looking in', fldr, 'i\'m', me);
			_m.fs.readdir(fldr, "utf8", function (err, list) {
				_m.async.eachSeries(list, function (l, n) {
					if (l != me) {
						let _match = null;
						if (app.cfg.platform.indexOf('linux') === 0)
							_match = l.match(/^\.io\.nwjs\./);
						else
							_match = l.match(/^nw[\d]+_[\d]+/);
						if (_match && _match[0] && _m.fs.existsSync(fldr + l)) {
							//console.log('Removing', fldr + l)
							try {
								app.deleteFolderRecursive(fldr + l, function () {
									process.nextTick(n);
								});
								return;
							} catch (er) { }
						}
					}
					process.nextTick(n);
				}, function () {
					//all done
				});
			})
		} catch (er) { }
	}
	deleteFolderRecursive(path, cback) { // app.deleteFolderRecursive()
		if (_m.fs.existsSync(path)) {
			_m.fs.readdirSync(path).forEach(function (file, index) {
				var curPath = path + "/" + file;
				if (_m.fs.lstatSync(curPath).isDirectory()) { // recurse
					app.deleteFolderRecursive(curPath);
				} else { // delete file
					_m.fs.unlinkSync(curPath);
				}
			});
			_m.fs.rmdirSync(path);
		} else {
			//console.log('error -- fs.existsSync(path) path is not good -- ',path)
		}
		if (typeof cback != 'undefined' && cback)
			cback();
	}
	getIPFromHeaders(req) {
		var ip =
			app.pathExists(req, 'headers.x-real-ip') ||
			app.pathExists(req, 'headers.x-forwarded-for') ||
			app.pathExists(req, 'connection.remoteAddress') ||
			app.pathExists(req, 'client.request.headers.x-real-ip') ||
			app.pathExists(req, 'client.request.headers.x-forwarded-for') ||
			app.pathExists(req, 'client.conn.remoteAddress') ||
			app.pathExists(req, 'request.connection.remoteAddress') ||
			app.pathExists(req, 'conn.remoteAddress') ||
			app.pathExists(req, 'ip') ||
			null;
		if (ip == '::1') ip = '127.0.0.1';
		if (ip && ip.indexOf(',') != -1)
			ip = ip.split(',').shift();
		ip = (ip || '').toString().replace('::ffff:', '');
		req.ip = '' + ip;
		return ip;
	}
	getIPFromSocket(s) {
		return app.getIPFromHeaders(s);
	}
	isEmptyObject(obj) { // app.isEmptyObject()
		for (var prop in obj) {
			if (obj.hasOwnProperty(prop))
				return false;
		}
		return true;
	}
	loadRequirements(cback) {

		//console.log('app.loadRequirements')
		try {
			let _hasError = false;
			try {
				_m.xtend = require(_baseDIR + '/libs/system/libs/cloneextend.js');
			} catch (er) { _hasError = true; console.error('loading xtend', er); }
			try {
				_m.http = require('http');
			} catch (er) { _hasError = true; console.error('loading http', er); }
			try {
				_m.bcrypt = require('bcryptjs');
			} catch (er) { _hasError = true; console.error('loading bcryptjs', er); }

			try {
				_m.IPrangeCheck = require('range_check');
			} catch (er) { console.error('loading range_check', er); }
			try {
				_m.evilDns = require(_baseDIR + '/libs/system/libs/evildns.js');
				_m.evilDns.add('server.technopos.lan', '192.168.94.1');
				_m.evilDns.add('*.technopos.lan', '192.168.94.1');
				_m.evilDns.add('server.azimutpos.lan', '192.168.94.1');
				_m.evilDns.add('*.azimutpos.lan', '192.168.94.1');
			} catch (er) { _hasError = true; console.error('loading evldns', er); }
			try {
				_m.moment = require('moment-timezone');
			} catch (er) { console.error('loading moment', er); }
			if (!_m.moment) {
				try {
					_m.moment = require('moment');
				} catch (er) { _hasError = true; console.error('loading moment', er); }
			}
			try {
				_m.uuid = require('uuid');
			} catch (er) { _hasError = true; console.error('loading uuid', er); }
			try {
				_m.osUtils = require('os-utils');
			} catch (er) { _hasError = true; console.error('loading utils', er); }
			try {
				_m.serialport = require("chrome-apps-serialport").SerialPort;
			} catch (er) { _hasError = true; console.error('loading serialPort', er); }
			try {
				_m.microtime = require('microtime');
			} catch (er) {
				_m.microtime = {
					now: function () {
						return new Date().getTime() * 1000;
					}
				}
			}
			try {
				_m.cron = require('cron').CronJob;
			} catch (er) { _hasError = true; console.error('loading cron', er); }
			try {
				_m.crypto = require('crypto');
			} catch (er) { _hasError = true; console.error('loading crypto', er); }
			try {
				_m.request = require('request');
			} catch (er) { _hasError = true; console.error('loading request', er); }
			try {
				_m.logrotate = require('logrotator');
			} catch (er) { _hasError = true; console.error('loading logrotator', er); }
			try {
				_m.IPrangeCheck = require('range_check');
			} catch (er) { _hasError = true; console.error('loading rangecheck', er); }
			try {
				_m.dns = require('dns');
			} catch (er) { _hasError = true; console.error('loading dns', er); }
			try {
				_m.ndns = require('native-dns');
			} catch (er) { _hasError = true; console.error('loading ndns', er); }
			try {
				_m.ping = require('ping');
			} catch (er) { _hasError = true; console.error('loading ping', er); }
			try {
				_m.csv = require('csv');
			} catch (er) { _hasError = true; console.error('loading csv parser', er); }



			try {
				fs.access(app.baseDir + 'logs/app.log', fs.constants.F_OK | fs.constants.R_OK, function (err) {
					if (err) {
						console.error(app.baseDir + 'logs/app.log', err.code);
					} else {
						try {
							app.logRorate = _m.logrotate.create();
							app.logRorate.register(app.baseDir + 'logs/app.log', _m.xtend.extend({ schedule: '5m', size: '5m', compress: true, count: 5 }, {}));
							app.logRorate.on('rotate', function (file) {
								console.info('LogRotate: file ' + file + ' was rotated!');
							});
						} catch (er) { console.error('logRotator', _f.name, er.message); }
					}
				});
			} catch (er) { console.error('logrotate app.log', er) }
			try {
				fs.access(app.baseDir + 'logs/app_error.log', fs.constants.F_OK | fs.constants.R_OK, function (err) {
					if (err) {
						console.error(app.baseDir + 'logs/app_error.log', err.code);
					} else {
						try {
							app.logRorateError = _m.logrotate.create();
							app.logRorateError.register(app.baseDir + 'logs/app_error.log', _m.xtend.extend({ schedule: '5m', size: '5m', compress: true, count: 5 }, {}));
							app.logRorateError.on('rotate', function (file) {
								console.info('LogRotate: file ' + file + ' was rotated!');
							});
						} catch (er) { console.error('logRotator', _f.name, er.message); }
					}
				});
			} catch (er) { console.error('logrotate app_error.log', er) }

			try {
				app.io = require('socket.io-client');
			} catch (er) { _hasError = true; console.error('loading io client', er); }
			try {
				_m.io = require('socket.io');
			} catch (er) { _hasError = true; console.error('loading io', er); }
			try {
				if (app.cfg.platform.indexOf('linux') === 0) {
					if (fs.existsSync(app.baseDir + 'azimutPOS.pid') && fs.readFileSync(app.baseDir + 'azimutPOS.pid').toString() != process.pid) {
						console.warn('PID MISMATCH');
					}
					fs.writeFile(app.baseDir + 'azimutPOS.pid', '' + process.pid, function () { });
					app.cfg.platform = 'linux64';
				}
				if (app.cfg.platform.indexOf('osx') === 0) {
					if (fs.existsSync(app.baseDir + 'azimutPOS.pid') && fs.readFileSync(app.baseDir + 'azimutPOS.pid').toString() != process.pid) {
						console.warn('PID MISMATCH');
					}
				}
			} catch (er) { _hasError = true; console.error('setting PID', er); }
			try {
				_m.fs.ensureDir(app.tmp_folder, function (err) {
					if (err)
						console.log('Ensuredir tmp_folder error', err);
					if (err && err.code != 'EEXIST') {
						console.error("Error creating tmp folder " + app.tmp_folder + ', ' + (err.message || err.code || err));

						return;
					}
					console.info("Created tmp folder " + app.tmp_folder);

					app.cfg.userAgent = nw.global.clientInformation.userAgent + ' ' + app.cfg.platform;
					app.fork = _m.fork;



					app.queueProc = require(_baseDIR + '/libs/system/libs/queueproc.js')
					app.queueProc._init(app);

					try { if (!_hasError) cback(); } catch (er) { console.error('init cback error', er) }
				})
			} catch (er) {
				console.error('Error with dir', app.tmp_folder, er.message)
			}
		}
		catch (er) {
			console.error('Error init', er)
		}
	}
	notification(vars) {
		var Notifications = require('nw-notifications');
		Notifications.setLogger({ info: function () { }, error: function () { } })
		let _c = {
			iconUrl: 'http://localhost:4202/AzimutPOS.png',
			title: 'AzimutPOS: ' + vars.title,
			message: vars.message
		};
		if (vars.buttons) _c.buttons = vars.buttons;
		var notification = Notifications.create(_c);
		if (vars.timeout) Notifications.setDisplayTime(1000 * vars.timeout);
		notification.on('shown', function () {
			// displayed
			if (vars.shown) vars.shown();
		});
		notification.on('buttonClicked', function (idx) {
			if (vars.buttonClicked) vars.buttonClicked(idx);
		});
		notification.on('clicked', function () {
			// clicked message body
			if (vars.clicked) vars.clicked();
		});

		notification.on('closed', function (reason) {
			// CLOSED_BY_USER
			// CLOSED_BY_TIMEOUT
			// CLOSED_BY_CLICK
			if (vars.closed) vars.closed(reason);
		});
	}


	tryCatch(f) {
		/**
		 * app.tryCatch
		 * @param fallback
		 * @returns mixed null or error
		 */
		try {
			return f();
		}
		catch (er) {
			if (!er.stack) {
				console.error(er)
				return er;
			}
			var stk = er.stack.split("\n"), parent = '', parent1 = '', errorLine = '';
			for (var i = 0; i < stk.length; i++)
				stk[i] = stk[i].trim();
			var caller = '';
			try {
				caller = stk[1].match(/at (\S+)/)[1];
			} catch (er) { }
			var _continues = ['tryCatch', '/async.js'], _breaks = ['/db.js'];
			//console.log(stk)
			for (var i = 1; i < stk.length; i++) {
				var _continue = false;
				for (var x = 0; x < _continues.length; x++) {
					if (stk[i].indexOf(_continues[x]) != -1) {
						_continue = true;
						break;
					}
				}
				if (_continue) continue;
				var _break = false;
				for (var x = 0; x < _breaks.length; x++) {
					if (stk[i].indexOf(_breaks[x]) != -1) {
						_break = true;
						break;
					}
				}
				if (_break) break;
				if (!errorLine) {
					var _p = stk[i].match(/at (\S+) \((\S+)\)/);
					if (_p) {
						errorLine = _p[1] + ' @ ' + _p[2];
					}
					else errorLine = stk[i];
					i++;
					continue;
				}
				if (!parent) {
					var _p = stk[i].match(/at (\S+) \((\S+)\)/);
					if (_p) {
						parent = _p[1] + ' @ ' + _p[2];
					}
					else parent = stk[i];
					continue;
				}
				if (!parent1) {
					var _p = stk[i].match(/at (\S+) \((\S+)\)/);
					if (_p) {
						parent1 = _p[1] + ' @ ' + _p[2];
					}
					else parent1 = stk[i];
					continue;
				}
			}
			errorLine = errorLine.replaceAppAndModulesPath();
			caller = caller.replaceAppAndModulesPath().replace(/^at /, '').trim();
			parent = parent.replaceAppAndModulesPath().replace(/^at /, '').trim();
			parent1 = parent1.replaceAppAndModulesPath().replace(/^at /, '').trim();
			console.error(
				er.message + ' ' + errorLine +
				(caller ? ' called by ' + caller : '') +
				(parent ? ' parent ' + parent : '') +
				(parent1 ? ' 2nd parent ' + parent1 : ''));
			return {
				code: er.code,
				message: er.message,
				file: errorLine,
				caller: caller,
				parent: parent,
				parent1: parent1,
				fullstack: er
			};
		}
	}
	parseLocales(path, locale) {
		if (!path) return null;
		if (!locale)
			locale = this.locale;
		if (typeof path == "string")
			path = path.split('.');
		if (path[0] == 'locales')
			path.pop();
		var locales = { ...this.locales };
		for (let p of path)
			locales = locales?.[p];
		return locales?.[locale];
	}
	pathToObject(obj, path, value) {
		var
			paths = path.split('.'),
			current = obj,
			i;
		for (i = 0; i < paths.length; ++i) {
			if (i + 1 == paths.length)
				current[paths[i]] = value;
			else if (current[paths[i]] === undefined) {
				current[paths[i]] = {};
			}
			current = current[paths[i]];
		}
		return obj;
	}
	deletePropertyPath(obj, path) {
		var
			paths = path.split('.'),
			current = obj,
			i;
		for (i = 0; i < paths.length; ++i) {
			if (i + 1 == paths.length)
				delete current[paths[i]];
			else if (current[paths[i]] === undefined) {
				return obj;
			}
			current = current[paths[i]];
		}
		return obj;
	}
	regIDtoMAC(id) {
		return id.split('REG-').pop().match(/.{1,2}/g).join(':').toLowerCase();
	}
	restart(force) {
		app.status = 'shutdown';
		let _doRestart = function () {

			const { execPath, platform } = nw.process;
			let
				_shell = true,
				_cwd = '',
				exePath = '',
				restartFile = 'etc/scripts/restart/restart',
				command = '', args = [];
			if (platform === 'darwin') {
				restartFile += '.sh';
				args.push('mac');
				command = 'bash';
				app._m.fs.writeFileSync(app.baseDir + 'etc/scripts/restart/restart.sh', app._m.fs.readFileSync(app._appPath + 'etc/scripts/restart/restart.sh').toString());
			}
			else if (platform.indexOf('win') != -1) {
				//exePath = execPath.replace(/\s/g, '\\ ');
				restartFile = '';
				_shell = false;
				command = 'restart.bat';
				args.push('/min');
				_cwd = 'etc\\scripts\\restart';
				//args.push('restart.bat');
				app._m.fs.writeFileSync(app.baseDir + 'etc\\scripts\\restart\\restart.bat', app._m.fs.readFileSync(app._appPath + 'etc\\scripts\\restart\\restart.bat').toString());
			}
			else if (platform.indexOf('linux') != -1) {
				exePath = execPath;
				restartFile += '.sh';
				args.push('linux');
				command = 'bash';
				app._m.fs.writeFileSync(app.baseDir + 'etc/scripts/restart/restart.sh', app._m.fs.readFileSync(app._appPath + 'etc/scripts/restart/restart.sh').toString());
			}
			if (restartFile)
				args.unshift(restartFile);
			if (exePath) args.push(exePath);
			try {

				let s = _m.spawn(command, args, { detached: true, shell: _shell, cwd: app.baseDir + _cwd });
				s.stdout.on('data', function (l) { console.log(l.toString().trim()) });
				s.stderr.on('data', function (l) { console.log(l.toString().trim()) });
				setTimeout(function () { s.unref(); }, 300);
			} catch (er) { console.error('FAILED TO SPAWN RESTART SCRIPT', er.message) }
			app.exit(0)
		};
		if (force || app.system.update.hasUpdated) _doRestart();
		else
			app.exit(0, _doRestart);
	}

	startPOS() {
		app.pos.initialize();
	}

	exit(exitCode, restart) {
		console.log('app.exit', exitCode, app.status, typeof restart == 'function' ? 'restart' : '')
		if (app.status == 'shutdown' && typeof restart != 'function') return false;
		app.status = 'shutdown';
		//console.warn((new Error()).stack)
		console.warn(typeof restart != 'undefined' ? 'RESTART' : 'EXIT ' + exitCode)
		if (typeof exitCode != 'number')
			exitCode = 0;
		let _catchTimer = setTimeout(function () {
			console.warn('Process has not exited after 3s, force.')
			try { _m.exec('killall TechnoPOS', function () { }) } catch (er) { console.info(er.message) }
			try { _m.exec('pkill TechnoPOS', function () { }) } catch (er) { console.info(er.message) }
			try { _m.exec('killall AzimutPOS', function () { }) } catch (er) { console.info(er.message) }
			try { _m.exec('pkill AzimutPOS', function () { }) } catch (er) { console.info(er.message) }
			process.exit(exitCode);
		}, 1000 * 3);
		//do Things
		try {
			if (app.tray)
				app.tray.remove();
			app.tray = null;

		} catch (er) { console.info(er.message) }
		try {

			logFile.close();
		} catch (er) { }
		try {
			let _modules = Object.keys(app);
			for (let i = 0; i < _modules.length; i++) {
				if (app[_modules[i]] && app[_modules[i]].shutdown)
					try { app[_modules[i]].shutdown(); } catch (er) { }
			}
		} catch (er) { }
		try {
			app.splashscreen.win.close();
		} catch (er) { console.info(er.message) }
		try {
			app.pos.exit();
		} catch (er) {
			console.error('Error while exiting pos', er.message)
		}
		setTimeout(function () {
			//_m.exec('taskkill /f /im TechnoPOS.exe',function(){});
			if (restart) {
				try {
					chrome.runtime.reload();
					return

				} catch (er) {
					console.error('runtime.reload error', er.message)
				}
				setTimeout(function () {
					restart();
				}, 2000);
				return;
			}
			_m.async.each([
				function (n) {
					try {
						fs.unlink(app.baseDir + 'azimutPOS.pid', function () {
							//process.exit(exitCode);
							n();
						});
					} catch (er) { console.error('Unable to remove PID file', er.message); n(); }
				},
				function (n) {
					try {
						fs.unlink(runPath, function () {
							//process.exit(exitCode);
							n();
						});
					} catch (er) {
						console.error('Unable to remove runPath', er.message)
						n();
					}
				},
				function (n) {
					try {
						fs.unlink(app.tmp_folder, function () {

							n();
						});
						return;
					} catch (er) {
						console.error('Unable to remove tmp_folder', er.message)
						n();
					}
				}
			], function (f, n) {
				f(n);
			}, function () {
				clearTimeout(_catchTimer);
				setTimeout(function () {
					process.nextTick(function () {
						try { _m.exec('killall TechnoPOS', function () { }) } catch (er) { }
						try { _m.exec('pkill TechnoPOS', function () { }) } catch (er) { }
						try { _m.exec('killall AzimutPOS', function () { }) } catch (er) { }
						try { _m.exec('pkill AzimutPOS', function () { }) } catch (er) { }
					});
					console.info('Final exit')
					process.exit(exitCode);
				}, 100)
			})

		}, 500);
	}
	getParentStack(opts) {
		if (!opts) opts = {};

		try {
			var stk = (new Error()).stack.split("\n"), parent = '', parent1 = '', errorLine = '';
			for (var i = 0; i < stk.length; i++)
				stk[i] = stk[i].trim();
			var caller = '';
			var _continues = ['tryCatch', '/async.js'], _breaks = ['/db.js'];
			for (var i = 3; i < stk.length; i++) {
				var _continue = false;
				for (var x = 0; x < _continues.length; x++) {
					if (stk[i].indexOf(_continues[x]) != -1) {
						_continue = true;
						break;
					}
				}
				if (opts.exclude) {
					if (typeof opts.exclude == 'string')
						opts.exclude = [opts.exclude];
					if (opts.exclude.filter(function (a) {
						return typeof a == 'string' ? stk[i].indexOf(a) != -1 : a.test(stk[i]);
					}).length) {
						_continue = true;
						break;
					}
				}
				if (_continue) continue;
				var _break = false;
				for (var x = 0; x < _breaks.length; x++) {
					if (stk[i].indexOf(_breaks[x]) != -1) {
						_break = true;
						break;
					}
				}
				if (_break) break;
				if (stk[i].indexOf('getParentStack') == -1) {
					if (!caller) {
						var _p = stk[i].match(/at (\S+) \((\S+)\)/);
						if (_p) {
							caller = _p[1] + ' @ ' + _p[2];
						}
						else caller = stk[i];
						continue;
					}
					if (!parent) {
						var _p = stk[i].match(/at (\S+) \((\S+)\)/);
						if (_p) {
							parent = _p[1] + ' @ ' + _p[2];
						}
						else parent = stk[i];
						continue;
					}
					if (!parent1) {
						var _p = stk[i].match(/at (\S+) \((\S+)\)/);
						if (_p) {
							parent1 = _p[1] + ' @ ' + _p[2];
						}
						else parent1 = stk[i];
						continue;
					}
				}
			}
			caller = caller.replaceAppAndModulesPath().replace(/^at /, '').trim();
			parent = parent.replaceAppAndModulesPath().replace(/^at /, '').trim();
			parent1 = parent1.replaceAppAndModulesPath().replace(/^at /, '').trim();
			return opts.callerOnly ? caller : caller + ',' + parent + (parent1 ? ' 2nd parent ' + parent1 : '');
		}
		catch (e) { }
		return '';
	}

	loadSubModules(obj, path, folder, cback) {
		if (typeof folder == 'function') {
			cback = folder;
			folder = null;
		}
		if (!folder) folder = 'modules';
		var files = [];
		if (app._m.fs.existsSync(path + '/' + folder)) {
			app._m.fs.readdirSync(path + '/' + folder).filter(function (file) {
				file = file.replace('.js', '');
				if (app._m.fs.existsSync(path + '/' + folder + '/' + file + '/' + file + '.js'))
					files.push(file);
			});
		}
		var out = {};
		_m.async.each(files, function (file, next) {
			var _nexted = false;
			//console.log(path+'/modules/'+file+'/'+file+'.js')
			obj[file] = require(path + '/' + folder + '/' + file + '/' + file + '.js');
			out[file] = obj[file];
			if (typeof obj[file]._init != 'undefined') {
				var _cbackTimer = setTimeout(function () {
					if (_nexted) return;
					console.warn((path + '/' + folder + '/' + file + '/' + file).replace(app._appPath, '') + '.js HAS NO _init cback, continue.');
					_nexted = true;
					next();
				}, 1000 * 30);
				app.tryCatch(function () {
					if (_nexted) return;
					obj[file]._init(app, function () {
						if (_nexted) return;
						clearTimeout(_cbackTimer);
						_nexted = true;
						next();
					});
				});
			}
			else {
				console.warn((path + '/' + folder + '/' + file + '/' + file).replace(app._appPath, '') + '.js HAS NO _init, skip');
				_nexted = true;
				next();
			}
		}, function () { if (cback) cback(); });
		return out;
	}

	pathExists(o, p, options) { // app.pathExists()
		if (!options) options = {};

		if (!o || !p) return undefined;
		p = (p + '').replace(/^\./, '');
		var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
		m = m.filter(function (a) { return a.length; });
		if (m.length > 1 && !m[0])
			m.shift();
		var cm = o;
		for (var i = 0; i < m.length; i++) { // Here we need to take special care of possible method calls and arrays, but I am too lazy to write it down.
			if (cm == null)
				return options.existsOnly ? true : null;
			if (typeof cm[m[i]] !== 'undefined')//if(currentMember.hasOwnProperty(members[i]))
				cm = cm[m[i]];
			else return undefined;
		}
		return options.existsOnly ? typeof cm != 'undefined' : cm;
	}
	pathExistsLegacy(o, p) { // app.pathExists()
		if (!o || !p) return false;
		p = p + '';
		var m = (p.indexOf('.') != -1) ? p.split(".") : [p];
		if (m.length > 1 && !m[0])
			m.shift();
		var cm = o;
		for (var i = 0; i < m.length; i++) { // Here we need to take special care of possible method calls and arrays, but I am too lazy to write it down.
			if (cm == null)
				return false;
			if (typeof cm[m[i]] !== 'undefined')//if(currentMember.hasOwnProperty(members[i]))
				cm = cm[m[i]];
			else
				return false;
		}
		return cm;
	}

	async _asyncWait(t) {
		return new Promise(async resolve => {
			setTimeout(async () => { resolve() }, t);
		});
	}
	watch(file, cback) {
		let fsWait, _unwatch = function () {
			//console.log('unwatch', file);
			try {
				_w.close();
			} catch (er) { }
		}, _w = fs.watchFile(file, { persistent: true }, (c, p) => {
			if (c) {
				clearTimeout(fsWait)
				//console.log('watch event', file, c, p)
				fsWait = setTimeout(() => {
					cback(c, p, _unwatch);
				}, 200);

			}
		});
	}

	weightedRandom(items, options) {
		if (!options) options = {};
		//items is object or array
		//items={A:1,B:3,C:7}
		//items=[
		//	{
		//		value:'anything',
		//		weight:1 to 10
		//	}
		//]
		if (!Array.isArray(items)) items = Object.keys(items).map(function (k) { return { value: k, weight: items[k] }; });
		if (options.iterations && options.iterations > 1) {
			let out = {}, total = 0;
			for (let i = 0; i < iterations; i++) {
				let _r = app.weightedRandom(items);
				if (!out[_r]) out[_r] = 0;
				out[_r]++;
				total++;
			}
			out = Object.keys(out).
				map(function (k) { return { value: k, count: out[k], votes: out[k] / total * 100 } }).
				sort(function (a, b) {
					return a.votes > b.votes ? -1 : 1;
				});
			return options.getAll ? out : out[0];
		}
		let totalChances = 0, chances = [];
		for (let i = 0; i < items.length; i++) {
			totalChances += parseInt(items[i].weight);
		}
		//convert to %
		for (let i = 0; i < items.length; i++) {
			chances.push(parseInt(items[i].weight / totalChances * 100));
		}
		//console.log(items,chances)
		var sum = chances.reduce((acc, el) => acc + el, 0);
		var acc = 0;
		chances = chances.map(el => (acc = el + acc));
		var rand = Math.random() * sum;
		return items[chances.filter(el => el <= rand).length].value;
	}
}
var app = new App();
app.eventLoopLag = {
	_history: [],
	_current: null,
	get: function (cback) {
		let start = new Date()
		setTimeout(() => {
			let lag = new Date() - start;
			app.eventLoopLag._current = {
				date: start.toISOString(),
				lag: lag
			};
			app.eventLoopLag._history.push(app.eventLoopLag._current);
			if (app.eventLoopLag._history.length == 30)
				app.eventLoopLag._history.shift();
			//console.log(`Loop ${iteration} took\t${lag} ms`)
			if (cback) cback();
		})
	},
	monitor: function () {
		app.eventLoopLag.get(function () {
			setTimeout(app.eventLoopLag.monitor, 1000 * 30);
		})
	}
};
app.eventLoopLag.monitor();
app.arrays = {};
/**
 * return only one occurence of each values aka unique
 */
app.arrays.unique = function (a) {
	return !a || !a.length ? a : a.filter(function (value, index, self) {
		return self.indexOf(value) === index;
	});
};
/**
 * Shuffles array in place.
 */
app.arrays.shuffle = function (a) {
	if (a && a.length)
		for (var i = a.length - 1; i > 0; i--) {
			var j = Math.floor(Math.random() * (i + 1));
			[a[i], a[j]] = [a[j], a[i]];
		}
	return a;
};
app.JSON = {
	parse: function (json) { //app.JSON.parse
		if (!json || typeof json != 'string')
			return json;
		json = json.trim();
		if (json.charAt(0) == '"' && json.charAt(json.length - 1) == '"') {
			do {
				json = json.substring(1);
				json = json.substring(0, json.length - 1);
			}
			while (json.charAt(0) == '"' && json.charAt(json.length - 1) == '"');
		}
		//return (typeof json=='string' && ['{','['].indexOf(json.charAt(0)))?app.JSON.validate(json):json;
		return app.JSON.validate(json) || json;
	},
	validate: function (str) { //app.JSON.validate
		if (!str)
			return false;
		if (typeof str == 'object') {
			return app.JSON.validate(JSON.stringify(str));
		}
		try {
			return JSON.parse(str.trim().replace(/\\n/g, '\\\\n').replace(/([a-z0-9])\\([a-z0-9])/gi, '$1 $2').replace(/\\\\n/g, '\\n'));
		} catch (e) {
			return false;
		}
		return true;
	}
};
app.hash = {
	Etag: function (file, append) { // app.hash.Etag()
		var out = app.hash.File(file);
		if (typeof append != 'undefined' && append)
			out += append;
		return app.hash.String(out);
	},
	File: function (f, cipher, cback) { // app.hash.File()
		if (typeof cipher == 'function') {
			cback = cipher;
			cipher = 'sha1';
		}
		let cp = _m.fork(_baseDIR + '/libs/system/libs/hash.js');
		cp.on('message', function (m) {
			if (m && m.action) {
				switch (m.action) {
					case 'ready':
						cp.send({
							action: 'File',
							path: f,
							cipher: cipher
						})
						break;
					case 'completed':
						cback(m.data);
						break;
				}
			}
		});
	},
	String: function (s, cipher, cback) { // app.hash.String()
		if (typeof cipher == 'function') {
			cback = cipher;
			cipher = 'sha1';
		}
		let cp = _m.fork(_baseDIR + '/libs/system/libs/hash.js');
		cp.on('message', function (m) {
			if (m && m.action) {
				switch (m.action) {
					case 'ready':
						cp.send({
							action: 'String',
							data: s,
							cipher: cipher
						})
						break;
					case 'completed':
						cback(m.data);
						break;
				}
			}
		});
	}
};
